/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import java.util.Arrays;

public class ResourceModelStatistics {
    private final long since = System.currentTimeMillis();
    private final int[] mappingDurationFrequencies = new int[16];
    private final int[] indexBoundaries = new int[this.mappingDurationFrequencies.length];
    private long instantiations;
    private long mappings;
    private long cacheHits;

    public ResourceModelStatistics() {
        this.reset();
        int boundary = 1;
        for (int i = 0; i < this.indexBoundaries.length; ++i) {
            this.indexBoundaries[i] = boundary;
            boundary *= 2;
        }
    }

    void reset() {
        Arrays.fill(this.mappingDurationFrequencies, 0);
        this.instantiations = 0L;
        this.mappings = 0L;
        this.cacheHits = 0L;
    }

    long getSince() {
        return this.since;
    }

    long getInstantiations() {
        return this.instantiations;
    }

    public ResourceModelStatistics countInstantiation() {
        ++this.instantiations;
        return this;
    }

    public ResourceModelStatistics countSubsequentMapping() {
        ++this.mappings;
        return this;
    }

    long getCacheHits() {
        return this.cacheHits;
    }

    public ResourceModelStatistics countCacheHit() {
        ++this.cacheHits;
        return this;
    }

    long getNumberOfMappings() {
        return this.mappings;
    }

    public ResourceModelStatistics countMappingDuration(int durationInMs) {
        for (int i = 0; i < this.indexBoundaries.length; ++i) {
            if (durationInMs >= this.indexBoundaries[i]) continue;
            int n = i;
            this.mappingDurationFrequencies[n] = this.mappingDurationFrequencies[n] + 1;
            return this;
        }
        int n = this.mappingDurationFrequencies.length - 1;
        this.mappingDurationFrequencies[n] = this.mappingDurationFrequencies[n] + 1;
        return this;
    }

    double getAverageMappingDuration() {
        return this.getTotalMappingDuration() / (double)Math.max(this.getNumberOfMappingDurationSamples(), 1L);
    }

    double getTotalMappingDuration() {
        double totalDuration = 0.0;
        double leftBoundary = 0.0;
        for (int i = 0; i < this.mappingDurationFrequencies.length; ++i) {
            double rightBoundary = this.indexBoundaries[i];
            double intervalMean = (leftBoundary + rightBoundary) / 2.0;
            totalDuration += intervalMean * (double)this.mappingDurationFrequencies[i];
            leftBoundary = this.indexBoundaries[i];
        }
        return totalDuration;
    }

    double getMappingDurationMedian() {
        long numberOfSamples = this.getNumberOfMappingDurationSamples();
        if (numberOfSamples == 0L) {
            return 0.0;
        }
        if (numberOfSamples % 2L != 0L) {
            long sample = (numberOfSamples + 1L) / 2L;
            return this.mappingDurationOf(sample);
        }
        long sample = numberOfSamples / 2L;
        double[] depths = this.mappingDurationOfSampleAndSuccessor(sample);
        double median = (depths[0] + depths[1]) / 2.0;
        return median;
    }

    double getMaximumMappingDuration() {
        for (int i = this.mappingDurationFrequencies.length - 1; i >= 0; --i) {
            if (this.mappingDurationFrequencies[i] == 0) continue;
            double leftHandBoundary = i == 0 ? 0.0 : (double)this.indexBoundaries[i - 1];
            double rightHandBoundary = this.indexBoundaries[i];
            return (leftHandBoundary + rightHandBoundary) / 2.0;
        }
        return 0.0;
    }

    double getMinimumMappingDuration() {
        for (int i = 0; i < this.mappingDurationFrequencies.length; ++i) {
            if (this.mappingDurationFrequencies[i] == 0) continue;
            double leftHandBoundary = i == 0 ? 0.0 : (double)this.indexBoundaries[i - 1];
            double rightHandBoundary = this.indexBoundaries[i];
            return (leftHandBoundary + rightHandBoundary) / 2.0;
        }
        return 0.0;
    }

    int[] getMappingDurationFrequencies() {
        return Arrays.copyOf(this.mappingDurationFrequencies, this.mappingDurationFrequencies.length);
    }

    int[] getMappingDurationIntervalBoundaries() {
        return Arrays.copyOf(this.indexBoundaries, this.indexBoundaries.length);
    }

    private long getNumberOfMappingDurationSamples() {
        long sum = 0L;
        for (int samples : this.mappingDurationFrequencies) {
            sum += (long)samples;
        }
        return sum;
    }

    private double mappingDurationOf(long nthSample) {
        int index = 0;
        long sum = 0L;
        while (sum < nthSample) {
            sum += (long)this.mappingDurationFrequencies[index];
            ++index;
        }
        double leftBoundary = index < 2 ? 0.0 : (double)this.indexBoundaries[index - 2];
        double rightBoundary = this.indexBoundaries[index - 1];
        return (leftBoundary + rightBoundary) / 2.0;
    }

    private double[] mappingDurationOfSampleAndSuccessor(long nthSample) {
        int x1 = -1;
        int x2 = -1;
        int index = 0;
        long samples = 0L;
        do {
            if (x1 == -1 && (samples += (long)this.mappingDurationFrequencies[index]) >= nthSample) {
                x1 = index;
            }
            if (samples < nthSample + 1L) continue;
            x2 = index;
            break;
        } while (++index < this.mappingDurationFrequencies.length);
        double leftHandBoundaryX1 = x1 == 0 ? 0.0 : (double)this.indexBoundaries[x1 - 1];
        double rightHandBoundaryX1 = this.indexBoundaries[x1];
        double leftHandBoundaryX2 = x2 == 0 ? 0.0 : (double)this.indexBoundaries[x2 - 1];
        double rightHandBoundaryX2 = this.indexBoundaries[x2];
        double durationX1 = (leftHandBoundaryX1 + rightHandBoundaryX1) / 2.0;
        double durationX2 = (leftHandBoundaryX2 + rightHandBoundaryX2) / 2.0;
        return new double[]{durationX1, durationX2};
    }
}

