/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.core.util.OsgiModelSource;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LookupResult {
    private final OsgiModelSource<?> source;
    private final String resourceType;
    private final int hashCode;

    public LookupResult(OsgiModelSource<?> source, String resourceType) {
        if (source == null) {
            throw new IllegalArgumentException("Method argument source must not be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Method argument resourceType must not be null.");
        }
        this.source = source;
        this.resourceType = resourceType;
        this.hashCode = new HashCodeBuilder().append(source).append((Object)resourceType).toHashCode();
    }

    public OsgiModelSource<?> getSource() {
        return this.source;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return this.resourceType + " -> [" + this.source + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LookupResult other = (LookupResult)obj;
        return this.source.equals(other.source) && this.resourceType.equals(other.resourceType);
    }
}

