/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.core.resourcemodels.registration.ModelRegistry;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventHandler.class}, property={"event.topics=org/apache/sling/api/resource/Resource/CHANGED", "event.filter=(& (!(path=/content/*)) (!(path=/var/*)) (!(path=/jcr:*)) (!(path=/oak:*)) (|  (resourceAddedAttributes=jcr:mixinTypes)  (resourceAddedAttributes=sling:resourceSuperType)  (resourceChangedAttributes=jcr:mixinTypes)  (resourceChangedAttributes=sling:resourceType)  (resourceChangedAttributes=sling:resourceSuperType)  (resourceRemovedAttributes=sling:resourceSuperType)  (resourceRemovedAttributes=jcr:mixinTypes)))", "service.description=An event handler invalidating cache resource type hierarchy information.", "service.vendor=neba.io"})
public class MappableTypeHierarchyChangeListener
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final BlockingQueue<Object> invalidationRequests = new ArrayBlockingQueue<Object>(1);
    private boolean isShutDown = false;
    @Reference
    private ModelRegistry modelRegistry;

    @Activate
    protected void activate() {
        this.executorService.execute(() -> {
            while (!this.isShutDown) {
                try {
                    Object path = this.invalidationRequests.poll(5L, TimeUnit.SECONDS);
                    if (path == null) continue;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Invalidating the resource model registry lookup cache due to changes to {}.", path);
                    }
                    this.modelRegistry.clearLookupCaches();
                }
                catch (InterruptedException e) {
                    if (this.isShutDown) continue;
                    this.logger.debug("The type hierarchy change listener got interrupted, but was not shut down.", (Throwable)e);
                }
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this.isShutDown = true;
        this.executorService.shutdownNow();
    }

    public void handleEvent(Event event) {
        this.invalidationRequests.offer(event.getProperty("path"));
    }
}

