/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.api.spi.ResourceModelFactory;
import io.neba.core.resourcemodels.adaptation.ResourceToModelAdapterUpdater;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaDataRegistrar;
import io.neba.core.resourcemodels.registration.ModelRegistry;
import io.neba.core.util.BundleUtil;
import io.neba.core.util.OsgiModelSource;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ModelRegistrar {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ModelRegistry registry;
    @Reference
    private ResourceToModelAdapterUpdater resourceToModelAdapterUpdater;
    @Reference
    private ResourceModelMetaDataRegistrar resourceModelMetaDataRegistrar;
    private ServiceTracker tracker;

    @Activate
    protected void activate(final BundleContext context) {
        this.tracker = new ServiceTracker(context, ResourceModelFactory.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ResourceModelFactory, ResourceModelFactory>(){

            public ResourceModelFactory addingService(ServiceReference<ResourceModelFactory> reference) {
                ResourceModelFactory factory = (ResourceModelFactory)context.getService(reference);
                ModelRegistrar.this.registerModels(reference.getBundle(), factory);
                return (ResourceModelFactory)context.getService(reference);
            }

            public void modifiedService(ServiceReference<ResourceModelFactory> reference, ResourceModelFactory service) {
                ResourceModelFactory factory = (ResourceModelFactory)context.getService(reference);
                ModelRegistrar.this.unregister(reference.getBundle());
                ModelRegistrar.this.registerModels(reference.getBundle(), factory);
            }

            public void removedService(ServiceReference reference, ResourceModelFactory service) {
                ModelRegistrar.this.unregister(reference.getBundle());
            }
        });
        this.tracker.open(true);
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
    }

    private void registerModels(Bundle bundle, ResourceModelFactory factory) {
        Collection modelDefinitions = factory.getModelDefinitions();
        this.logger.info("Registering {} resource models from bundle: " + BundleUtil.displayNameOf(bundle) + " ...", (Object)modelDefinitions.size());
        modelDefinitions.forEach(d -> {
            OsgiModelSource source = new OsgiModelSource((ResourceModelFactory.ModelDefinition)d, factory, bundle);
            this.resourceModelMetaDataRegistrar.register(source);
            this.registry.add(d.getResourceModel().types(), source);
            this.logger.debug("Registered model {} as a model for the resource types {}.", (Object)d.getName(), (Object)StringUtils.join((Object[])d.getResourceModel().types(), (String)","));
        });
        this.resourceToModelAdapterUpdater.refresh();
    }

    private void unregister(Bundle bundle) {
        this.registry.removeResourceModels(bundle);
        this.resourceModelMetaDataRegistrar.removeMetadataForModelsIn(bundle);
        this.resourceToModelAdapterUpdater.refresh();
    }
}

