/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.core.resourcemodels.registration.LookupResult;
import io.neba.core.resourcemodels.registration.MappableTypeHierarchy;
import io.neba.core.util.BundleUtil;
import io.neba.core.util.ConcurrentDistinctMultiValueMap;
import io.neba.core.util.Key;
import io.neba.core.util.MatchedBundlesPredicate;
import io.neba.core.util.NodeUtil;
import io.neba.core.util.OsgiModelSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModelRegistry.class})
public class ModelRegistry {
    private static final Object NULL_VALUE = new Object();
    private final ConcurrentDistinctMultiValueMap<String, OsgiModelSource<?>> typeNameToModelSourcesMap = new ConcurrentDistinctMultiValueMap();
    private final ConcurrentDistinctMultiValueMap<Key, LookupResult> lookupCache = new ConcurrentDistinctMultiValueMap();
    private final Map<Key, Object> unmappedTypesCache = new ConcurrentHashMap<Key, Object>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger state = new AtomicInteger(0);

    private static Key key(Resource resource, Object ... furtherKeyElements) {
        Key key;
        Key furtherElementsKey = furtherKeyElements == null ? null : new Key(furtherKeyElements);
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                key = new Key(resource.getResourceType(), resource.getResourceSuperType(), NodeUtil.getPrimaryType(node), NodeUtil.geMixinTypes(node), furtherElementsKey);
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to retrieve the primary type of " + resource + ".", e);
            }
        } else {
            key = new Key(resource.getResourceType(), furtherElementsKey);
        }
        return key;
    }

    private static <T> Collection<T> nullIfEmpty(Collection<T> source) {
        return source == null || source.isEmpty() ? null : source;
    }

    private static Collection<OsgiModelSource<?>> filter(Collection<OsgiModelSource<?>> sources, Class<?> compatibleType) {
        Collection<OsgiModelSource<?>> compatibleSources = sources;
        if (sources != null && compatibleType != null) {
            compatibleSources = new ArrayList(sources.size());
            for (OsgiModelSource<?> source : sources) {
                if (!compatibleType.isAssignableFrom(source.getModelType())) continue;
                compatibleSources.add(source);
            }
        }
        return compatibleSources;
    }

    private static Collection<OsgiModelSource<?>> filter(Collection<OsgiModelSource<?>> sources, String modelName) {
        Collection<OsgiModelSource<?>> sourcesWithModelName = sources;
        if (sources != null && modelName != null) {
            sourcesWithModelName = new ArrayList(sources.size());
            for (OsgiModelSource<?> source : sources) {
                if (!modelName.equals(source.getModelName())) continue;
                sourcesWithModelName.add(source);
            }
        }
        return sourcesWithModelName;
    }

    Collection<LookupResult> lookupMostSpecificModels(Resource resource, String modelName) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        if (modelName == null) {
            throw new IllegalArgumentException("Method argument modelName must not be null.");
        }
        Key key = ModelRegistry.key(resource, modelName);
        if (this.isUnmapped(key)) {
            return null;
        }
        Collection<LookupResult> matchingModels = this.lookupFromCache(key);
        if (matchingModels == null) {
            int currentStateId = this.state.get();
            matchingModels = this.resolveMostSpecificModelSources(resource, modelName);
            if (matchingModels.isEmpty()) {
                this.markAsUnmapped(key, currentStateId);
            } else {
                this.cache(key, matchingModels, currentStateId);
            }
        }
        return ModelRegistry.nullIfEmpty(matchingModels);
    }

    Collection<LookupResult> lookupMostSpecificModels(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        Key key = ModelRegistry.key(resource, new Object[0]);
        if (this.isUnmapped(key)) {
            return null;
        }
        Collection<LookupResult> sources = this.lookupFromCache(key);
        if (sources == null) {
            int currentStateId = this.state.get();
            sources = this.resolveMostSpecificModelSources(resource);
            if (sources.isEmpty()) {
                this.markAsUnmapped(key, currentStateId);
            } else {
                this.cache(key, sources, currentStateId);
            }
        }
        return ModelRegistry.nullIfEmpty(sources);
    }

    Collection<LookupResult> lookupAllModels(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        Key key = ModelRegistry.key(resource, "allModels");
        if (this.isUnmapped(key)) {
            return null;
        }
        Collection<LookupResult> sources = this.lookupFromCache(key);
        if (sources == null) {
            int currentStateId = this.state.get();
            sources = this.resolveModelSources(resource, null, false);
            if (sources.isEmpty()) {
                this.markAsUnmapped(key, currentStateId);
            } else {
                this.cache(key, sources, currentStateId);
            }
        }
        return ModelRegistry.nullIfEmpty(sources);
    }

    public Collection<LookupResult> lookupMostSpecificModels(Resource resource, Class<?> targetType) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Method argument targetType must not be null.");
        }
        Key key = ModelRegistry.key(resource, targetType);
        if (this.isUnmapped(key)) {
            return null;
        }
        Collection<LookupResult> matchingModels = this.lookupFromCache(key);
        if (matchingModels == null) {
            int currentStateId = this.state.get();
            matchingModels = this.resolveMostSpecificModelSources(resource, targetType);
            if (matchingModels.isEmpty()) {
                this.markAsUnmapped(key, currentStateId);
            } else {
                this.cache(key, matchingModels, currentStateId);
            }
        }
        return ModelRegistry.nullIfEmpty(matchingModels);
    }

    @Deactivate
    protected void deActivate() {
        this.logger.info("The model registry is shutting down.");
        this.clearRegisteredModels();
        this.clearLookupCaches();
    }

    void removeResourceModels(Bundle bundle) {
        this.logger.info("Removing resource models of bundle " + BundleUtil.displayNameOf(bundle) + "...");
        MatchedBundlesPredicate sourcesWithBundles = new MatchedBundlesPredicate(bundle);
        for (Collection<OsgiModelSource<?>> values : this.typeNameToModelSourcesMap.values()) {
            CollectionUtils.filter(values, (Predicate)sourcesWithBundles);
        }
        this.clearLookupCaches();
        this.logger.info("Removed " + sourcesWithBundles.getFilteredElements() + " resource models of bundle " + BundleUtil.displayNameOf(bundle) + "...");
    }

    public List<OsgiModelSource<?>> getModelSources() {
        Collection<Collection<OsgiModelSource<?>>> sources = this.typeNameToModelSourcesMap.values();
        LinkedList linearizedSources = new LinkedList();
        sources.forEach(linearizedSources::addAll);
        return linearizedSources;
    }

    public void add(String[] types, OsgiModelSource<?> source) {
        for (String resourceType : types) {
            this.typeNameToModelSourcesMap.put(resourceType, source);
        }
        this.clearLookupCaches();
    }

    Map<String, Collection<OsgiModelSource<?>>> getTypeMappings() {
        return this.typeNameToModelSourcesMap.getContents();
    }

    synchronized void clearLookupCaches() {
        this.state.incrementAndGet();
        this.lookupCache.clear();
        this.unmappedTypesCache.clear();
        this.logger.debug("Cache cleared.");
    }

    private boolean isUnmapped(Key key) {
        return this.unmappedTypesCache.containsKey(key);
    }

    private Collection<LookupResult> lookupFromCache(Key key) {
        return this.lookupCache.get(key);
    }

    private void clearRegisteredModels() {
        this.typeNameToModelSourcesMap.clear();
        this.logger.debug("Registry cleared.");
    }

    private Collection<LookupResult> resolveMostSpecificModelSources(Resource resource) {
        return this.resolveMostSpecificModelSources(resource, (Class)null);
    }

    private Collection<LookupResult> resolveMostSpecificModelSources(Resource resource, Class<?> compatibleType) {
        return this.resolveModelSources(resource, compatibleType, true);
    }

    private Collection<LookupResult> resolveModelSources(Resource resource, Class<?> compatibleType, boolean resolveMostSpecific) {
        ArrayList sources = new ArrayList(64);
        for (String resourceType : MappableTypeHierarchy.mappableTypeHierarchyOf(resource)) {
            Collection<OsgiModelSource<?>> allSourcesForType = this.typeNameToModelSourcesMap.get(resourceType);
            Collection<OsgiModelSource<?>> sourcesForCompatibleType = ModelRegistry.filter(allSourcesForType, compatibleType);
            if (sourcesForCompatibleType == null || sourcesForCompatibleType.isEmpty()) continue;
            sources.addAll(sourcesForCompatibleType.stream().map(source -> new LookupResult((OsgiModelSource<?>)source, resourceType)).collect(Collectors.toList()));
            if (!resolveMostSpecific) continue;
            break;
        }
        return Collections.unmodifiableCollection(sources);
    }

    private Collection<LookupResult> resolveMostSpecificModelSources(Resource resource, String modelName) {
        ArrayList sources = new ArrayList();
        for (String resourceType : MappableTypeHierarchy.mappableTypeHierarchyOf(resource)) {
            Collection<OsgiModelSource<?>> allSourcesForType = this.typeNameToModelSourcesMap.get(resourceType);
            Collection<OsgiModelSource<?>> sourcesWithMatchingModelName = ModelRegistry.filter(allSourcesForType, modelName);
            if (sourcesWithMatchingModelName == null || sourcesWithMatchingModelName.isEmpty()) continue;
            sources.addAll(sourcesWithMatchingModelName.stream().map(source -> new LookupResult((OsgiModelSource<?>)source, resourceType)).collect(Collectors.toList()));
            break;
        }
        return Collections.unmodifiableCollection(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(Key key, Collection<LookupResult> sources, int stateId) {
        ModelRegistry modelRegistry = this;
        synchronized (modelRegistry) {
            if (stateId == this.state.get()) {
                this.lookupCache.put(key, sources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsUnmapped(Key key, int stateId) {
        ModelRegistry modelRegistry = this;
        synchronized (modelRegistry) {
            if (stateId == this.state.get()) {
                this.unmappedTypesCache.put(key, NULL_VALUE);
            }
        }
    }
}

