/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.core.resourcemodels.registration.LookupResult;
import io.neba.core.resourcemodels.registration.ModelRegistry;
import io.neba.core.util.BundleUtil;
import io.neba.core.util.ClassHierarchyIterator;
import io.neba.core.util.JsonUtil;
import io.neba.core.util.OsgiModelSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"felix.webconsole.label=modelregistry", "service.description=Provides a felix console plugin listing all registered @ResourceModel's.", "service.vendor=neba.io"})
public class ModelRegistryConsolePlugin
extends AbstractWebConsolePlugin {
    static final String LABEL = "modelregistry";
    private static String SUBSERVICE_NAME = "modelregistry-console";
    private static final String PREFIX_STATIC = "/static";
    private static final long serialVersionUID = -8676958166611686979L;
    private static final String API_PATH = "/api";
    private static final String API_FILTER = "/filter";
    private static final String API_RESOURCES = "/resources";
    private static final String API_COMPONENTICON = "/componenticon";
    private static final String API_MODELTYPES = "/modeltypes";
    private static final String PARAM_TYPENAME = "modelTypeName";
    private static final String PARAM_PATH = "path";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ModelRegistry registry;

    public String getCategory() {
        return "NEBA";
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return "Model registry";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String suffix = StringUtils.substringAfter((String)req.getRequestURI(), (String)(req.getServletPath() + "/" + this.getLabel()));
        if (!StringUtils.isBlank((CharSequence)suffix) && suffix.startsWith(API_PATH)) {
            this.handleApiCall(suffix.substring(API_PATH.length()), req, res);
            return;
        }
        super.doGet(req, res);
    }

    private void handleApiCall(String apiIdentifier, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (apiIdentifier.startsWith(API_COMPONENTICON)) {
            this.spoolComponentIcon(res, apiIdentifier);
            return;
        }
        res.setContentType("application/json;charset=UTF-8");
        if (apiIdentifier.startsWith(API_FILTER)) {
            this.provideFilteredModelRegistryView(req, res);
            return;
        }
        if (apiIdentifier.startsWith(API_RESOURCES)) {
            this.provideMatchingResourcePaths(req, res);
            return;
        }
        if (apiIdentifier.startsWith(API_MODELTYPES)) {
            this.provideAllModelTypes(res);
        }
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.writeHeadnavigation(res);
        PrintWriter writer = res.getWriter();
        this.writeScriptIncludes(res);
        writer.write("<table id=\"plugin_table\" class=\"nicetable tablesorter noauto\">");
        writer.write("<thead><tr><th>Type</th><th>Model type</th><th>Model name</th><th>Source bundle</th></tr></thead>");
        writer.write("<tbody>");
        for (Map.Entry<String, Collection<OsgiModelSource<?>>> entry : this.registry.getTypeMappings().entrySet()) {
            for (OsgiModelSource<?> source : entry.getValue()) {
                String sourceBundleName = BundleUtil.displayNameOf(source.getBundle());
                writer.write("<tr data-modeltype=\"" + source.getModelType().getName() + "\">");
                String resourceType = this.buildCrxDeLinkToResourceType(req, entry.getKey());
                writer.write("<td>" + resourceType + "</td>");
                writer.write("<td>" + source.getModelType().getName() + "</td>");
                writer.write("<td>" + source.getModelName() + "</td>");
                writer.write("<td><a href=\"bundles/" + source.getBundleId() + "\" title=\"" + sourceBundleName + "\">" + source.getBundleId() + "</a></td>");
                writer.write("</tr>");
            }
        }
        writer.write("</tbody>");
        writer.write("</table>");
    }

    private String buildCrxDeLinkToResourceType(HttpServletRequest request, String type) {
        return this.getResourceResolver().map(r -> {
            try {
                String path = ResourceUtil.resourceTypeToPath((String)type);
                Resource resource = null;
                Resource iconResource = null;
                for (String searchPath : r.getSearchPath()) {
                    resource = r.getResource(searchPath + path);
                    if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource) || ResourceUtil.isSyntheticResource((Resource)resource)) continue;
                    iconResource = resource.getChild("icon.png");
                    break;
                }
                String string = resource != null ? "<a href=\"" + request.getContextPath() + "/crx/de/#" + resource.getPath() + "\" class=\"crxdelink\"><img class=\"componentIcon\" src=\"" + this.getLabel() + API_PATH + API_COMPONENTICON + (iconResource == null ? "" : resource.getPath()) + "\"/>" + type + "</a>" : "<span class=\"unresolved\">" + type + "</span>";
                return string;
            }
            finally {
                r.close();
            }
        }).orElse("#");
    }

    private void provideAllModelTypes(HttpServletResponse res) throws IOException {
        HashSet<String> typeNames = new HashSet<String>();
        for (OsgiModelSource<?> source : this.registry.getModelSources()) {
            for (Class<?> type : ClassHierarchyIterator.hierarchyOf(source.getModelType())) {
                if (type == Object.class) continue;
                typeNames.add(type.getName());
            }
        }
        res.getWriter().write(JsonUtil.toJson(typeNames));
    }

    private void provideMatchingResourcePaths(HttpServletRequest req, HttpServletResponse res) {
        String path = req.getParameter(PARAM_PATH);
        if (StringUtils.isEmpty((CharSequence)path) || path.charAt(0) != '/') {
            return;
        }
        this.getResourceResolver().ifPresent(r -> {
            try {
                Resource parent;
                int idx = path.lastIndexOf(47);
                String prefix = "";
                if (idx < 1) {
                    parent = r.getResource("/");
                    prefix = path.substring(1);
                } else {
                    parent = r.getResource(path.substring(0, idx));
                    if (idx < path.length() - 1) {
                        prefix = path.substring(idx + 1);
                    }
                }
                if (parent == null) {
                    return;
                }
                LinkedList<String> resourcePaths = new LinkedList<String>();
                Iterator children = parent.listChildren();
                while (children.hasNext()) {
                    Resource child = (Resource)children.next();
                    if (!prefix.isEmpty() && !child.getName().startsWith(prefix)) continue;
                    resourcePaths.add(child.getPath());
                }
                res.getWriter().write(JsonUtil.toJson(resourcePaths));
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                r.close();
            }
        });
    }

    private Optional<ResourceResolver> getResourceResolver() {
        try {
            Map<String, String> authenticationInfo = Collections.singletonMap("sling.service.subservice", SUBSERVICE_NAME);
            return Optional.of(this.resourceResolverFactory.getServiceResourceResolver(authenticationInfo));
        }
        catch (LoginException e) {
            LoginException attemptViaUserMapping = e;
            this.logger.debug("Unable to login with sub service {}, falling back to the default admin account.", (Object)SUBSERVICE_NAME, (Object)e);
            try {
                HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
                authenticationInfo.put("user.name", "admin");
                authenticationInfo.put("user.password", "admin".toCharArray());
                return Optional.of(this.resourceResolverFactory.getResourceResolver(authenticationInfo));
            }
            catch (LoginException e2) {
                this.logger.error("Unable to obtain a resource resolver. No valid service user mapping for io.neba.neba-core:{} exists: {} and authenticating with the default admin credentials has failed.", new Object[]{SUBSERVICE_NAME, attemptViaUserMapping, e2});
                return Optional.empty();
            }
        }
    }

    private void provideFilteredModelRegistryView(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String modelTypePrefix = req.getParameter(PARAM_TYPENAME);
        String resourcePath = req.getParameter(PARAM_PATH);
        Collection<OsgiModelSource<?>> types = StringUtils.isEmpty((CharSequence)resourcePath) ? this.registry.getModelSources() : this.resolveModelTypesFor(resourcePath);
        HashSet<String> matchingModelTypeNames = new HashSet<String>(64);
        String typeNameCandidate = StringUtils.substringAfterLast((String)modelTypePrefix, (String)".");
        boolean exactMatch = !StringUtils.isEmpty((CharSequence)typeNameCandidate) && Character.isUpperCase(typeNameCandidate.charAt(0));
        block0: for (OsgiModelSource<?> source : types) {
            if (modelTypePrefix == null) {
                matchingModelTypeNames.add(source.getModelType().getName());
                continue;
            }
            for (Class<?> type : ClassHierarchyIterator.hierarchyOf(source.getModelType())) {
                String typeName = type.getName();
                if (!(exactMatch ? typeName.equals(modelTypePrefix) : typeName.startsWith(modelTypePrefix))) continue;
                matchingModelTypeNames.add(source.getModelType().getName());
                continue block0;
            }
        }
        res.getWriter().write(JsonUtil.toJson(matchingModelTypeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<OsgiModelSource<?>> resolveModelTypesFor(String resourcePath) {
        ArrayList types = new ArrayList(64);
        Optional<ResourceResolver> resolver = this.getResourceResolver();
        if (resolver.isPresent() && !StringUtils.isEmpty((CharSequence)resourcePath)) {
            try {
                Resource resource = resolver.get().getResource(resourcePath);
                if (resource == null) {
                    ArrayList arrayList = types;
                    return arrayList;
                }
                Collection<LookupResult> lookupResults = this.registry.lookupAllModels(resource);
                if (lookupResults == null) {
                    ArrayList arrayList = types;
                    return arrayList;
                }
                types.addAll(lookupResults.stream().map(LookupResult::getSource).collect(Collectors.toList()));
            }
            finally {
                resolver.get().close();
            }
        }
        return types;
    }

    public URL getResource(String path) {
        String internalPath = StringUtils.substringAfter((String)path, (String)("/" + this.getLabel()));
        if (StringUtils.startsWith((CharSequence)internalPath, (CharSequence)PREFIX_STATIC)) {
            return ((Object)((Object)this)).getClass().getResource("/META-INF/consoleplugin/modelregistry" + internalPath);
        }
        return null;
    }

    private void writeScriptIncludes(HttpServletResponse response) throws IOException {
        response.getWriter().write("<script src=\"" + this.getLabel() + "/static/script.js\"></script>");
    }

    private void writeHeadnavigation(HttpServletResponse response) throws IOException {
        String template = this.readTemplateFile("/META-INF/consoleplugin/modelregistry/templates/head.html");
        Optional<ResourceResolver> resourceResolver = this.getResourceResolver();
        String configurationHint = resourceResolver.map(r -> {
            r.close();
            return "";
        }).orElse("<br /> Warning: No amendment mapping for io.neba.neba-core:" + SUBSERVICE_NAME + " is <a href='" + this.getServletContext().getContextPath() + "/system/console/configMgr/'>configured</a> or the mapping is invalid, and using the default admin account has failed. This console plugin will not be able to access the repository.");
        response.getWriter().printf(template, this.getNumberOfModels(), configurationHint);
    }

    private Object getNumberOfModels() {
        return this.registry.getModelSources().size();
    }

    private void spoolComponentIcon(HttpServletResponse response, String suffix) throws IOException {
        response.setContentType("image/png");
        String iconPath = suffix.substring(API_COMPONENTICON.length());
        if (iconPath.isEmpty()) {
            this.streamDefaultIcon(response);
            return;
        }
        Optional<ResourceResolver> resolver = this.getResourceResolver();
        if (!resolver.isPresent()) {
            this.streamDefaultIcon(response);
            return;
        }
        resolver.ifPresent(r -> {
            InputStream in = null;
            try {
                Resource componentIcon = r.getResource(iconPath + "/icon.png");
                if (componentIcon != null && (in = (InputStream)componentIcon.adaptTo(InputStream.class)) != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                r.close();
                IOUtils.closeQuietly(in);
            }
        });
    }

    private void streamDefaultIcon(HttpServletResponse response) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/consoleplugin/modelregistry/static/noicon.png");
        try {
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

