/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.registration;

import io.neba.api.services.ResourceModelResolver;
import io.neba.core.resourcemodels.caching.ResourceModelCaches;
import io.neba.core.resourcemodels.mapping.ResourceToModelMapper;
import io.neba.core.resourcemodels.registration.LookupResult;
import io.neba.core.resourcemodels.registration.ModelRegistry;
import io.neba.core.util.Key;
import io.neba.core.util.OsgiModelSource;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceModelResolver.class})
public class ResourceModelResolverImpl
implements ResourceModelResolver {
    @Reference
    private ModelRegistry registry;
    @Reference
    private ResourceToModelMapper mapper;
    @Reference
    private ResourceModelCaches caches;

    public Object resolveMostSpecificModelWithName(Resource resource, String name) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Method argument modelName must not be null.");
        }
        return this.resolveMostSpecificModelForResource(resource, true, name);
    }

    public Object resolveMostSpecificModel(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        return this.resolveMostSpecificModelForResource(resource, false, null);
    }

    public Object resolveMostSpecificModelIncludingModelsForBaseTypes(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        return this.resolveMostSpecificModelForResource(resource, true, null);
    }

    private <T> T resolveMostSpecificModelForResource(@Nonnull Resource resource, boolean includeBaseTypes, @Nullable String modelName) {
        Collection<LookupResult> models;
        Key key = ResourceModelCaches.key(includeBaseTypes, modelName);
        Optional cachedModel = this.caches.lookup(resource, key);
        if (cachedModel == Optional.empty()) {
            return null;
        }
        if (cachedModel != null) {
            return cachedModel.get();
        }
        Collection<LookupResult> collection = models = modelName == null ? this.registry.lookupMostSpecificModels(resource) : this.registry.lookupMostSpecificModels(resource, modelName);
        if (models == null || models.size() != 1) {
            this.caches.store(resource, key, Optional.empty());
            return null;
        }
        LookupResult lookupResult = models.iterator().next();
        if (!includeBaseTypes && this.isMappedFromGenericBaseType(lookupResult)) {
            this.caches.store(resource, key, Optional.empty());
            return null;
        }
        OsgiModelSource<?> source = lookupResult.getSource();
        Object model = this.mapper.map(resource, source);
        this.caches.store(resource, key, Optional.of(model));
        return (T)model;
    }

    private boolean isMappedFromGenericBaseType(LookupResult lookupResult) {
        String resourceType = lookupResult.getResourceType();
        return "nt:unstructured".equals(resourceType) || "nt:base".equals(resourceType) || "neba:syntheticResourcetypeRoot".equals(resourceType);
    }
}

