/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import io.neba.core.util.ReadOnlyIterator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Annotations
implements Iterable<Annotation> {
    private final AnnotatedElement annotatedElement;
    private Map<Class<? extends Annotation>, Annotation> annotations = null;

    public static Annotations annotations(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException("Method argument annotatedElement must not be null.");
        }
        return new Annotations(annotatedElement);
    }

    Annotations(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException("Constructor parameter annotatedElement must not be null.");
        }
        this.annotatedElement = annotatedElement;
    }

    public boolean contains(Class<? extends Annotation> type) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null.");
        }
        return this.getAnnotationMap().get(type) != null;
    }

    public boolean containsName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Method argument name must not be null.");
        }
        for (Class<? extends Annotation> annotationType : this.getAnnotationMap().keySet()) {
            if (!annotationType.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T get(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null.");
        }
        return (T)this.getAnnotationMap().get(type);
    }

    public Stream<Annotation> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        if (this.annotations == null) {
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            LinkedList<Annotation> queue = new LinkedList<Annotation>(Arrays.asList(this.annotatedElement.getAnnotations()));
            while (!queue.isEmpty()) {
                Annotation annotation = (Annotation)queue.remove();
                if (annotations.containsKey(annotation.annotationType())) continue;
                annotations.put(annotation.annotationType(), annotation);
                Collections.addAll(queue, annotation.annotationType().getAnnotations());
            }
            this.annotations = annotations;
        }
        return this.annotations;
    }

    @Override
    public Iterator<Annotation> iterator() {
        return ReadOnlyIterator.readOnly(this.getAnnotationMap().values().iterator());
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return new HashMap<Class<? extends Annotation>, Annotation>(this.getAnnotationMap());
    }
}

