/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ClassHierarchyIterator
implements Iterable<Class<?>>,
Iterator<Class<?>> {
    private Queue<Class<?>> queue = new LinkedList();
    private Class<?> current;
    private Class<?> next = null;

    public static ClassHierarchyIterator hierarchyOf(Class<?> type) {
        return new ClassHierarchyIterator(type);
    }

    public ClassHierarchyIterator(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Constructor parameter type must not be null.");
        }
        this.current = type;
        this.next = this.current;
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.current != null && this.resolveNext();
    }

    private boolean resolveNext() {
        Class<?> superType;
        Class<?>[] interfaces = this.current.getInterfaces();
        if (interfaces != null) {
            this.queue.addAll(Arrays.asList(interfaces));
        }
        if ((superType = this.current.getSuperclass()) != null) {
            this.queue.add(superType);
        }
        if (!this.queue.isEmpty()) {
            this.next = this.queue.poll();
        }
        return this.next != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is unsupported - this is a read-only iterator.");
    }
}

