/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import io.neba.core.util.ConcurrentLinkedDistinctQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentDistinctMultiValueMap<K, V> {
    private final Map<K, Collection<V>> store = new ConcurrentHashMap<K, Collection<V>>(128);

    public Collection<V> get(K key) {
        return this.store.get(key);
    }

    public synchronized void put(K key, V value) {
        Collection<V> vs = this.getOrCreate(key);
        vs.add(value);
    }

    public void clear() {
        this.store.clear();
    }

    public Collection<V> remove(K key) {
        return this.store.remove(key);
    }

    public Collection<Collection<V>> values() {
        return this.store.values();
    }

    public synchronized void put(K key, Collection<V> values) {
        Collection<V> vs = this.getOrCreate(key);
        vs.addAll(values);
    }

    private Collection<V> getOrCreate(K key) {
        Collection<V> vs = this.store.get(key);
        if (vs == null) {
            vs = new ConcurrentLinkedDistinctQueue<V>();
            this.store.put(key, vs);
        }
        return vs;
    }

    public Map<K, Collection<V>> getContents() {
        HashMap<K, ArrayList<V>> contents = new HashMap<K, ArrayList<V>>(this.store.size());
        Set<Map.Entry<K, Collection<V>>> entries = this.store.entrySet();
        for (Map.Entry<K, Collection<V>> entry : entries) {
            contents.put(entry.getKey(), new ArrayList<V>(entry.getValue()));
        }
        return contents;
    }

    public int size() {
        return this.store.size();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public void removeValue(V value) {
        if (value == null) {
            throw new IllegalArgumentException("Method argument value must not be null.");
        }
        for (Collection<V> values : this.values()) {
            values.remove(value);
        }
    }
}

