/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public class JsonUtil {
    public static String toJson(Collection<?> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Method parameter collection must not be null");
        }
        return collection.stream().map(JsonUtil::toJson).reduce((l, r) -> l + "," + r).map(s -> '[' + s + ']').orElse("[]");
    }

    public static String toJson(Map<?, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Method parameter map must not be null");
        }
        Set<Map.Entry<?, ?>> entries = map.entrySet();
        return entries.stream().map(e -> JsonUtil.toJson(e.getKey()) + ':' + JsonUtil.toJson(e.getValue())).reduce((l, r) -> l + ',' + r).map(s -> '{' + s + '}').orElse("{}");
    }

    private static String toJson(Object value) {
        if (value == null) {
            return "\"\"";
        }
        if (!value.getClass().isArray() && (value.getClass().isPrimitive() || ClassUtils.wrapperToPrimitive(value.getClass()) != null)) {
            return Objects.toString(value);
        }
        if (value instanceof String) {
            return '\"' + ((String)value).replaceAll("\"", "\\\\\"") + '\"';
        }
        if (value instanceof Collection) {
            return JsonUtil.toJson((Collection)value);
        }
        if (value instanceof Map) {
            return JsonUtil.toJson((Map)value);
        }
        throw new IllegalArgumentException("Cannot convert value " + value + " to JSON.");
    }

    private JsonUtil() {
    }
}

