/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;

public class NodeTypeHierarchyIterator
implements Iterator<String>,
Iterable<String> {
    private final Queue<NodeType> queue = new LinkedList<NodeType>();
    private NodeType current;
    private NodeType next = null;

    public static NodeTypeHierarchyIterator typeHierarchyOf(Node node) {
        return new NodeTypeHierarchyIterator(node);
    }

    private NodeTypeHierarchyIterator(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Constructor argument node must not be null.");
        }
        try {
            this.next = this.current = node.getPrimaryNodeType();
            NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
            if (mixinNodeTypes != null && mixinNodeTypes.length != 0) {
                this.queue.addAll(Arrays.asList(mixinNodeTypes));
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to prepare the given node for node type hierarchy traversal.", e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.current != null && this.resolveNext();
    }

    private boolean resolveNext() {
        NodeType[] superTypes = this.current.getDeclaredSupertypes();
        if (superTypes != null && superTypes.length != 0) {
            this.queue.addAll(Arrays.asList(superTypes));
        }
        if (!this.queue.isEmpty()) {
            this.next = this.queue.poll();
        }
        return this.next != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        return this.current.getName();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is unsupported - this is a read-only iterator.");
    }
}

