/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;

public class NodeUtil {
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String JCR_MIXIN_TYPES = "jcr:mixinTypes";

    @Nonnull
    public static String getPrimaryType(@Nonnull Node node) throws RepositoryException {
        return node.hasProperty(JCR_PRIMARY_TYPE) ? node.getProperty(JCR_PRIMARY_TYPE).getString() : node.getPrimaryNodeType().getName();
    }

    @CheckForNull
    public static String geMixinTypes(@Nonnull Node node) throws RepositoryException {
        NodeType[] mixinTypes;
        Object[] objectArray = mixinTypes = node.hasProperty(JCR_MIXIN_TYPES) ? node.getProperty(JCR_MIXIN_TYPES).getValues() : node.getMixinNodeTypes();
        if (mixinTypes == null || mixinTypes.length == 0) {
            return null;
        }
        StringBuilder commaSeparatedMixinTypeNames = new StringBuilder(64);
        for (int i = 0; i < mixinTypes.length; ++i) {
            commaSeparatedMixinTypeNames.append(mixinTypes[i].toString());
            if (i >= mixinTypes.length - 1) continue;
            commaSeparatedMixinTypeNames.append(',');
        }
        return commaSeparatedMixinTypeNames.toString();
    }

    private NodeUtil() {
    }
}

