/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import org.apache.commons.lang3.builder.HashCodeBuilder;

public class OsgiModelReference<T> {
    private final T model;
    private final long bundleId;
    private final Class<?> modelClass;
    private final int hashCode;

    OsgiModelReference(T model, long bundleId) {
        if (model == null) {
            throw new IllegalArgumentException("Constructor argument model must not be null");
        }
        this.model = model;
        this.bundleId = bundleId;
        this.modelClass = model.getClass();
        this.hashCode = new HashCodeBuilder().append((Object)this.modelClass.getName()).append(bundleId).toHashCode();
    }

    public T getModel() {
        return this.model;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OsgiModelReference other = (OsgiModelReference)obj;
        return this.bundleId == other.bundleId && this.modelClass.getName().equals(other.modelClass.getName());
    }

    public String toString() {
        return "Model with type \"" + this.modelClass.getName() + '\"' + " from bundle with id " + this.bundleId;
    }
}

