/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import io.neba.api.spi.ResourceModelFactory;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.osgi.framework.Bundle;

public class OsgiModelSource<T> {
    private final ResourceModelFactory.ModelDefinition modelDefinition;
    private final ResourceModelFactory factory;
    private final long bundleId;
    private final int hashCode;
    private final Bundle bundle;

    public OsgiModelSource(ResourceModelFactory.ModelDefinition modelDefinition, ResourceModelFactory factory, Bundle bundle) {
        if (modelDefinition == null) {
            throw new IllegalArgumentException("Method argument modelDefinition must not be null.");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Method argument factory must not be null.");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Method argument bundle must not be null.");
        }
        this.modelDefinition = modelDefinition;
        this.factory = factory;
        this.bundleId = bundle.getBundleId();
        this.bundle = bundle;
        this.hashCode = new HashCodeBuilder().append((Object)this.modelDefinition.getName()).append(this.bundleId).toHashCode();
    }

    public T getModel() {
        return (T)this.factory.getModel(this.modelDefinition);
    }

    public Class<?> getModelType() {
        return this.modelDefinition.getType();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public ResourceModelFactory getFactory() {
        return this.factory;
    }

    public String getModelName() {
        return this.modelDefinition.getName();
    }

    public String toString() {
        return "Model \"" + this.getModelName() + '\"' + " from bundle with id " + this.bundleId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OsgiModelSource other = (OsgiModelSource)obj;
        return this.bundleId == other.bundleId && this.modelDefinition.getName().equals(other.modelDefinition.getName());
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

