/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.api.resource.ValueMap;

public class PrimitiveSupportingValueMap
implements ValueMap {
    private final ValueMap map;

    public PrimitiveSupportingValueMap(ValueMap valueMap) {
        if (valueMap == null) {
            throw new IllegalArgumentException("Method argument valueMap must not be null.");
        }
        this.map = valueMap;
    }

    public <T> T get(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("Method argument name must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null.");
        }
        Class boxedType = ClassUtils.primitiveToWrapper(type);
        return (T)this.map.get(name, boxedType);
    }

    public <T> T get(String name, T defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("Method argument name must not be null.");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Method argument defaultValue must not be null.");
        }
        Class<?> t = this.get(name, (T)defaultValue.getClass());
        return (T)(t == null ? defaultValue : t);
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Method argument key must not be null.");
        }
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }
}

