/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.Iterator;

public class ReadOnlyIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;

    static <T> ReadOnlyIterator<T> readOnly(Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Method argument iterator must not be null.");
        }
        return new ReadOnlyIterator<T>(iterator);
    }

    ReadOnlyIterator(Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Constructor parameter iterator must not be null.");
        }
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This is a read-only iterator");
    }
}

