/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ReflectionUtil {
    private static final int DEFAULT_COLLECTION_SIZE = 32;

    public static Type getLowerBoundOfSingleTypeParameter(Type type) {
        Type typeArgument;
        if (type == null) {
            throw new IllegalArgumentException("Method parameter type must not be null.");
        }
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Cannot obtain the component type of " + type + ", it does not declare generic type parameters.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            ReflectionUtil.signalUnsupportedNumberOfTypeDeclarations(type);
        }
        if ((typeArgument = typeArguments[0]) instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeArgument;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            if (lowerBounds.length == 0) {
                throw new IllegalArgumentException("Cannot obtain the generic type of " + type + ", it has a wildcard declaration with an upper bound (<? extends Y>) and is thus read-only. Only simple type parameters (e.g. <MyType>) or lower bound wildcards (e.g. <? super MyModel>) are supported.");
            }
            typeArgument = lowerBounds[0];
        }
        return typeArgument;
    }

    private static void signalUnsupportedNumberOfTypeDeclarations(Type type) {
        throw new IllegalArgumentException("Cannot obtain the component type of " + type + ", it must have exactly one parameter type, e.g. <MyModel>.");
    }

    public static <K, T extends Collection<K>> Collection<K> instantiateCollectionType(Class<T> collectionType, int length) {
        AbstractCollection collection;
        if (collectionType == null) {
            throw new IllegalArgumentException("Method parameter collectionType must not be null.");
        }
        if (collectionType.isAssignableFrom(List.class)) {
            collection = new ArrayList(length);
        } else if (collectionType.isAssignableFrom(Set.class)) {
            collection = new LinkedHashSet(length);
        } else {
            throw new IllegalArgumentException("Unable to instantiate a collection of type " + collectionType + ". Only collections assignable from " + List.class + " or " + Set.class + " are supported.");
        }
        return collection;
    }

    public static boolean isInstantiableCollectionType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null.");
        }
        for (Class<?> supportedType : ReflectionUtil.getInstantiableCollectionTypes()) {
            if (!type.isAssignableFrom(supportedType)) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] getInstantiableCollectionTypes() {
        return new Class[]{List.class, Set.class};
    }

    public static <K, T extends Collection<K>> Collection<K> instantiateCollectionType(Class<T> collectionType) {
        return ReflectionUtil.instantiateCollectionType(collectionType, 32);
    }

    public static List<Method> methodsOf(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null");
        }
        LinkedList<Method> methods = new LinkedList<Method>();
        LinkedList classes = new LinkedList();
        classes.add(type);
        while (!classes.isEmpty()) {
            Class c = (Class)classes.poll();
            methods.addAll(Arrays.asList(c.getDeclaredMethods()));
            if (c.getSuperclass() != null) {
                classes.add(c.getSuperclass());
            }
            Collections.addAll(classes, c.getInterfaces());
        }
        return methods;
    }

    public static Field findField(Class<?> type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("Method argument type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Method argument name must not be null");
        }
        Class<?> c = type;
        do {
            for (Field f : c.getDeclaredFields()) {
                if (!name.equals(f.getName())) continue;
                return f;
            }
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    public static Field makeAccessible(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Method argument field must not be null.");
        }
        if (ReflectionUtil.isInaccessible(field) && !field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Method makeAccessible(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method argument method must not be null.");
        }
        if (ReflectionUtil.isInaccessible(method) && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    private static boolean isInaccessible(Member member) {
        return !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    private ReflectionUtil() {
    }
}

