/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourcePaths {
    private static final String MATCH_NAME = "placeholder";
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{(?<placeholder>[^}|\\s]+)}");

    public static ResourcePath path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Method argument path must not be null");
        }
        if (PLACEHOLDER.matcher(path).find()) {
            return new PathWithPlaceholders(path);
        }
        return new PathWithoutPlaceholders(path);
    }

    private static class PathWithoutPlaceholders
    implements ResourcePath {
        private final String path;

        private PathWithoutPlaceholders(String path) {
            this.path = path;
        }

        @Override
        public ResourcePath resolve(Function<String, String> resolver) {
            return this;
        }

        public String toString() {
            return this.path;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    private static class PathWithPlaceholders
    implements ResourcePath {
        private final List<Value> segments;

        private PathWithPlaceholders(String path) {
            this(PathWithPlaceholders.segments(path));
        }

        private PathWithPlaceholders(List<Value> segments) {
            this.segments = segments;
        }

        @Override
        public ResourcePath resolve(Function<String, String> placeholderResolver) {
            if (placeholderResolver == null) {
                throw new IllegalArgumentException("Method argument placeholderResolver must not be null");
            }
            return new PathWithoutPlaceholders(this.segments.stream().map(s -> s.isPlaceholder() ? new Value((String)placeholderResolver.apply(((Value)s).value)) : s).map(Value::getValue).reduce("", String::concat));
        }

        @Override
        public String getPath() {
            return this.segments.stream().map(Value::getValue).reduce("", String::concat);
        }

        public String toString() {
            return this.getPath();
        }

        @Override
        public boolean hasPlaceholders() {
            return true;
        }

        private static List<Value> segments(String path) {
            Matcher matcher = PLACEHOLDER.matcher(path);
            if (!matcher.find()) {
                return Collections.singletonList(new Value(path));
            }
            ArrayList<Value> segments = new ArrayList<Value>(4);
            int last = 0;
            do {
                if (matcher.start() != 0) {
                    segments.add(new Value(path.substring(last, matcher.start())));
                }
                segments.add(new Placeholder(matcher.group(ResourcePaths.MATCH_NAME)));
                last = matcher.end();
            } while (matcher.find());
            if (last != path.length()) {
                segments.add(new Value(path.substring(last)));
            }
            return segments;
        }

        private static class Placeholder
        extends Value {
            private Placeholder(String value) {
                super(value);
            }

            @Override
            public String getValue() {
                return "${" + super.getValue() + '}';
            }

            @Override
            public boolean isPlaceholder() {
                return true;
            }
        }

        private static class Value {
            private final String value;

            private Value(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public boolean isPlaceholder() {
                return false;
            }
        }
    }

    public static interface ResourcePath {
        default public boolean hasPlaceholders() {
            return false;
        }

        public ResourcePath resolve(Function<String, String> var1);

        public String getPath();
    }
}

