/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import io.neba.core.util.NodeUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class ResourceTypeHierarchyIterator
implements Iterator<String>,
Iterable<String> {
    private final ResourceResolver resolver;
    private String currentResourceType;
    private String nextResourceType;
    private boolean isSyntheticResource;

    public static ResourceTypeHierarchyIterator typeHierarchyOf(Resource resource) {
        return new ResourceTypeHierarchyIterator(resource);
    }

    /*
     * Unable to fully structure code
     */
    ResourceTypeHierarchyIterator(Resource resource) {
        super();
        if (resource == null) {
            throw new IllegalArgumentException("Constructor parameter resource must not be null.");
        }
        this.resolver = resource.getResourceResolver();
        this.isSyntheticResource = ResourceUtil.isSyntheticResource((Resource)resource);
        if (this.isSyntheticResource) {
            this.currentResourceType = resource.getResourceType();
        } else {
            resourceType = resource.getResourceType();
            node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                try {
                    nodeType = NodeUtil.getPrimaryType(node);
                    if (nodeType.equals(resourceType)) ** GOTO lbl20
                    this.currentResourceType = resourceType;
                }
                catch (RepositoryException e) {
                    throw new RuntimeException("Unable to obtain the node type.", e);
                }
            } else {
                this.currentResourceType = resourceType;
            }
        }
lbl20:
        // 4 sources

        this.nextResourceType = this.currentResourceType;
    }

    @Override
    public boolean hasNext() {
        return this.nextResourceType != null || this.currentResourceType != null && this.resolveNext();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String type = this.nextResourceType;
        this.nextResourceType = null;
        this.currentResourceType = type;
        return type;
    }

    private boolean resolveNext() {
        String nextResourceType = this.resolver.getParentResourceType(this.currentResourceType);
        if (nextResourceType == null && this.isProvideSyntheticResourceRoot()) {
            nextResourceType = "neba:syntheticResourcetypeRoot";
        }
        this.nextResourceType = nextResourceType;
        return nextResourceType != null;
    }

    private boolean isProvideSyntheticResourceRoot() {
        return this.isSyntheticResource && !"neba:syntheticResourcetypeRoot".equals(this.currentResourceType);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The resource hierarchy iterator is read-only.");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

