/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.util;

import java.io.File;
import java.util.regex.Pattern;

public class ZipFileUtil {
    private static final Pattern WINDOWS_FILE_SEPARATOR = Pattern.compile("[\\\\]+");
    private static final Pattern DUPLICATE_SEPARATORS = Pattern.compile("[/]{2,}");

    public static String toZipFileEntryName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("method parameter file must not be null");
        }
        String filePath = file.getAbsolutePath();
        String entryName = filePath.replace(':', '/');
        entryName = WINDOWS_FILE_SEPARATOR.matcher(entryName).replaceAll("/");
        entryName = DUPLICATE_SEPARATORS.matcher(entryName).replaceAll("/");
        while (entryName.charAt(0) == '/') {
            entryName = entryName.substring(1);
        }
        return entryName;
    }

    private ZipFileUtil() {
    }
}

