/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeProfile;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class NeonBeeProfileTest {
    NeonBeeProfileTest() {
    }

    @Test
    @DisplayName(value="is profile active")
    void isActive() {
        Truth.assertThat((Boolean)NeonBeeProfile.CORE.isActive(List.of(NeonBeeProfile.ALL))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.STABLE.isActive(List.of(NeonBeeProfile.ALL))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.WEB.isActive(List.of(NeonBeeProfile.ALL))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.WEB.isActive(List.of(NeonBeeProfile.ALL, NeonBeeProfile.NO_WEB))).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.WEB.isActive(List.of(NeonBeeProfile.NO_WEB, NeonBeeProfile.ALL))).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.CORE.isActive(List.of(NeonBeeProfile.NO_WEB))).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.STABLE.isActive(List.of(NeonBeeProfile.NO_WEB, NeonBeeProfile.ALL))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.CORE.isActive(List.of(NeonBeeProfile.CORE))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.STABLE.isActive(List.of(NeonBeeProfile.STABLE, NeonBeeProfile.CORE))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.INCUBATOR.isActive(List.of(NeonBeeProfile.STABLE, NeonBeeProfile.ALL))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.CORE.isActive(List.of(NeonBeeProfile.STABLE, NeonBeeProfile.INCUBATOR))).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.ALL.isActive(List.of(NeonBeeProfile.STABLE))).isTrue();
        Truth.assertThat((Boolean)NeonBeeProfile.ALL.isActive(Set.of())).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.CORE.isActive(Set.of())).isFalse();
        Truth.assertThat((Boolean)NeonBeeProfile.NO_WEB.isActive(Set.of())).isFalse();
    }

    @Test
    void parseActiveProfile() {
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"ALL")).containsExactly(new Object[]{NeonBeeProfile.ALL});
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"CORE")).containsExactly(new Object[]{NeonBeeProfile.CORE});
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"CORE,STABLE")).containsExactly(new Object[]{NeonBeeProfile.CORE, NeonBeeProfile.STABLE});
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"CORE,anything")).containsExactly(new Object[]{NeonBeeProfile.CORE});
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"anything")).isEmpty();
        Truth.assertThat((Iterable)NeonBeeProfile.parseProfiles((String)"")).isEmpty();
    }
}

