/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.cluster;

import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NeonBeeExtension.class})
class LocalPreferredClusterTest {
    private static final String LOCAL = "local";
    private static final String REMOTE = "remote";
    private static final Long REPETITION = 10L;
    private NeonBee localNode;

    LocalPreferredClusterTest() {
    }

    @BeforeEach
    @Timeout(value=20, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Setup the cluster nodes and deploy the consumers")
    void setUp(@NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee localNode, @NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee remoteNode, VertxTestContext testContext) {
        this.localNode = localNode;
        DeploymentHelper.deployVerticle(localNode.getVertx(), (Verticle)new ConsumerVerticle(LOCAL)).compose(v -> DeploymentHelper.deployVerticle(remoteNode.getVertx(), (Verticle)new ConsumerVerticle(REMOTE))).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test that localPreferred requests are always dispatched to local consumer")
    void testLocalPreferredRequest(VertxTestContext testContext) {
        DataRequest request = new DataRequest("Consumer");
        this.fireRequests(request).onComplete(testContext.succeeding(responseMap -> {
            testContext.verify(() -> Truth.assertThat((Map)responseMap).containsExactly((Object)LOCAL, (Object)REPETITION, new Object[0]));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=20, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test that localPreferred requests are dispatched to remote consumers when no local consumer is available")
    void testLocalPreferredRequestWithoutLocalConsumer(VertxTestContext testContext) {
        DataRequest request = new DataRequest("Consumer");
        DeploymentHelper.undeployAllVerticlesOfClass(this.localNode.getVertx(), ConsumerVerticle.class).compose(v -> this.fireRequests(request)).onComplete(testContext.succeeding(responseMap -> {
            testContext.verify(() -> Truth.assertThat((Map)responseMap).containsExactly((Object)REMOTE, (Object)REPETITION, new Object[0]));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test that non localPreferred requests are dispatched to local and remote consumers")
    void testNonLocalPreferredRequest(VertxTestContext testContext) {
        Range expectedRange = Range.closed((Comparable)Long.valueOf(REPETITION / 2L - 1L), (Comparable)Long.valueOf(REPETITION / 2L + 1L));
        DataRequest request = new DataRequest("Consumer").setLocalPreferred(false);
        this.fireRequests(request).onComplete(testContext.succeeding(responseMap -> {
            testContext.verify(() -> {
                long local = (Long)responseMap.get(LOCAL);
                long remote = (Long)responseMap.get(REMOTE);
                Truth.assertThat((Long)Long.sum(local, remote)).isEqualTo((Object)REPETITION);
                Truth.assertThat((Long)local).isIn(expectedRange);
                Truth.assertThat((Long)remote).isIn(expectedRange);
            });
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test that data verticle are registered and deregistered properly as local consumer")
    void testLocalConsumerRegistration(VertxTestContext testContext) {
        String verticleAddress = "DataVerticle[Consumer]";
        Truth.assertThat((Boolean)this.localNode.isLocalConsumerAvailable(verticleAddress)).isTrue();
        DeploymentHelper.undeployAllVerticlesOfClass(this.localNode.getVertx(), ConsumerVerticle.class).onComplete(testContext.succeeding(v -> {
            testContext.verify(() -> Truth.assertThat((Boolean)this.localNode.isLocalConsumerAvailable(verticleAddress)).isFalse());
            testContext.completeNow();
        }));
    }

    private Future<Map<String, Long>> fireRequests(DataRequest request) {
        return CompositeFuture.all(IntStream.rangeClosed(1, REPETITION.intValue()).mapToObj(i -> DataVerticle.requestData((Vertx)this.localNode.getVertx(), (DataRequest)request, (DataContext)new DataContextImpl())).collect(Collectors.toList())).map(cpf -> this.mapResponses(cpf.list()));
    }

    private Map<String, Long> mapResponses(List<String> results) {
        return results.stream().collect(Collectors.groupingBy(nodeResp -> nodeResp, Collectors.counting()));
    }

    private static class ConsumerVerticle
    extends DataVerticle<String> {
        public static final String NAME = "Consumer";
        private final String node;

        ConsumerVerticle(String node) {
            this.node = node;
        }

        public String getName() {
            return NAME;
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            return Future.succeededFuture((Object)this.node);
        }
    }
}

