/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.cluster;

import io.neonbee.NeonBee;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.internal.tracking.MessageDirection;
import io.neonbee.internal.tracking.TrackingDataHandlingStrategy;
import io.neonbee.internal.tracking.TrackingInterceptor;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={NeonBeeExtension.class, MockitoExtension.class})
class TrackingInterceptorClusterTest {
    @Mock
    private TrackingDataHandlingStrategy strategy;

    TrackingInterceptorClusterTest() {
    }

    @BeforeEach
    void setUp() {
        ((TrackingDataHandlingStrategy)Mockito.lenient().doNothing().when((Object)this.strategy)).handleOutBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.lenient().doNothing().when((Object)this.strategy)).handleInBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.lenient().doNothing().when((Object)this.strategy)).handleOutBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.lenient().doNothing().when((Object)this.strategy)).handleInBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
    }

    @Test
    @Timeout(value=20, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Body of messages over distributed eventbus should be non-empty.")
    void testNeonBeeWithClusters(@NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee core, @NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee stable, VertxTestContext testContext) {
        stable.getVertx().eventBus().addInboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.INBOUND, this.strategy)).addOutboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.OUTBOUND, this.strategy));
        core.getVertx().eventBus().addInboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.INBOUND, this.strategy)).addOutboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.OUTBOUND, this.strategy));
        DataVerticle<String> coreVerticle = new DataVerticle<String>(){

            public String getName() {
                return "Core";
            }

            public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
                return Future.succeededFuture((Object)"Core result.");
            }
        };
        DataVerticle<String> stableVerticle = new DataVerticle<String>(){

            public String getName() {
                return "Stable";
            }

            public Future<Collection<DataRequest>> requireData(DataQuery query, DataContext context) {
                DataRequest request = new DataRequest("Core", query);
                return Future.succeededFuture(List.of(request));
            }
        };
        DataRequest request = new DataRequest("Core");
        DeploymentHelper.deployVerticle(core.getVertx(), (Verticle)coreVerticle).compose(arg_0 -> TrackingInterceptorClusterTest.lambda$testNeonBeeWithClusters$0(stable, (DataVerticle)stableVerticle, arg_0)).compose(s -> DataVerticle.requestData((Vertx)stable.getVertx(), (DataRequest)request, (DataContext)new DataContextImpl())).onComplete(testContext.succeeding(result -> {
            testContext.verify(() -> {
                ((TrackingDataHandlingStrategy)Mockito.verify((Object)this.strategy, (VerificationMode)Mockito.times((int)1))).handleOutBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
                ((TrackingDataHandlingStrategy)Mockito.verify((Object)this.strategy, (VerificationMode)Mockito.times((int)1))).handleInBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
                ((TrackingDataHandlingStrategy)Mockito.verify((Object)this.strategy, (VerificationMode)Mockito.times((int)1))).handleOutBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
                ((TrackingDataHandlingStrategy)Mockito.verify((Object)this.strategy, (VerificationMode)Mockito.times((int)1))).handleInBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
            });
            testContext.completeNow();
        }));
    }

    private static /* synthetic */ Future lambda$testNeonBeeWithClusters$0(NeonBee stable, DataVerticle stableVerticle, String s) {
        return DeploymentHelper.deployVerticle(stable.getVertx(), (Verticle)stableVerticle);
    }
}

