/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.AuthProviderConfig;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.VertxExtension;
import java.io.IOException;
import java.util.Base64;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class AuthHandlerConfigTest {
    AuthHandlerConfigTest() {
    }

    @Test
    @DisplayName(value="Throw error if auth provder type does not match auth handler type")
    void testUnsupportedAuthProviderTypes() {
        Vertx vertx = NeonBeeMockHelper.defaultVertxMock();
        BiConsumer<AuthHandlerConfig.AuthHandlerType, AuthProviderConfig.AuthProviderType> checkUnsupported = (handler, provider) -> {
            IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> handler.createAuthHandler(vertx, new AuthProviderConfig().setType(provider), new JsonObject()));
            Truth.assertThat((String)exception.getMessage()).startsWith("Cannot configure");
        };
        checkUnsupported.accept(AuthHandlerConfig.AuthHandlerType.HTDIGEST, AuthProviderConfig.AuthProviderType.JDBC);
        checkUnsupported.accept(AuthHandlerConfig.AuthHandlerType.JWT, AuthProviderConfig.AuthProviderType.JDBC);
        checkUnsupported.accept(AuthHandlerConfig.AuthHandlerType.OAUTH2, AuthProviderConfig.AuthProviderType.JDBC);
    }

    @Test
    @DisplayName(value="test toJson")
    void testToJson() {
        AuthProviderConfig apc = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JDBC);
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.HTDIGEST).setAdditionalConfig(additionalConfig).setAuthProviderConfig(apc);
        JsonObject providerJson = new JsonObject().put("type", (Object)"JDBC");
        JsonObject expectedJson = new JsonObject().put("type", (Object)"HTDIGEST").mergeIn(additionalConfig).put("provider", (Object)providerJson);
        Truth.assertThat((Iterable)ahc.toJson()).isEqualTo((Object)expectedJson);
    }

    @Test
    @DisplayName(value="test JsonConstructor")
    void testJsonConstructor() {
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        JsonObject providerJson = new JsonObject().put("type", (Object)"JDBC");
        JsonObject json = new JsonObject().put("type", (Object)"HTDIGEST").mergeIn(additionalConfig).put("provider", (Object)providerJson);
        AuthProviderConfig apc = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JDBC);
        AuthHandlerConfig expectedAHC = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.HTDIGEST).setAdditionalConfig(additionalConfig).setAuthProviderConfig(apc);
        Truth.assertThat((Object)new AuthHandlerConfig(json)).isEqualTo((Object)expectedAHC);
    }

    @Test
    @DisplayName(value="test getters and setters")
    void testGettersAndSetters() {
        AuthHandlerConfig ahc = new AuthHandlerConfig();
        Truth.assertThat((Object)ahc.setType(AuthHandlerConfig.AuthHandlerType.HTDIGEST)).isSameInstanceAs((Object)ahc);
        Truth.assertThat((Comparable)ahc.getType()).isEqualTo((Object)AuthHandlerConfig.AuthHandlerType.HTDIGEST);
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        Truth.assertThat((Object)ahc.setAdditionalConfig(additionalConfig)).isSameInstanceAs((Object)ahc);
        Truth.assertThat((Iterable)ahc.getAdditionalConfig()).isEqualTo((Object)additionalConfig);
        AuthProviderConfig apc = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JDBC);
        Truth.assertThat((Object)ahc.setAuthProviderConfig(apc)).isSameInstanceAs((Object)ahc);
        Truth.assertThat((Object)ahc.getAuthProviderConfig()).isEqualTo((Object)apc);
    }

    @Test
    @DisplayName(value="test that creation of JWT AuthHandler works")
    void testCreateAuthHandlerJWT(Vertx vertx) throws IOException {
        Buffer pem = Buffer.buffer((String)"-----BEGIN PUBLIC KEY-----\n");
        pem.appendBuffer(ResourceHelper.TEST_RESOURCES.getRelated("publicKey.txt")).appendString("\n-----END PUBLIC KEY-----");
        JsonObject pubKey = new JsonObject().put("buffer", (Object)Base64.getEncoder().encodeToString(pem.getBytes())).put("algorithm", (Object)"RS256");
        AuthProviderConfig apc = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JWT);
        apc.getAdditionalConfig().put("pubSecKeys", (Object)new JsonArray().add((Object)pubKey));
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.JWT).setAuthProviderConfig(apc);
        Truth.assertThat((Object)ahc.createAuthHandler(vertx)).isNotNull();
    }

    @Test
    @DisplayName(value="test hashcode and equals")
    void hashCodeAndEquals() {
        AuthHandlerConfig ahc = new AuthHandlerConfig();
        AuthHandlerConfig ahc2 = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.HTDIGEST);
        Truth.assertThat((Integer)ahc.hashCode()).isEqualTo((Object)new AuthHandlerConfig().hashCode());
        Truth.assertThat((Integer)ahc.hashCode()).isNotEqualTo((Object)ahc2.hashCode());
        Truth.assertThat((Integer)ahc.hashCode()).isNotEqualTo((Object)"".hashCode());
        Truth.assertThat((Boolean)ahc.equals((Object)ahc)).isTrue();
        Truth.assertThat((Boolean)ahc.equals(null)).isFalse();
        Truth.assertThat((Object)ahc).isEqualTo((Object)new AuthHandlerConfig());
        Truth.assertThat((Boolean)ahc.equals(new Object())).isFalse();
        Truth.assertThat((Object)ahc).isNotEqualTo((Object)ahc2);
    }
}

