/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.config.AuthProviderConfig;
import io.vertx.core.json.JsonObject;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class AuthProviderConfigTest {
    AuthProviderConfigTest() {
    }

    @Test
    @DisplayName(value="Throw error if AuthProvderType is undupported")
    void testUnsupportedAuthProviderTypes() {
        BiConsumer<AuthProviderConfig.AuthProviderType, String> checkUnsupported = (type, msg) -> {
            UnsupportedOperationException exception = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> new AuthProviderConfig().setType(type).createAuthProvider(NeonBeeMockHelper.defaultVertxMock()));
            Truth.assertThat((String)exception.getMessage()).isEqualTo(msg);
        };
        checkUnsupported.accept(AuthProviderConfig.AuthProviderType.JDBC, "JDBC authentication provider is not implemented yet");
        checkUnsupported.accept(AuthProviderConfig.AuthProviderType.MONGO, "MongoDB authentication provider is not implemented yet");
    }

    @Test
    @DisplayName(value="test toJson")
    void testToJson() {
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        AuthProviderConfig apc = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JDBC).setAdditionalConfig(additionalConfig);
        JsonObject expectedJson = new JsonObject().put("type", (Object)"JDBC").mergeIn(additionalConfig);
        Truth.assertThat((Iterable)apc.toJson()).isEqualTo((Object)expectedJson);
    }

    @Test
    @DisplayName(value="test JsonConstructor")
    void testJsonConstructor() {
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        JsonObject json = new JsonObject().put("type", (Object)"JDBC").mergeIn(additionalConfig);
        AuthProviderConfig expectedAPC = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.JDBC).setAdditionalConfig(additionalConfig);
        Truth.assertThat((Object)new AuthProviderConfig(json)).isEqualTo((Object)expectedAPC);
    }

    @Test
    @DisplayName(value="test getters and setters")
    void testGettersAndSetters() {
        AuthProviderConfig apc = new AuthProviderConfig();
        Truth.assertThat((Object)apc.setType(AuthProviderConfig.AuthProviderType.HTDIGEST)).isSameInstanceAs((Object)apc);
        Truth.assertThat((Comparable)apc.getType()).isEqualTo((Object)AuthProviderConfig.AuthProviderType.HTDIGEST);
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        Truth.assertThat((Object)apc.setAdditionalConfig(additionalConfig)).isSameInstanceAs((Object)apc);
        Truth.assertThat((Iterable)apc.getAdditionalConfig()).isEqualTo((Object)additionalConfig);
    }

    @Test
    @DisplayName(value="test hashcode and equals")
    void hashCodeAndEquals() {
        AuthProviderConfig apc = new AuthProviderConfig();
        AuthProviderConfig apc2 = new AuthProviderConfig().setType(AuthProviderConfig.AuthProviderType.HTDIGEST);
        Truth.assertThat((Integer)apc.hashCode()).isEqualTo((Object)new AuthProviderConfig().hashCode());
        Truth.assertThat((Integer)apc.hashCode()).isNotEqualTo((Object)apc2.hashCode());
        Truth.assertThat((Integer)apc.hashCode()).isNotEqualTo((Object)"".hashCode());
        Truth.assertThat((Boolean)apc.equals((Object)apc)).isTrue();
        Truth.assertThat((Boolean)apc.equals(null)).isFalse();
        Truth.assertThat((Object)apc).isEqualTo((Object)new AuthProviderConfig());
        Truth.assertThat((Boolean)apc.equals(new Object())).isFalse();
        Truth.assertThat((Object)apc).isNotEqualTo((Object)apc2);
    }
}

