/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.truth.Truth;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class EndpointConfigTest {
    EndpointConfigTest() {
    }

    @Test
    @DisplayName(value="test toJson")
    void testToJson() {
        String basePath = "hodorPath";
        String type = "hodorType";
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.BASIC);
        EndpointConfig epc = new EndpointConfig().setBasePath(basePath).setType(type);
        epc.setAdditionalConfig(additionalConfig).setAuthChainConfig(List.of(ahc));
        JsonArray authenticationChain = new JsonArray().add((Object)ahc.toJson());
        JsonObject expectedJson = new JsonObject().put("type", (Object)type).put("basePath", (Object)basePath).put("enabled", (Object)true);
        expectedJson.mergeIn(additionalConfig).put("authenticationChain", (Object)authenticationChain);
        Truth.assertThat((Iterable)epc.toJson()).isEqualTo((Object)expectedJson);
    }

    @Test
    @DisplayName(value="test JSON constructor")
    void testJSONConstructor() {
        String basePath = "hodorPath";
        String type = "hodorType";
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.BASIC);
        JsonArray authenticationChain = new JsonArray().add((Object)ahc.toJson());
        JsonObject json = new JsonObject().put("type", (Object)type).put("basePath", (Object)basePath).put("enabled", (Object)true);
        json.mergeIn(additionalConfig).put("authenticationChain", (Object)authenticationChain);
        EndpointConfig epc = new EndpointConfig().setBasePath(basePath).setType(type);
        epc.setAdditionalConfig(additionalConfig).setAuthChainConfig(List.of(ahc));
        Truth.assertThat((Object)new EndpointConfig(json)).isEqualTo((Object)epc);
    }

    @Test
    @DisplayName(value="test getters and setters")
    void testGettersAndSetters() {
        EndpointConfig ec = new EndpointConfig();
        Truth.assertThat((Object)ec.setType("setType")).isSameInstanceAs((Object)ec);
        Truth.assertThat((String)ec.getType()).isEqualTo((Object)"setType");
        Truth.assertThat((Object)ec.setBasePath("setBasePath")).isSameInstanceAs((Object)ec);
        Truth.assertThat((String)ec.getBasePath()).isEqualTo((Object)"setBasePath");
        Truth.assertThat((Object)ec.setEnabled(Boolean.valueOf(false))).isSameInstanceAs((Object)ec);
        Truth.assertThat((Boolean)ec.isEnabled()).isEqualTo((Object)false);
        List<AuthHandlerConfig> authHandlerConfig = List.of(new AuthHandlerConfig());
        Truth.assertThat((Object)ec.setAuthChainConfig(authHandlerConfig)).isSameInstanceAs((Object)ec);
        Truth.assertThat((Iterable)ec.getAuthChainConfig()).containsExactlyElementsIn(authHandlerConfig);
        JsonObject additionalConfig = new JsonObject().put("Hodor", (Object)"Hodor");
        Truth.assertThat((Object)ec.setAdditionalConfig(additionalConfig)).isSameInstanceAs((Object)ec);
        Truth.assertThat((Iterable)ec.getAdditionalConfig()).isEqualTo((Object)additionalConfig);
    }

    @Test
    @DisplayName(value="test hashcode and equals")
    void hashCodeAndEquals() {
        EndpointConfig ec = new EndpointConfig();
        EndpointConfig ec2 = new EndpointConfig().setBasePath("Hodor");
        Truth.assertThat((Integer)ec.hashCode()).isEqualTo((Object)new EndpointConfig().hashCode());
        Truth.assertThat((Integer)ec.hashCode()).isNotEqualTo((Object)ec2.hashCode());
        Truth.assertThat((Integer)ec.hashCode()).isNotEqualTo((Object)"".hashCode());
        Truth.assertThat((Boolean)ec.equals((Object)ec)).isTrue();
        Truth.assertThat((Boolean)ec.equals(null)).isFalse();
        Truth.assertThat((Object)ec).isEqualTo((Object)new EndpointConfig());
        Truth.assertThat((Boolean)ec.equals(new Object())).isFalse();
        Truth.assertThat((Object)ec).isNotEqualTo((Object)ec2);
    }
}

