/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.truth.Truth;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.neonbee.config.MicrometerRegistryConfig;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.config.metrics.MicrometerRegistryLoader;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class NeonBeeConfigTest
extends NeonBeeTestBase {
    private static final int DUMMY_EVENT_BUS_TIMEOUT = 1337;
    private static final String DUMMY_TRACKING_DATA_HANDLING_STRATEGY = "Hodor";
    private static final String DUMMY_TIME_ZONE = "Hammer Time";
    private static final Map<String, String> DUMMY_EVENT_BUS_CODECS = Map.of("Random", "Codec");
    private static final List<String> DUMMY_PLATFORM_CLASSES = List.of("Hodor");
    private static final List<MicrometerRegistryConfig> DUMMY_MICROMETER_REGISTRIES = List.of();
    private static final NeonBeeConfig DUMMY_NEONBEE_CONFIG = new NeonBeeConfig().setEventBusTimeout(1337).setTrackingDataHandlingStrategy("Hodor").setTimeZone("Hammer Time").setEventBusCodecs(DUMMY_EVENT_BUS_CODECS).setPlatformClasses(DUMMY_PLATFORM_CLASSES).setMicrometerRegistries(DUMMY_MICROMETER_REGISTRIES);

    NeonBeeConfigTest() {
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        if ("testLoad".equals(testInfo.getTestMethod().map(Method::getName).orElse(null))) {
            return WorkingDirectoryBuilder.standard().setNeonBeeConfig(DUMMY_NEONBEE_CONFIG);
        }
        return super.provideWorkingDirectoryBuilder(testInfo, testContext);
    }

    @Test
    @DisplayName(value="Test loading the MeterRegistry with the deprecated method")
    @Deprecated(forRemoval=true)
    void testDeprecatedLoadingMeterRegistry() throws Exception {
        NeonBeeConfig config = new NeonBeeConfig();
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        config.setMicrometerRegistries(List.of(new MicrometerRegistryConfig().setClassName(TestMicrometerRegistryLoaderImpl.class.getName()).setConfig(new JsonObject())));
        config.createMicrometerRegistries().forEach(arg_0 -> ((CompositeMeterRegistry)registry).add(arg_0));
        Set registries = registry.getRegistries();
        Truth.assertThat((Iterable)registries).hasSize(1);
        Truth.assertThat((Boolean)registries.stream().anyMatch(PrometheusMeterRegistry.class::isInstance)).isTrue();
    }

    @Test
    @DisplayName(value="Test loading the MeterRegistry")
    void testLoadingMeterRegistry(Vertx vertx, VertxTestContext context) throws Exception {
        NeonBeeConfig config = new NeonBeeConfig();
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        config.setMicrometerRegistries(List.of(new MicrometerRegistryConfig().setClassName(TestMicrometerRegistryLoaderImpl.class.getName()).setConfig(new JsonObject())));
        CompositeFuture.all(config.createMicrometerRegistries(vertx).collect(Collectors.toList())).onSuccess(h -> h.list().forEach(arg_0 -> ((CompositeMeterRegistry)registry).add(arg_0))).onComplete(context.succeeding(event -> {
            Set registries = registry.getRegistries();
            Truth.assertThat((Iterable)registries).hasSize(1);
            Truth.assertThat((Boolean)registries.stream().anyMatch(PrometheusMeterRegistry.class::isInstance)).isTrue();
            context.completeNow();
        }));
    }

    static Stream<Arguments> testNotImplementingMicrometerRegistryLoaderArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"java.lang.String", "java.lang.String must implement io.neonbee.config.metrics.MicrometerRegistryLoader", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"doesn't exist", "doesn't exist", ClassNotFoundException.class}), Arguments.of((Object[])new Object[]{"io.neonbee.config.NeonBeeConfigTest$TestFaultyMicrometerRegistryLoaderImpl", "io.neonbee.config.NeonBeeConfigTest$TestFaultyMicrometerRegistryLoaderImpl.<init>()", NoSuchMethodException.class}));
    }

    @ParameterizedTest(name="{index}: {0} expected exception message: {1}")
    @MethodSource(value={"testNotImplementingMicrometerRegistryLoaderArguments"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test MicrometerRegistryLoader with incorrect configuration")
    void testNotImplementingMicrometerRegistryLoader(String className, String exceptionMessage, Class<? extends Throwable> expectedException, Vertx vertx, VertxTestContext context) {
        NeonBeeConfig config = new NeonBeeConfig();
        config.setMicrometerRegistries(List.of(new MicrometerRegistryConfig().setClassName(className)));
        CompositeFuture.all(config.createMicrometerRegistries(vertx).collect(Collectors.toList())).onComplete(context.failing(throwable -> {
            Truth.assertThat((Throwable)throwable).isInstanceOf(expectedException);
            Truth.assertThat((Throwable)throwable).hasMessageThat().isEqualTo((Object)exceptionMessage);
            context.completeNow();
        }));
    }

    @ParameterizedTest(name="{index}: {0} expected exception message: {1}")
    @MethodSource(value={"testNotImplementingMicrometerRegistryLoaderArguments"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test deprecated MicrometerRegistryLoader with incorrect configuration")
    @Deprecated(forRemoval=true)
    void testDeprecatedNotImplementingMicrometerRegistryLoader(String className, String exceptionMessage, Class<? extends Throwable> expectedException) {
        NeonBeeConfig config = new NeonBeeConfig();
        config.setMicrometerRegistries(List.of(new MicrometerRegistryConfig().setClassName(className)));
        Throwable throwable = Assert.assertThrows(expectedException, () -> ((NeonBeeConfig)config).createMicrometerRegistries());
        Truth.assertThat((Throwable)throwable).hasMessageThat().isEqualTo((Object)exceptionMessage);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should load NeonBeeConfig correctly from working dir")
    void testLoad(Vertx vertx, VertxTestContext testContext) {
        NeonBeeConfig.load((Vertx)vertx, (Path)this.getNeonBee().getOptions().getConfigDirectory()).onComplete(testContext.succeeding(nbc -> {
            testContext.verify(() -> this.isEqualToDummyConfig((NeonBeeConfig)nbc));
            testContext.completeNow();
        }));
    }

    @Test
    @DisplayName(value="should read the trackingDataHandlingStrategy correctly")
    void readtrackingDataHandlingStrategy() {
        NeonBeeConfig config = new NeonBeeConfig(new JsonObject().put("trackingDataHandlingStrategy", (Object)"ABC"));
        Truth.assertThat((String)config.getTrackingDataHandlingStrategy()).isEqualTo((Object)"ABC");
    }

    @Test
    @DisplayName(value="should read the metrics configuration correctly")
    void readMetricsConfig() {
        NeonBeeConfig config = new NeonBeeConfig(new JsonObject().put("metrics", (Object)new JsonObject().put("enabled", (Object)true)));
        Truth.assertThat((Boolean)config.getMetricsConfig().isEnabled()).isTrue();
    }

    @Test
    @DisplayName(value="should create the metrics configuration JSON correctly")
    void metricsConfigToJson() {
        NeonBeeConfig config = new NeonBeeConfig();
        config.getMetricsConfig().setEnabled(true);
        JsonObject actual = config.toJson();
        Truth.assertThat((Iterable)actual.getJsonObject("metrics")).isEqualTo((Object)new JsonObject().put("enabled", (Object)true));
    }

    @Test
    @DisplayName(value="should read the platform classes correctly")
    void testGetPlatformClasses() {
        List<String> validListOfPlatformClasses = List.of("hodor");
        List<Integer> nonValidListOfPlatformClasses = List.of("hodor", Integer.valueOf(3));
        Function<List, JsonObject> createConfig = list -> new JsonObject().put("platformClasses", (Object)new JsonArray(list));
        NeonBeeConfig config = new NeonBeeConfig(createConfig.apply(validListOfPlatformClasses));
        Truth.assertThat((Iterable)config.getPlatformClasses()).containsExactlyElementsIn(validListOfPlatformClasses);
        config = new NeonBeeConfig(createConfig.apply(nonValidListOfPlatformClasses));
        Truth.assertThat((Iterable)config.getPlatformClasses()).containsExactlyElementsIn(validListOfPlatformClasses);
    }

    @Test
    @DisplayName(value="should read the health config correctly")
    void testReadMetricsConfig() {
        JsonObject settings = new JsonObject();
        Function<Boolean, JsonObject> buildConfig = enabled -> settings.put("health", (Object)new JsonObject().put("enabled", enabled));
        NeonBeeConfig neonBeeConfig = new NeonBeeConfig(buildConfig.apply(true));
        Truth.assertThat((Boolean)neonBeeConfig.getHealthConfig().isEnabled()).isTrue();
        neonBeeConfig = new NeonBeeConfig(buildConfig.apply(false));
        Truth.assertThat((Boolean)neonBeeConfig.getHealthConfig().isEnabled()).isFalse();
    }

    @Test
    @DisplayName(value="should create the metrics config correctly")
    void testHealthConfigToJson() {
        NeonBeeConfig config = new NeonBeeConfig();
        config.getHealthConfig().setEnabled(false);
        JsonObject actual = config.toJson();
        Truth.assertThat((Iterable)actual.getJsonObject("health")).isEqualTo((Object)new JsonObject().put("enabled", (Object)false).put("timeout", (Object)1));
    }

    @Test
    @DisplayName(value="should have the correct default values")
    void testDefaultValues() {
        NeonBeeConfig defaultConfig = new NeonBeeConfig();
        Truth.assertThat((Integer)defaultConfig.getEventBusTimeout()).isEqualTo((Object)30);
        Truth.assertThat((String)defaultConfig.getTrackingDataHandlingStrategy()).isEqualTo((Object)NeonBeeConfig.DEFAULT_TRACKING_DATA_HANDLING_STRATEGY);
        Truth.assertThat((String)defaultConfig.getTimeZone()).isEqualTo((Object)"UTC");
        Truth.assertThat((Map)defaultConfig.getEventBusCodecs()).isEmpty();
        Truth.assertThat((Iterable)defaultConfig.getPlatformClasses()).containsExactly(new Object[]{"io.vertx.*", "io.neonbee.*", "org.slf4j.*", "org.apache.olingo.*"});
        Truth.assertThat((Boolean)defaultConfig.getHealthConfig().isEnabled()).isTrue();
        Truth.assertThat((Integer)defaultConfig.getHealthConfig().getTimeout()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="setters should work as expected")
    void testSetters() {
        this.isEqualToDummyConfig(DUMMY_NEONBEE_CONFIG);
    }

    private void isEqualToDummyConfig(NeonBeeConfig nbc) {
        Truth.assertThat((Integer)nbc.getEventBusTimeout()).isEqualTo((Object)1337);
        Truth.assertThat((String)nbc.getTrackingDataHandlingStrategy()).isEqualTo((Object)DUMMY_TRACKING_DATA_HANDLING_STRATEGY);
        Truth.assertThat((String)nbc.getTimeZone()).isEqualTo((Object)DUMMY_TIME_ZONE);
        Truth.assertThat((Map)nbc.getEventBusCodecs()).isEqualTo(DUMMY_EVENT_BUS_CODECS);
        Truth.assertThat((Iterable)nbc.getPlatformClasses()).isEqualTo(DUMMY_PLATFORM_CLASSES);
        Truth.assertThat((Iterable)nbc.getMicrometerRegistries()).isEqualTo(DUMMY_MICROMETER_REGISTRIES);
    }

    public static class TestMicrometerRegistryLoaderImpl
    implements MicrometerRegistryLoader {
        public MeterRegistry load(JsonObject config) {
            return new PrometheusMeterRegistry(arg_0 -> ((JsonObject)config).getString(arg_0));
        }
    }

    public static class TestFaultyMicrometerRegistryLoaderImpl
    implements MicrometerRegistryLoader {
        TestFaultyMicrometerRegistryLoaderImpl(String required) {
        }

        public MeterRegistry load(JsonObject config) {
            return new PrometheusMeterRegistry(arg_0 -> ((JsonObject)config).getString(arg_0));
        }
    }
}

