/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.truth.Truth;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.endpoint.raw.RawEndpoint;
import io.neonbee.internal.handler.factories.CacheControlHandlerFactory;
import io.neonbee.internal.handler.factories.CorrelationIdHandlerFactory;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ServerConfigTest {
    private static final String ERROR_HANDLER = "io.neonbee.CustomErrorHandler";
    private static final String ERROR_TEMPLATE = "custom-template.html";
    private static final List<String> FACTORY_CLASS_NAME_LIST = List.of(CacheControlHandlerFactory.class.getName(), CorrelationIdHandlerFactory.class.getName());

    ServerConfigTest() {
    }

    @Test
    @DisplayName(value="test toJson")
    void testToJson() {
        int timeout = 1;
        ServerConfig.SessionHandling sessionHandling = ServerConfig.SessionHandling.LOCAL;
        String sessionCookieName = "setSessionCookieName";
        ServerConfig.CorrelationStrategy correlationStrategy = ServerConfig.CorrelationStrategy.GENERATE_UUID;
        int timeoutStatusCode = 2;
        EndpointConfig epc = new EndpointConfig().setType("hodor");
        List<EndpointConfig> endpointConfigs = List.of(epc);
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.BASIC);
        List<AuthHandlerConfig> authHandlerConfig = List.of(ahc);
        ServerConfig sc = new ServerConfig();
        sc.setTimeout(timeout).setSessionHandling(sessionHandling).setSessionCookieName(sessionCookieName);
        sc.setCorrelationStrategy(correlationStrategy).setTimeoutStatusCode(timeoutStatusCode);
        sc.setEndpointConfigs(endpointConfigs).setAuthChainConfig(authHandlerConfig);
        sc.setErrorHandlerClassName(ERROR_HANDLER).setErrorHandlerTemplate(ERROR_TEMPLATE);
        sc.setHandlerFactoriesClassNames(FACTORY_CLASS_NAME_LIST);
        JsonObject expected = new JsonObject().put("timeout", (Object)timeout).put("sessionHandling", (Object)sessionHandling.name());
        expected.put("sessionCookieName", (Object)sessionCookieName).put("correlationStrategy", (Object)correlationStrategy.name());
        expected.put("timeoutStatusCode", (Object)timeoutStatusCode).put("endpoints", (Object)new JsonArray().add((Object)epc.toJson()));
        expected.put("authenticationChain", (Object)new JsonArray().add((Object)ahc.toJson()));
        expected.put("errorHandler", (Object)ERROR_HANDLER).put("errorTemplate", (Object)ERROR_TEMPLATE);
        JsonArray expectedHandlerFactories = new JsonArray();
        FACTORY_CLASS_NAME_LIST.forEach(arg_0 -> ((JsonArray)expectedHandlerFactories).add(arg_0));
        expected.put("handlerFactories", (Object)expectedHandlerFactories);
        Truth.assertThat((Iterable)sc.toJson()).containsAtLeastElementsIn((Iterable)expected);
    }

    @Test
    @DisplayName(value="test JsonConstructor")
    void testJsonConstructor() {
        int timeout = 1;
        ServerConfig.SessionHandling sessionHandling = ServerConfig.SessionHandling.LOCAL;
        String sessionCookieName = "setSessionCookieName";
        ServerConfig.CorrelationStrategy correlationStrategy = ServerConfig.CorrelationStrategy.GENERATE_UUID;
        int timeoutStatusCode = 2;
        EndpointConfig epc = new EndpointConfig().setType("hodor");
        AuthHandlerConfig ahc = new AuthHandlerConfig().setType(AuthHandlerConfig.AuthHandlerType.BASIC);
        JsonObject json = new JsonObject().put("timeout", (Object)timeout).put("sessionHandling", (Object)sessionHandling.name());
        json.put("sessionCookieName", (Object)sessionCookieName).put("correlationStrategy", (Object)correlationStrategy.name());
        json.put("timeoutStatusCode", (Object)timeoutStatusCode).put("endpoints", (Object)new JsonArray().add((Object)epc.toJson()));
        json.put("authenticationChain", (Object)new JsonArray().add((Object)ahc.toJson()));
        json.put("errorHandler", (Object)ERROR_HANDLER);
        json.put("errorTemplate", (Object)ERROR_TEMPLATE);
        JsonArray handlerFactories = new JsonArray();
        FACTORY_CLASS_NAME_LIST.forEach(arg_0 -> ((JsonArray)handlerFactories).add(arg_0));
        json.put("handlerFactories", (Object)handlerFactories);
        ServerConfig sc = new ServerConfig(json);
        Truth.assertThat((Integer)sc.getTimeout()).isEqualTo((Object)timeout);
        Truth.assertThat((Comparable)sc.getSessionHandling()).isEqualTo((Object)sessionHandling);
        Truth.assertThat((String)sc.getSessionCookieName()).isEqualTo((Object)sessionCookieName);
        Truth.assertThat((Comparable)sc.getCorrelationStrategy()).isEqualTo((Object)correlationStrategy);
        Truth.assertThat((Integer)sc.getTimeoutStatusCode()).isEqualTo((Object)timeoutStatusCode);
        Truth.assertThat((Iterable)sc.getEndpointConfigs()).contains((Object)epc);
        Truth.assertThat((Iterable)sc.getAuthChainConfig()).contains((Object)ahc);
        Truth.assertThat((String)sc.getErrorHandlerClassName()).isEqualTo((Object)ERROR_HANDLER);
        Truth.assertThat((String)sc.getErrorHandlerTemplate()).isEqualTo((Object)ERROR_TEMPLATE);
    }

    @Test
    @DisplayName(value="test the default constructor")
    void testDefaultConstructor() {
        ServerConfig sc = new ServerConfig();
        Truth.assertThat((Integer)sc.getPort()).isEqualTo((Object)8080);
        Truth.assertThat((Boolean)sc.isUseAlpn()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)sc.isCompressionSupported()).isEqualTo((Object)true);
        Truth.assertThat((Integer)sc.getCompressionLevel()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)sc.isDecompressionSupported()).isEqualTo((Object)true);
        Truth.assertThat((Iterable)sc.getHandlerFactoriesClassNames()).isEqualTo((Object)ServerConfig.DEFAULT_HANDLER_FACTORIES_CLASS_NAMES);
    }

    @Test
    @DisplayName(value="test getters and setters")
    void testGettersAndSetters() {
        ServerConfig sc = new ServerConfig();
        Truth.assertThat((Object)sc.setTimeout(1)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getTimeout()).isEqualTo((Object)1);
        ServerConfig.SessionHandling sessionHandling = ServerConfig.SessionHandling.LOCAL;
        Truth.assertThat((Object)sc.setSessionHandling(sessionHandling)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)sc.getSessionHandling()).isEqualTo((Object)sessionHandling);
        Truth.assertThat((Object)sc.setSessionCookieName("setSessionCookieName")).isSameInstanceAs((Object)sc);
        Truth.assertThat((String)sc.getSessionCookieName()).isEqualTo((Object)"setSessionCookieName");
        ServerConfig.CorrelationStrategy correlationStrategy = ServerConfig.CorrelationStrategy.GENERATE_UUID;
        Truth.assertThat((Object)sc.setCorrelationStrategy(correlationStrategy)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)sc.getCorrelationStrategy()).isEqualTo((Object)correlationStrategy);
        Truth.assertThat((Object)sc.setTimeoutStatusCode(2)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getTimeoutStatusCode()).isEqualTo((Object)2);
        List<EndpointConfig> endpointConfigs = List.of(new RawEndpoint().getDefaultConfig());
        Truth.assertThat((Object)sc.setEndpointConfigs(endpointConfigs)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getEndpointConfigs()).containsExactlyElementsIn(endpointConfigs);
        List<AuthHandlerConfig> authHandlerConfig = List.of(new AuthHandlerConfig());
        Truth.assertThat((Object)sc.setAuthChainConfig(authHandlerConfig)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getAuthChainConfig()).containsExactlyElementsIn(authHandlerConfig);
        Truth.assertThat((Object)sc.setErrorHandlerClassName(ERROR_HANDLER)).isSameInstanceAs((Object)sc);
        Truth.assertThat((String)sc.getErrorHandlerClassName()).isEqualTo((Object)ERROR_HANDLER);
        Truth.assertThat((Object)sc.setErrorHandlerTemplate(ERROR_TEMPLATE)).isSameInstanceAs((Object)sc);
        Truth.assertThat((String)sc.getErrorHandlerTemplate()).isEqualTo((Object)ERROR_TEMPLATE);
        Truth.assertThat((Object)sc.setHandlerFactoriesClassNames(FACTORY_CLASS_NAME_LIST)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getHandlerFactoriesClassNames()).isEqualTo(FACTORY_CLASS_NAME_LIST);
    }

    @Test
    @DisplayName(value="Overridden setters must be fluent and call super")
    void testOverriddenSetters() {
        ServerConfig sc = new ServerConfig();
        Truth.assertThat((Object)sc.addCrlPath("addCrlPath")).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getCrlPaths()).containsExactly(new Object[]{"addCrlPath"});
        Buffer crlValue = Buffer.buffer((String)"addCrlValue");
        Truth.assertThat((Object)sc.addCrlValue(crlValue)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getCrlValues()).containsExactly(new Object[]{crlValue});
        Truth.assertThat((Object)sc.addEnabledCipherSuite("addEnabledCipherSuite")).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getEnabledCipherSuites()).containsExactly(new Object[]{"addEnabledCipherSuite"});
        Truth.assertThat((Object)sc.addEnabledSecureTransportProtocol("addEnabledSecureTransportProtocol")).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getEnabledSecureTransportProtocols()).contains((Object)"addEnabledSecureTransportProtocol");
        Truth.assertThat((Object)sc.removeEnabledSecureTransportProtocol("addEnabledSecureTransportProtocol")).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getEnabledSecureTransportProtocols()).doesNotContain((Object)"addEnabledSecureTransportProtocol");
        Truth.assertThat((Object)sc.addWebSocketSubProtocol("addWebSocketSubProtocol")).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getWebSocketSubProtocols()).containsExactly(new Object[]{"addWebSocketSubProtocol"});
        Truth.assertThat((Object)sc.setAcceptBacklog(1)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getAcceptBacklog()).isEqualTo((Object)1);
        Truth.assertThat((Object)sc.setAcceptUnmaskedFrames(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isAcceptUnmaskedFrames()).isEqualTo((Object)false);
        List<HttpVersion> alpnVersions = List.of(HttpVersion.HTTP_1_0);
        Truth.assertThat((Object)sc.setAlpnVersions(alpnVersions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getAlpnVersions()).containsExactlyElementsIn(alpnVersions);
        ClientAuth clientAuth = ClientAuth.REQUEST;
        Truth.assertThat((Object)sc.setClientAuth(clientAuth)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)sc.getClientAuth()).isEqualTo((Object)clientAuth);
        Truth.assertThat((Object)sc.setCompressionLevel(2)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getCompressionLevel()).isEqualTo((Object)2);
        Truth.assertThat((Object)sc.setCompressionSupported(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isCompressionSupported()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setDecoderInitialBufferSize(3)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getDecoderInitialBufferSize()).isEqualTo((Object)3);
        Truth.assertThat((Object)sc.setDecompressionSupported(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isDecompressionSupported()).isEqualTo((Object)false);
        Set<String> protocols = Set.of("setEnabledSecureTransportProtocols");
        Truth.assertThat((Object)sc.setEnabledSecureTransportProtocols(protocols)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getEnabledSecureTransportProtocols()).containsExactlyElementsIn(protocols);
        Truth.assertThat((Object)sc.setHandle100ContinueAutomatically(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isHandle100ContinueAutomatically()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setHost("setHost")).isSameInstanceAs((Object)sc);
        Truth.assertThat((String)sc.getHost()).isEqualTo((Object)"setHost");
        Truth.assertThat((Object)sc.setHttp2ConnectionWindowSize(4)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getHttp2ConnectionWindowSize()).isEqualTo((Object)4);
        Truth.assertThat((Object)sc.setIdleTimeout(5)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getIdleTimeout()).isEqualTo((Object)5);
        TimeUnit timeUnit = TimeUnit.DAYS;
        Truth.assertThat((Object)sc.setIdleTimeoutUnit(timeUnit)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)((Object)sc.getIdleTimeoutUnit())).isEqualTo((Object)timeUnit);
        Http2Settings http2Settings = new Http2Settings();
        Truth.assertThat((Object)sc.setInitialSettings(http2Settings)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getInitialSettings()).isEqualTo((Object)http2Settings);
        JdkSSLEngineOptions jdkSSLEngineOptions = new JdkSSLEngineOptions();
        Truth.assertThat((Object)sc.setJdkSslEngineOptions(jdkSSLEngineOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getJdkSslEngineOptions()).isEqualTo((Object)jdkSSLEngineOptions);
        KeyCertOptions keyCertOptions = (KeyCertOptions)Mockito.mock(KeyCertOptions.class);
        Truth.assertThat((Object)sc.setKeyCertOptions(keyCertOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getKeyCertOptions()).isEqualTo((Object)keyCertOptions);
        JksOptions jksOptions = new JksOptions();
        Truth.assertThat((Object)sc.setKeyStoreOptions(jksOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getKeyStoreOptions()).isEqualTo((Object)jksOptions);
        Truth.assertThat((Object)sc.setLogActivity(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.getLogActivity()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setMaxChunkSize(6)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getMaxChunkSize()).isEqualTo((Object)6);
        Truth.assertThat((Object)sc.setMaxHeaderSize(7)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getMaxHeaderSize()).isEqualTo((Object)7);
        Truth.assertThat((Object)sc.setMaxInitialLineLength(8)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getMaxInitialLineLength()).isEqualTo((Object)8);
        Truth.assertThat((Object)sc.setMaxWebSocketFrameSize(9)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getMaxWebSocketFrameSize()).isEqualTo((Object)9);
        Truth.assertThat((Object)sc.setMaxWebSocketMessageSize(10)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getMaxWebSocketMessageSize()).isEqualTo((Object)10);
        OpenSSLEngineOptions openSSLEngineOptions = new OpenSSLEngineOptions();
        Truth.assertThat((Object)sc.setOpenSslEngineOptions(openSSLEngineOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getOpenSslEngineOptions()).isEqualTo((Object)openSSLEngineOptions);
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
        Truth.assertThat((Object)sc.setPemKeyCertOptions(pemKeyCertOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getPemKeyCertOptions()).isEqualTo((Object)pemKeyCertOptions);
        PemTrustOptions pemTrustOptions = new PemTrustOptions();
        Truth.assertThat((Object)sc.setPemTrustOptions(pemTrustOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getPemTrustOptions()).isEqualTo((Object)pemTrustOptions);
        Truth.assertThat((Object)sc.setPerFrameWebSocketCompressionSupported(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.getPerFrameWebSocketCompressionSupported()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setPerMessageWebSocketCompressionSupported(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.getPerMessageWebSocketCompressionSupported()).isEqualTo((Object)false);
        PfxOptions pfxOptions = new PfxOptions();
        Truth.assertThat((Object)sc.setPfxKeyCertOptions(pfxOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getPfxKeyCertOptions()).isEqualTo((Object)pfxOptions);
        Truth.assertThat((Object)sc.setPfxTrustOptions(pfxOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getPfxTrustOptions()).isEqualTo((Object)pfxOptions);
        Truth.assertThat((Object)sc.setPort(11)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getPort()).isEqualTo((Object)11);
        Truth.assertThat((Object)sc.setProxyProtocolTimeout(12L)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Long)sc.getProxyProtocolTimeout()).isEqualTo((Object)12L);
        timeUnit = TimeUnit.HOURS;
        Truth.assertThat((Object)sc.setProxyProtocolTimeoutUnit(timeUnit)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)((Object)sc.getProxyProtocolTimeoutUnit())).isEqualTo((Object)timeUnit);
        Truth.assertThat((Object)sc.setReceiveBufferSize(13)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getReceiveBufferSize()).isEqualTo((Object)13);
        Truth.assertThat((Object)sc.setReuseAddress(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isReuseAddress()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setReusePort(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isReusePort()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setSendBufferSize(14)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getSendBufferSize()).isEqualTo((Object)14);
        Truth.assertThat((Object)sc.setSni(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isSni()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setSoLinger(15)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getSoLinger()).isEqualTo((Object)15);
        Truth.assertThat((Object)sc.setSsl(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isSsl()).isEqualTo((Object)false);
        SSLEngineOptions sSLEngineOptions = (SSLEngineOptions)Mockito.mock(SSLEngineOptions.class);
        Truth.assertThat((Object)sc.setSslEngineOptions(sSLEngineOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getSslEngineOptions()).isEqualTo((Object)sSLEngineOptions);
        Truth.assertThat((Object)sc.setSslHandshakeTimeout(16L)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Long)sc.getSslHandshakeTimeout()).isEqualTo((Object)16L);
        timeUnit = TimeUnit.MINUTES;
        Truth.assertThat((Object)sc.setProxyProtocolTimeoutUnit(timeUnit)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)((Object)sc.getProxyProtocolTimeoutUnit())).isEqualTo((Object)timeUnit);
        Truth.assertThat((Object)sc.setTcpCork(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isTcpCork()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setTcpFastOpen(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isTcpFastOpen()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setTcpKeepAlive(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isTcpKeepAlive()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setTcpNoDelay(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isTcpNoDelay()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setTcpQuickAck(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isTcpQuickAck()).isEqualTo((Object)false);
        TracingPolicy tracingPolicy = TracingPolicy.ALWAYS;
        Truth.assertThat((Object)sc.setTracingPolicy(tracingPolicy)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Comparable)sc.getTracingPolicy()).isEqualTo((Object)tracingPolicy);
        Truth.assertThat((Object)sc.setTrafficClass(17)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getTrafficClass()).isEqualTo((Object)17);
        TrustOptions trustOptions = (TrustOptions)Mockito.mock(TrustOptions.class);
        Truth.assertThat((Object)sc.setTrustOptions(trustOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getTrustOptions()).isEqualTo((Object)trustOptions);
        Truth.assertThat((Object)sc.setTrustStoreOptions(jksOptions)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Object)sc.getTrustStoreOptions()).isEqualTo((Object)jksOptions);
        Truth.assertThat((Object)sc.setUseAlpn(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isUseAlpn()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setUseProxyProtocol(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.isUseProxyProtocol()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setWebSocketAllowServerNoContext(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.getWebSocketAllowServerNoContext()).isEqualTo((Object)false);
        Truth.assertThat((Object)sc.setWebSocketCompressionLevel(18)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Integer)sc.getWebSocketCompressionLevel()).isEqualTo((Object)18);
        Truth.assertThat((Object)sc.setWebSocketPreferredClientNoContext(false)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Boolean)sc.getWebSocketPreferredClientNoContext()).isEqualTo((Object)false);
        List<String> subProtocols = List.of("");
        Truth.assertThat((Object)sc.setWebSocketSubProtocols(subProtocols)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getWebSocketSubProtocols()).containsExactlyElementsIn(subProtocols);
        Truth.assertThat((Object)sc.setHandlerFactoriesClassNames(FACTORY_CLASS_NAME_LIST)).isSameInstanceAs((Object)sc);
        Truth.assertThat((Iterable)sc.getHandlerFactoriesClassNames()).containsExactlyElementsIn(FACTORY_CLASS_NAME_LIST);
    }
}

