/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.truth.Truth;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.data.internal.DataVerticleCoordinateImpl;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.junit5.Timeout;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class DataContextImplTest {
    DataContextImpl context;

    DataContextImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.context = new DataContextImpl("correlationId", "sessionId", "bearerToken", new JsonObject().put("username", (Object)"Duke"), null, null);
    }

    @Test
    void testEncodeContextToString() {
        this.context.pushVerticleToPath("Data1Verticle");
        this.context.amendTopVerticleCoordinate("deploymentId1");
        this.context.pushVerticleToPath("Data2Verticle");
        this.context.amendTopVerticleCoordinate("deploymentId2");
        String json = DataContextImpl.encodeContextToString((DataContext)this.context);
        JsonObject jsonObject = new JsonObject(json);
        Truth.assertThat((Iterable)jsonObject.getJsonArray("path")).hasSize(2);
    }

    @Test
    void testDecodeContextFromString() {
        String json = "{\"correlationId\":\"correlationId\",\"sessionId\":\"sessionId\",\"bearerToken\":\"bearerToken\",\"userPrincipal\":{\"username\":\"Duke\"},\"data\":{},\"path\":[{\"qualifiedName\":\"Data1Verticle\",\"deploymentId\":\"deploymentId1\",\"ipAddress\":\"ip1\"},{\"qualifiedName\":\"Data2Verticle\",\"deploymentId\":\"deploymentId2\",\"ipAddress\":\"ip2\"}]}";
        DataContext context2 = DataContextImpl.decodeContextFromString((String)json);
        Assertions.assertEquals((Object)context2.correlationId(), (Object)"correlationId");
        Assertions.assertEquals((Object)context2.sessionId(), (Object)"sessionId");
        Assertions.assertEquals((Object)context2.bearerToken(), (Object)"bearerToken");
        Assertions.assertEquals((Object)context2.userPrincipal(), (Object)new JsonObject().put("username", (Object)"Duke"));
        Assertions.assertEquals((int)2, (int)this.contextPathSize(context2));
        Iterator path = context2.path();
        DataContext.DataVerticleCoordinate coordinate = (DataContext.DataVerticleCoordinate)path.next();
        Truth.assertThat((String)coordinate.getQualifiedName()).isEqualTo((Object)"Data1Verticle");
        Truth.assertThat((String)coordinate.getDeploymentId()).isEqualTo((Object)"deploymentId1");
        Truth.assertThat((String)coordinate.getIpAddress()).isEqualTo((Object)"ip1");
        coordinate = (DataContext.DataVerticleCoordinate)path.next();
        Truth.assertThat((String)coordinate.getQualifiedName()).isEqualTo((Object)"Data2Verticle");
        Truth.assertThat((String)coordinate.getDeploymentId()).isEqualTo((Object)"deploymentId2");
        Truth.assertThat((String)coordinate.getIpAddress()).isEqualTo((Object)"ip2");
    }

    @Test
    void testAddVerticleToPath() {
        this.context.pushVerticleToPath("DataVerticle");
        DataContext.DataVerticleCoordinate coordinate = (DataContext.DataVerticleCoordinate)this.context.path().next();
        Assertions.assertEquals((int)1, (int)this.contextPathSize((DataContext)this.context));
        Assertions.assertEquals((Object)"DataVerticle", (Object)coordinate.getQualifiedName());
        Assert.assertNull((Object)coordinate.getDeploymentId());
    }

    @Test
    void testAmendVerticleCoordinate() {
        this.context.pushVerticleToPath("DataVerticle");
        this.context.amendTopVerticleCoordinate("deploymentId");
        DataContext.DataVerticleCoordinate coordinate = (DataContext.DataVerticleCoordinate)this.context.path().next();
        Assertions.assertEquals((int)1, (int)this.contextPathSize((DataContext)this.context));
        Assertions.assertEquals((Object)"DataVerticle", (Object)coordinate.getQualifiedName());
        Assertions.assertEquals((Object)"deploymentId", (Object)coordinate.getDeploymentId());
    }

    @Test
    void testRemoveVerticleFromPath() {
        this.context.pushVerticleToPath("DataVerticle");
        this.context.pushVerticleToPath("Data1Verticle");
        Assertions.assertEquals((int)2, (int)this.contextPathSize((DataContext)this.context));
        this.context.popVerticleFromPath();
        Assertions.assertEquals((int)1, (int)this.contextPathSize((DataContext)this.context));
    }

    @Test
    void testPaths() {
        this.context.pushVerticleToPath("DataVerticle");
        this.context.pushVerticleToPath("Data1Verticle");
        Assertions.assertEquals((int)2, (int)this.contextPathSize((DataContext)this.context));
    }

    @Test
    void testPathAsString() {
        this.context.pushVerticleToPath("Data1Verticle");
        this.context.amendTopVerticleCoordinate("deploymentId1");
        this.context.pushVerticleToPath("Data2Verticle");
        this.context.amendTopVerticleCoordinate("deploymentId2");
        Assertions.assertEquals((int)2, (int)this.context.pathAsString().split(System.lineSeparator()).length);
    }

    @Test
    @DisplayName(value="can update response timestamp LocalTime format")
    void testUpdateTimestamp() {
        this.context.pushVerticleToPath("DataVerticle");
        this.context.amendTopVerticleCoordinate("deploymentId1");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)this.context.path().next()).getResponseTimestamp()).isNull();
        this.context.updateResponseTimestamp();
        Truth.assertThat((Comparable)LocalTime.parse(((DataContext.DataVerticleCoordinate)this.context.path().next()).getResponseTimestamp())).isNotNull();
    }

    @Test
    void testPathStackHandling() {
        this.context.pushVerticleToPath("A");
        this.context.amendTopVerticleCoordinate("A-ID");
        this.context.pushVerticleToPath("B");
        this.context.amendTopVerticleCoordinate("B-ID");
        Assertions.assertEquals((int)2, (int)this.contextPathSize((DataContext)this.context));
        List paths = Streams.stream((Iterator)this.context.path()).collect(Collectors.toList());
        Truth.assertThat(paths).hasSize(2);
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)paths.get(0)).getQualifiedName()).isEqualTo((Object)"A");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)paths.get(1)).getQualifiedName()).isEqualTo((Object)"B");
        this.context.pushVerticleToPath("C");
        String contextString = DataContextImpl.encodeContextToString((DataContext)this.context);
        DataContextImpl context2 = (DataContextImpl)DataContextImpl.decodeContextFromString((String)contextString);
        context2.amendTopVerticleCoordinate("C-ID");
        paths = Streams.stream((Iterator)this.context.path()).collect(Collectors.toList());
        Truth.assertThat(paths).hasSize(3);
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)paths.get(0)).getQualifiedName()).isEqualTo((Object)"A");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)paths.get(1)).getQualifiedName()).isEqualTo((Object)"B");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)paths.get(2)).getQualifiedName()).isEqualTo((Object)"C");
    }

    @Test
    void testSpecialCasesWerePathsList() {
        DataContextImpl initialContext = new DataContextImpl("correlationId", "sessionId", "bearerToken", new JsonObject().put("username", (Object)"Duke"), Map.of(), null);
        Truth.assertThat((Boolean)initialContext.path().hasNext()).isFalse();
        Assertions.assertDoesNotThrow(() -> initialContext.amendTopVerticleCoordinate("deploymentId1"));
        Assertions.assertThrows(NoSuchElementException.class, () -> initialContext.popVerticleFromPath());
    }

    @Test
    @DisplayName(value="DataVerticleCoordinate toString")
    void testToString() {
        DataVerticleCoordinateImpl coordinate = new DataVerticleCoordinateImpl("DataVerticle").setDeploymentId("deploymentid").setIpAddress("ipAddress");
        Truth.assertThat((String)coordinate.toString()).matches("\\d{2}:\\d{2}:\\d{2}.\\d{4,} DataVerticle\\[deploymentid\\]@ipAddress");
        coordinate.updateResponseTimestamp();
        Truth.assertThat((String)coordinate.toString()).matches("\\d{2}:\\d{2}:\\d{2}.\\d{4,} DataVerticle\\[deploymentid\\]@ipAddress \\d{2}:\\d{2}:\\d{2}.\\d{4,}");
    }

    @Test
    void testCopy() {
        DataContextImpl copy = this.context.copy();
        Assert.assertNotSame((Object)copy, (Object)this.context);
        Assert.assertNotSame((Object)copy.path(), (Object)this.context.path());
    }

    @Test
    void testSelfCalling() {
        this.context.pushVerticleToPath("Data1Verticle");
        Assertions.assertThrows(DataException.class, () -> this.context.pushVerticleToPath("Data1Verticle"));
    }

    @Test
    @DisplayName(value="set path")
    void testSetPath() {
        this.context.pushVerticleToPath("1");
        this.context.pushVerticleToPath("2");
        this.context.pushVerticleToPath("3");
        ArrayList snapshot = new ArrayList();
        this.context.path().forEachRemaining(snapshot::add);
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(0)).getQualifiedName()).isEqualTo((Object)"1");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(1)).getQualifiedName()).isEqualTo((Object)"2");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(2)).getQualifiedName()).isEqualTo((Object)"3");
        DataContextImpl context2 = new DataContextImpl((DataContext)this.context);
        snapshot.clear();
        context2.path().forEachRemaining(snapshot::add);
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(0)).getQualifiedName()).isEqualTo((Object)"1");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(1)).getQualifiedName()).isEqualTo((Object)"2");
        Truth.assertThat((String)((DataContext.DataVerticleCoordinate)snapshot.get(2)).getQualifiedName()).isEqualTo((Object)"3");
    }

    @Test
    @DisplayName(value="Basic methods")
    void testVerticleCoordinate() {
        DataVerticleCoordinateImpl coordinate = new DataVerticleCoordinateImpl("qualifiedName").setIpAddress("ipAddress").setDeploymentId("instanceId").updateResponseTimestamp();
        Assertions.assertEquals((Object)"instanceId", (Object)coordinate.getDeploymentId());
        Assertions.assertEquals((Object)"ipAddress", (Object)coordinate.getIpAddress());
        Assertions.assertEquals((Object)"qualifiedName", (Object)coordinate.getQualifiedName());
        Assert.assertNotNull((Object)coordinate.getRequestTimestamp());
        Assert.assertNotNull((Object)coordinate.getResponseTimestamp());
        Truth.assertThat((String)coordinate.toString()).contains((CharSequence)"qualifiedName[instanceId]@ipAddress");
    }

    @Test
    @DisplayName(value="it should be fine to create a empty context")
    void testNewContextConstructor() {
        this.testEmptyContext((DataContext)new DataContextImpl());
    }

    @Test
    @DisplayName(value="it should be fine to create a empty context with null values for the constructor")
    void testNullValueContextConstructor() {
        this.testEmptyContext((DataContext)new DataContextImpl(null, null, null, null, (Map)null));
    }

    private void testEmptyContext(DataContext context) {
        Truth.assertThat((String)context.correlationId()).isNull();
        Truth.assertThat((Iterable)context.userPrincipal()).isNull();
        Truth.assertThat((Map)context.data()).isNotNull();
        Truth.assertThat((Map)context.data()).isEmpty();
    }

    @Test
    @DisplayName(value="the context should accept any correlation id (incl. null)")
    void testCorrelationId() {
        Truth.assertThat((String)new DataContextImpl("expected1", null, null, null, (Map)null).correlationId()).isEqualTo((Object)"expected1");
        Truth.assertThat((String)new DataContextImpl("expected2", null, null, null, (Map)null).correlationId()).isEqualTo((Object)"expected2");
        Truth.assertThat((String)new DataContextImpl(null, null, null, null, (Map)null).correlationId()).isNull();
    }

    @Test
    @DisplayName(value="the context should accept any bearer token (incl. null)")
    void testBearerToken() {
        Truth.assertThat((String)new DataContextImpl(null, null, "expected1", null, null).bearerToken()).isEqualTo((Object)"expected1");
        Truth.assertThat((String)new DataContextImpl(null, null, "expected2", null, null).bearerToken()).isEqualTo((Object)"expected2");
        Truth.assertThat((String)new DataContextImpl(null, null, null, null, (Map)null).bearerToken()).isNull();
    }

    @Test
    @DisplayName(value="the context should accept any user principal (incl. null)")
    void testUserPrincipal() {
        Truth.assertThat((Iterable)new DataContextImpl(null, null, null, new JsonObject(), null).userPrincipal()).isInstanceOf(JsonObject.class);
        Truth.assertThat((String)new DataContextImpl(null, null, null, new JsonObject().put("anyAttribute", (Object)"anyExpectedValue"), null).userPrincipal().getString("anyAttribute")).isEqualTo((Object)"anyExpectedValue");
        Truth.assertThat((Iterable)new DataContextImpl(null, null, null, null, (Map)null).userPrincipal()).isNull();
    }

    @Test
    @DisplayName(value="the user principal of a context should be immutable")
    void testUserPrincipalImmutable() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new DataContextImpl(null, null, null, new JsonObject(), null).userPrincipal().put("anyAttribute", (Object)"anyValue"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new DataContextImpl(null, null, null, new JsonObject(), null).userPrincipal().remove("anyAttribute"));
    }

    @Test
    @DisplayName(value="the user arbitrary data of a context")
    void testArbitraryData() {
        Truth.assertThat((Map)new DataContextImpl(null, null, null, null, (Map)null).data()).isEmpty();
        Assertions.assertDoesNotThrow(() -> new DataContextImpl(null, null, null, null, Collections.emptyMap()).data().put("anyAttribute", "anyValue"));
        Truth.assertThat((Map)new DataContextImpl(null, null, null, null, Collections.singletonMap("expectedKey", "expectedValue")).data()).containsExactly((Object)"expectedKey", (Object)"expectedValue", new Object[0]);
        Truth.assertThat((Map)new DataContextImpl(null, null, null, null, Collections.singletonMap("expectedKey", "expectedValue")).setData(null).data()).isEmpty();
    }

    static Stream<Arguments> withSessions() {
        String expectedSessionValue = "expectedSessId";
        Session sessionMock = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)sessionMock.id()).thenReturn((Object)expectedSessionValue);
        return Stream.of(Arguments.of((Object[])new Object[]{sessionMock, expectedSessionValue}), Arguments.of((Object[])new Object[]{null, "noSessionIdAvailable"}));
    }

    @ParameterizedTest(name="{index}: with session: {0}")
    @MethodSource(value={"withSessions"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Constructor that accepts RoutingContext works correct")
    void testWithRoutingContext(Session sessionMock, String expectedSessionValue) {
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        HttpServerRequest requestMock = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
        User userMock = (User)Mockito.mock(User.class);
        Mockito.when((Object)requestMock.getHeader(HttpHeaders.AUTHORIZATION)).thenReturn((Object)"Bearer anyExpectedToken123");
        Mockito.when((Object)userMock.principal()).thenReturn((Object)new JsonObject().put("expectedKey", (Object)"expectedValue"));
        Mockito.when((Object)routingContextMock.get("correlationId")).thenReturn((Object)"expectedCorrId");
        Mockito.when((Object)routingContextMock.session()).thenReturn((Object)sessionMock);
        Mockito.when((Object)routingContextMock.user()).thenReturn((Object)userMock);
        Mockito.when((Object)routingContextMock.request()).thenReturn((Object)requestMock);
        DataContextImpl dataContext = new DataContextImpl(routingContextMock);
        Truth.assertThat((String)dataContext.correlationId()).isEqualTo((Object)"expectedCorrId");
        Truth.assertThat((String)dataContext.sessionId()).isEqualTo((Object)expectedSessionValue);
        Truth.assertThat((String)dataContext.bearerToken()).isEqualTo((Object)"anyExpectedToken123");
        Truth.assertThat((String)dataContext.userPrincipal().getString("expectedKey")).isEqualTo((Object)"expectedValue");
    }

    @Test
    @DisplayName(value="test encoding / decoding null context")
    void testNullEncodeDecode() {
        DataContext dataContext = DataContextImpl.decodeContextFromString((String)DataContextImpl.encodeContextToString((DataContext)new DataContextImpl(null, null, null, null, (Map)null)));
        Truth.assertThat((String)dataContext.correlationId()).isNull();
        Truth.assertThat((String)dataContext.sessionId()).isNull();
        Truth.assertThat((String)dataContext.bearerToken()).isNull();
        Truth.assertThat((Iterable)dataContext.userPrincipal()).isNull();
        Truth.assertThat((Map)dataContext.data()).isEmpty();
    }

    @Test
    @DisplayName(value="test encoding / decoding context")
    void testEncodeDecode() {
        DataContext dataContext = DataContextImpl.decodeContextFromString((String)DataContextImpl.encodeContextToString((DataContext)new DataContextImpl("expected1", "expectedSessionId", "expected2", new JsonObject().put("expectedKey", (Object)"expectedValue"), new JsonObject().put("expected1", (Object)"expected2").put("expectedArray", (Object)new JsonArray().add((Object)0)).put("expectedNull", null).getMap())));
        Truth.assertThat((String)dataContext.correlationId()).isEqualTo((Object)"expected1");
        Truth.assertThat((String)dataContext.sessionId()).isEqualTo((Object)"expectedSessionId");
        Truth.assertThat((String)dataContext.bearerToken()).isEqualTo((Object)"expected2");
        Truth.assertThat((Iterable)dataContext.userPrincipal()).isEqualTo((Object)new JsonObject().put("expectedKey", (Object)"expectedValue"));
        Truth.assertThat((Iterable)new JsonObject(dataContext.data())).isEqualTo((Object)new JsonObject().put("expected1", (Object)"expected2").put("expectedArray", (Object)new JsonArray().add((Object)0)).put("expectedNull", null));
    }

    private int contextPathSize(DataContext context) {
        return Iterators.size((Iterator)context.path());
    }
}

