/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal.metrics;

import com.google.common.truth.Truth;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.neonbee.data.internal.metrics.ConfiguredDataVerticleMetrics;
import io.neonbee.data.internal.metrics.DataVerticleMetrics;
import io.neonbee.data.internal.metrics.DataVerticleMetricsImpl;
import io.neonbee.data.internal.metrics.NoopDataVerticleMetrics;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.backends.BackendRegistries;
import java.util.List;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ConfiguredDataVerticleMetricsTest {
    ConfiguredDataVerticleMetricsTest() {
    }

    @Test
    @DisplayName(value="Test null config")
    void nullConfig() {
        DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting(null);
        Truth.assertThat((Object)instance).isInstanceOf(NoopDataVerticleMetrics.class);
    }

    @Test
    @DisplayName(value="Test no config")
    void noConfig() {
        DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)new JsonObject());
        Truth.assertThat((Object)instance).isInstanceOf(NoopDataVerticleMetrics.class);
    }

    @Test
    @DisplayName(value="Test metrics disabled")
    void disabled() {
        JsonObject config = new JsonObject().put("enabled", (Object)false);
        DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
        Truth.assertThat((Object)instance).isInstanceOf(NoopDataVerticleMetrics.class);
    }

    @Test
    @DisplayName(value="Test metrics disabled, enabled is null")
    void disabledNull() {
        JsonObject config = new JsonObject().put("enabled", null);
        DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
        Truth.assertThat((Object)instance).isInstanceOf(NoopDataVerticleMetrics.class);
    }

    @DisabledIfEnvironmentVariable(named="GITHUB_ACTIONS", matches="true", disabledReason="This test fails on github and needs to be fixed.")
    @Test
    @DisplayName(value="backend meter registry is null")
    void backendMeterRegistriesNull() {
        JsonObject config = new JsonObject().put("enabled", (Object)true);
        DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
        Truth.assertThat((Object)instance).isInstanceOf(NoopDataVerticleMetrics.class);
    }

    @Test
    @DisplayName(value="Test minimal config, all metrics should be reported")
    void minimalEnabled() {
        JsonObject config = new JsonObject().put("enabled", (Object)true);
        MeterRegistry mockRegistry = (MeterRegistry)Mockito.mock(MeterRegistry.class);
        try (MockedStatic registry = Mockito.mockStatic(BackendRegistries.class);){
            registry.when(() -> BackendRegistries.getNow((String)ArgumentMatchers.anyString())).thenReturn((Object)mockRegistry);
            DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
            Truth.assertThat((Object)instance).isInstanceOf(DataVerticleMetricsImpl.class);
        }
    }

    @Test
    @DisplayName(value="Test config with all values provided")
    void configWithAllValuesEnabled() {
        JsonObject config = new JsonObject().put("enabled", (Object)true).put("meterRegistryName", (Object)"SomeRegistryName").put("reportNumberOfRequests", (Object)true).put("reportActiveRequests", (Object)true).put("reportStatusCounter", (Object)true).put("reportTiming", (Object)true);
        MeterRegistry mockRegistry = (MeterRegistry)Mockito.mock(MeterRegistry.class);
        try (MockedStatic registry = Mockito.mockStatic(BackendRegistries.class);){
            registry.when(() -> BackendRegistries.getNow((String)ArgumentMatchers.anyString())).thenReturn((Object)mockRegistry);
            DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
            Truth.assertThat((Object)instance).isInstanceOf(ConfiguredDataVerticleMetrics.class);
            ConfiguredDataVerticleMetrics configuredInstance = (ConfiguredDataVerticleMetrics)instance;
            Truth.assertThat((Object)configuredInstance.reportNumberOfRequests).isInstanceOf(DataVerticleMetricsImpl.class);
            Truth.assertThat((Object)configuredInstance.reportActiveRequestsGauge).isInstanceOf(DataVerticleMetricsImpl.class);
            Truth.assertThat((Object)configuredInstance.reportStatusCounter).isInstanceOf(DataVerticleMetricsImpl.class);
            Truth.assertThat((Object)configuredInstance.reportTimingMetric).isInstanceOf(DataVerticleMetricsImpl.class);
        }
    }

    @Test
    @DisplayName(value="Test config with all values provided but disabled")
    void configWithAllValuesDisabled() {
        JsonObject config = new JsonObject().put("enabled", (Object)true).put("meterRegistryName", (Object)"SomeRegistryName").put("reportNumberOfRequests", (Object)false).put("reportActiveRequests", (Object)false).put("reportStatusCounter", (Object)false).put("reportTiming", (Object)false);
        MeterRegistry mockRegistry = (MeterRegistry)Mockito.mock(MeterRegistry.class);
        try (MockedStatic registry = Mockito.mockStatic(BackendRegistries.class);){
            registry.when(() -> BackendRegistries.getNow((String)ArgumentMatchers.anyString())).thenReturn((Object)mockRegistry);
            DataVerticleMetrics instance = ConfiguredDataVerticleMetrics.configureMetricsReporting((JsonObject)config);
            Truth.assertThat((Object)instance).isInstanceOf(ConfiguredDataVerticleMetrics.class);
            ConfiguredDataVerticleMetrics configuredInstance = (ConfiguredDataVerticleMetrics)instance;
            Truth.assertThat((Object)configuredInstance.reportNumberOfRequests).isInstanceOf(NoopDataVerticleMetrics.class);
            Truth.assertThat((Object)configuredInstance.reportActiveRequestsGauge).isInstanceOf(NoopDataVerticleMetrics.class);
            Truth.assertThat((Object)configuredInstance.reportStatusCounter).isInstanceOf(NoopDataVerticleMetrics.class);
            Truth.assertThat((Object)configuredInstance.reportTimingMetric).isInstanceOf(NoopDataVerticleMetrics.class);
            List<ImmutableTag> tags = List.of(new ImmutableTag("key", "value"));
            configuredInstance.reportNumberOfRequests("name", "description", tags);
            configuredInstance.reportActiveRequestsGauge("name", "description", tags, Future.succeededFuture());
            configuredInstance.reportStatusCounter("name", "description", tags, Future.succeededFuture());
            configuredInstance.reportTimingMetric("name", "description", tags, Future.succeededFuture());
        }
    }

    @Test
    @DisplayName(value="Test invocations")
    void invocations() {
        NoopDataVerticleMetrics spyReportNumberOfRequests = (NoopDataVerticleMetrics)Mockito.spy((Object)ConfiguredDataVerticleMetrics.DUMMY_IMPL);
        NoopDataVerticleMetrics spyReportActiveRequestsGauge = (NoopDataVerticleMetrics)Mockito.spy((Object)ConfiguredDataVerticleMetrics.DUMMY_IMPL);
        NoopDataVerticleMetrics spyReportStatusCounter = (NoopDataVerticleMetrics)Mockito.spy((Object)ConfiguredDataVerticleMetrics.DUMMY_IMPL);
        NoopDataVerticleMetrics spyReportTimingMetric = (NoopDataVerticleMetrics)Mockito.spy((Object)ConfiguredDataVerticleMetrics.DUMMY_IMPL);
        ConfiguredDataVerticleMetrics configuredInstance = new ConfiguredDataVerticleMetrics((DataVerticleMetrics)spyReportNumberOfRequests, (DataVerticleMetrics)spyReportActiveRequestsGauge, (DataVerticleMetrics)spyReportStatusCounter, (DataVerticleMetrics)spyReportTimingMetric);
        List<ImmutableTag> tags = List.of(new ImmutableTag("key", "value"));
        configuredInstance.reportNumberOfRequests("name", "description", tags);
        configuredInstance.reportActiveRequestsGauge("name", "description", tags, Future.succeededFuture());
        configuredInstance.reportStatusCounter("name", "description", tags, Future.succeededFuture());
        configuredInstance.reportTimingMetric("name", "description", tags, Future.succeededFuture());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportNumberOfRequests, (VerificationMode)Mockito.times((int)1))).reportNumberOfRequests((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags));
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportNumberOfRequests, (VerificationMode)Mockito.never())).reportActiveRequestsGauge((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportNumberOfRequests, (VerificationMode)Mockito.never())).reportStatusCounter((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportNumberOfRequests, (VerificationMode)Mockito.never())).reportTimingMetric((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportActiveRequestsGauge, (VerificationMode)Mockito.times((int)1))).reportActiveRequestsGauge((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportActiveRequestsGauge, (VerificationMode)Mockito.never())).reportNumberOfRequests((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags));
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportActiveRequestsGauge, (VerificationMode)Mockito.never())).reportStatusCounter((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportActiveRequestsGauge, (VerificationMode)Mockito.never())).reportTimingMetric((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportStatusCounter, (VerificationMode)Mockito.times((int)1))).reportStatusCounter((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportStatusCounter, (VerificationMode)Mockito.never())).reportNumberOfRequests((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags));
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportStatusCounter, (VerificationMode)Mockito.never())).reportActiveRequestsGauge((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportStatusCounter, (VerificationMode)Mockito.never())).reportTimingMetric((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportTimingMetric, (VerificationMode)Mockito.times((int)1))).reportTimingMetric((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportTimingMetric, (VerificationMode)Mockito.never())).reportNumberOfRequests((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags));
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportTimingMetric, (VerificationMode)Mockito.never())).reportActiveRequestsGauge((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (List)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
        ((NoopDataVerticleMetrics)Mockito.verify((Object)spyReportTimingMetric, (VerificationMode)Mockito.never())).reportStatusCounter((String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"description"), (Iterable)ArgumentMatchers.eq(tags), (Future)ArgumentMatchers.any());
    }
}

