/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal.metrics;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.data.internal.metrics.TestRequireDataVerticle;
import io.neonbee.data.internal.metrics.TestSourceDataVerticle;
import io.neonbee.test.helper.SystemHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class DataVerticleMetricsImplTest {
    DataVerticleMetricsImplTest() {
    }

    @Test
    @Timeout(value=1, timeUnit=TimeUnit.MINUTES)
    void testMetricsOnPrometheusEndpoint(Vertx vertx, VertxTestContext context) throws Exception {
        int port = SystemHelper.getFreePort();
        NeonBeeOptions.Mutable options = new NeonBeeOptions.Mutable();
        options.setServerPort(Integer.valueOf(port));
        options.setIgnoreClassPath(true);
        NeonBeeConfig config = new NeonBeeConfig();
        config.getMetricsConfig().setEnabled(true);
        NeonBee.create((NeonBeeOptions)options, (NeonBeeConfig)config).onComplete(context.succeeding(neonBee -> {
            DeploymentOptions deploymentOptions = new DeploymentOptions();
            deploymentOptions.setConfig(new JsonObject().put("metrics", (Object)new JsonObject().put("enabled", (Object)true)));
            CompositeFuture.all((Future)neonBee.getVertx().deployVerticle((Verticle)new TestSourceDataVerticle(), deploymentOptions), (Future)neonBee.getVertx().deployVerticle((Verticle)new TestRequireDataVerticle(), deploymentOptions)).onComplete(context.succeeding(event -> {
                HttpRequest<Buffer> request = this.createRequest((NeonBee)neonBee, HttpMethod.GET, "/raw/" + TestRequireDataVerticle.QUALIFIED_NAME);
                request.send().onComplete(context.succeeding(resp -> context.verify(() -> {
                    Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)200);
                    Truth.assertThat((String)resp.bodyAsString()).isEqualTo((Object)"\"TestRequireDataVerticle[TestSourceDataVerticle content]\"");
                }))).compose(unused -> this.createRequest((NeonBee)neonBee, HttpMethod.GET, "/metrics").send().onComplete(context.succeeding(resp -> context.verify(() -> {
                    Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)200);
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_data_timer_test_TestSourceDataVerticle_seconds_count{query=\"\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_data_timer_test_TestSourceDataVerticle_seconds_sum{query=\"\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_data_timer_test_TestSourceDataVerticle_seconds_max{query=\"\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_data_counter_test_TestSourceDataVerticle_total{query=\"\",succeeded=\"true\",} 1.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_data_active_requests_test_TestSourceDataVerticle 0.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"request_counter_test_TestSourceDataVerticle_total{query=\"\",} 1.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_timer_DataVerticle_test_TestSourceDataVerticle__seconds_max{name=\"TestSourceDataVerticle\",namespace=\"test\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_counter_DataVerticle_test_TestSourceDataVerticle__total{name=\"TestSourceDataVerticle\",namespace=\"test\",succeeded=\"true\",} 1.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_active_requests_DataVerticle_test_TestSourceDataVerticle_{name=\"TestSourceDataVerticle\",namespace=\"test\",} 0.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_counter_DataVerticle_test_TestSourceDataVerticle__total{name=\"TestSourceDataVerticle\",namespace=\"test\",} 1.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_timer_DataVerticle_test_TestRequireDataVerticle__seconds_count{name=\"TestRequireDataVerticle\",namespace=\"test\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_timer_DataVerticle_test_TestRequireDataVerticle__seconds_sum{name=\"TestRequireDataVerticle\",namespace=\"test\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_timer_DataVerticle_test_TestRequireDataVerticle__seconds_max{name=\"TestRequireDataVerticle\",namespace=\"test\",} ");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_counter_DataVerticle_test_TestRequireDataVerticle__total{name=\"TestRequireDataVerticle\",namespace=\"test\",succeeded=\"true\",} 1.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_data_active_requests_DataVerticle_test_TestRequireDataVerticle_{name=\"TestRequireDataVerticle\",namespace=\"test\",} 0.0");
                    Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)"retrieve_counter_DataVerticle_test_TestRequireDataVerticle__total{name=\"TestRequireDataVerticle\",namespace=\"test\",} 1.0");
                    neonBee.getVertx().close(context.succeeding(e -> context.completeNow()));
                }))));
            }));
        }));
    }

    public HttpRequest<Buffer> createRequest(NeonBee neonBee, HttpMethod method, String path) {
        WebClientOptions opts = new WebClientOptions().setDefaultHost("localhost").setDefaultPort(neonBee.getOptions().getServerPort().intValue());
        return WebClient.create((Vertx)neonBee.getVertx(), (WebClientOptions)opts).request(method, path);
    }
}

