/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.health;

import io.neonbee.data.DataContext;
import io.neonbee.endpoint.health.HealthCheckHandler;
import io.neonbee.health.HealthCheckRegistry;
import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class HealthCheckHandlerTest {
    HealthCheckRegistry registry;
    RoutingContext routingContext;
    HttpServerResponse httpServerResponse;

    HealthCheckHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.registry = (HealthCheckRegistry)Mockito.mock(HealthCheckRegistry.class);
        this.routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        this.httpServerResponse = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
        Mockito.when((Object)this.httpServerResponse.setStatusCode(ArgumentMatchers.anyInt())).thenReturn((Object)this.httpServerResponse);
        Mockito.when((Object)this.httpServerResponse.setStatusMessage(ArgumentMatchers.anyString())).thenReturn((Object)this.httpServerResponse);
        Mockito.when((Object)this.httpServerResponse.putHeader((CharSequence)ArgumentMatchers.any(CharSequence.class), (CharSequence)ArgumentMatchers.any(CharSequence.class))).thenReturn((Object)this.httpServerResponse);
        Mockito.when((Object)this.httpServerResponse.end()).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)this.routingContext.response()).thenReturn((Object)this.httpServerResponse);
        Mockito.when((Object)this.routingContext.request()).thenReturn((Object)((HttpServerRequest)Mockito.mock(HttpServerRequest.class)));
    }

    private static JsonObject buildExpectedJson(String status, String outcome, JsonObject ... checks) {
        JsonObject expected = new JsonObject().put("status", (Object)status).put("outcome", (Object)outcome);
        if (checks != null && checks.length > 0) {
            expected.put("checks", (Object)new JsonArray(Arrays.asList(checks)));
        }
        return expected;
    }

    static Stream<Arguments> getInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{HealthCheckHandlerTest.buildExpectedJson("UP", "UP", new JsonObject().put("id", (Object)"dummy").put("status", (Object)"UP")), 200, "status is up"}), Arguments.of((Object[])new Object[]{HealthCheckHandlerTest.buildExpectedJson("UP", "UP", new JsonObject[0]), 204, "response is empty"}), Arguments.of((Object[])new Object[]{HealthCheckHandlerTest.buildExpectedJson("DOWN", "DOWN", new JsonObject().put("id", (Object)"dummy").put("status", (Object)"DOWN")), 503, "status is down (without any reason)"}), Arguments.of((Object[])new Object[]{HealthCheckHandlerTest.buildExpectedJson("DOWN", "DOWN", new JsonObject[0]).put("data", (Object)new JsonObject().put("procedure-execution-failure", (Object)true)), 500, "status is down (with procedure error, but no checks)"}), Arguments.of((Object[])new Object[]{HealthCheckHandlerTest.buildExpectedJson("DOWN", "DOWN", new JsonObject().put("id", (Object)"dummy").put("status", (Object)"DOWN").put("data", (Object)new JsonObject().put("procedure-execution-failure", (Object)true))), 500, "status is down (with procedure error)"}));
    }

    @ParameterizedTest(name="{index}: {2} => HTTP {1}")
    @MethodSource(value={"getInputs"})
    @DisplayName(value="should handle response, if")
    void testHandle(JsonObject expectedResponse, int expectedStatusCode, String description) {
        Mockito.when((Object)this.registry.collectHealthCheckResults((DataContext)ArgumentMatchers.any(DataContext.class))).thenReturn((Object)Future.succeededFuture((Object)expectedResponse));
        new HealthCheckHandler(this.registry).handle(this.routingContext);
        ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).putHeader((CharSequence)ArgumentMatchers.eq((Object)HttpHeaders.CONTENT_TYPE), (CharSequence)ArgumentMatchers.eq((Object)"application/json;charset=UTF-8"));
        ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).setStatusCode(ArgumentMatchers.eq((int)expectedStatusCode));
        if (expectedStatusCode == 204) {
            ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).end();
        } else {
            ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).end(ArgumentMatchers.anyString());
        }
    }

    @Test
    @DisplayName(value="should return internal server error, if retrieving data fails")
    void testHandleFailure() {
        Mockito.when((Object)this.registry.collectHealthCheckResults((DataContext)ArgumentMatchers.any(DataContext.class))).thenReturn((Object)Future.failedFuture((Throwable)new Throwable("oops")));
        new HealthCheckHandler(this.registry).handle(this.routingContext);
        ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).setStatusCode(ArgumentMatchers.eq((int)500));
        ((HttpServerResponse)Mockito.verify((Object)this.httpServerResponse)).setStatusMessage(ArgumentMatchers.matches((String)"Could not request any health data."));
    }
}

