/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4;

import com.google.common.truth.Truth;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.data.DataAdapter;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataQuery;
import io.neonbee.endpoint.odatav4.ODataV4Endpoint;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.internal.helper.CollectionHelper;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.helper.ResourceHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ODataV4EndpointTest
extends ODataEndpointTestBase {
    private static final FullQualifiedName TEST_USERS = new FullQualifiedName("Service", "TestUsers");

    ODataV4EndpointTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService1.csn"), ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn"), ResourceHelper.TEST_RESOURCES.resolveRelated("TestService3.csn"));
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        return super.provideWorkingDirectoryBuilder(testInfo, testContext).setCustomTask(root -> {
            String testMethodName = testInfo.getTestMethod().map(Method::getName).orElse("");
            ODataV4Endpoint.UriConversion uriConversion = ODataV4Endpoint.UriConversion.STRICT;
            if (testMethodName.contains("LooseUriConversion")) {
                uriConversion = ODataV4Endpoint.UriConversion.LOOSE;
            } else if (testMethodName.contains("CDSUriConversion")) {
                uriConversion = ODataV4Endpoint.UriConversion.CDS;
            }
            DeploymentOptions opts = WorkingDirectoryBuilder.readDeploymentOptions(ServerVerticle.class, root);
            EndpointConfig epc = new EndpointConfig().setType(ODataV4Endpoint.class.getName()).setAdditionalConfig(new JsonObject().put("uriConversion", (Object)uriConversion.toString()));
            ServerConfig sc = new ServerConfig(opts.getConfig()).setEndpointConfigs(List.of(epc));
            opts.setConfig(sc.toJson());
            WorkingDirectoryBuilder.writeDeploymentOptions(ServerVerticle.class, opts, root);
        });
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if (lazy) loading OData models on first request to ODataEndpoint works")
    void testODataEndpointLazyLoading(VertxTestContext testContext) {
        this.assertOData(this.requestMetadata("io.neonbee.handler.TestService"), (Buffer body) -> Truth.assertThat((String)body.toString()).contains((CharSequence)"<edmx:Edmx"), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    void testUriConversionRules() {
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.STRICT.apply("any-string")).isEqualTo((Object)"any-string");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.STRICT.apply("anyOtherString")).isEqualTo((Object)"anyOtherString");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.STRICT.apply("any_non UsUalST1NG")).isEqualTo((Object)"any_non UsUalST1NG");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.STRICT.apply("")).isEqualTo((Object)"");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("any.namespace.HAS.2.be.ReMo_VeD.Test")).isEqualTo((Object)"test");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("remove_any_tailing_'Service'_string.TestService")).isEqualTo((Object)"test");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("lowerCaseForTheFirstLetterOfTheService.FooBarService")).isEqualTo((Object)"foo-bar");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("concatenateWordsWith-.FOOBarBAZService")).isEqualTo((Object)"foobarbaz");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("everythingGoesLowerCase.FOO-BAR-BAZ")).isEqualTo((Object)"foo-bar-baz");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("replaceAny_With-.FOO_BAR")).isEqualTo((Object)"foo-bar");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("Service")).isEqualTo((Object)"");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.CDS.apply("any.namespace.Service")).isEqualTo((Object)"");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.LOOSE.apply("my.very.CatalogService")).isEqualTo((Object)"my-very-catalog");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.LOOSE.apply("io.neonbee.test.TestService1")).isEqualTo((Object)"io-neonbee-test-test-service1");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.LOOSE.apply("Frontend.Service")).isEqualTo((Object)"frontend");
        Truth.assertThat((String)ODataV4Endpoint.UriConversion.LOOSE.apply("Service")).isEqualTo((Object)"");
    }

    private Future<HttpResponse<Buffer>> requestMetadata(String namespace) {
        FullQualifiedName fqn = new FullQualifiedName(namespace, "WillBeIgnored");
        return this.requestOData(new ODataRequest(fqn).setMetadata());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if multiple service endpoints are created with strict URI mapping")
    void testStrictUriConversion(VertxTestContext testContext) {
        CompositeFuture.all(this.assertOData(this.requestMetadata("io.neonbee.handler.TestService"), ODataV4EndpointTest::assertTS1Handler, testContext), this.assertOData(this.requestMetadata("io.neonbee.handler2.Test2Service"), ODataV4EndpointTest::assertTS2Handler, testContext), this.assertOData(this.requestMetadata("Service"), ODataV4EndpointTest::assertTS3Handler, testContext)).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if loose URI mapping works")
    void testLooseUriConversion(VertxTestContext testContext) {
        CompositeFuture.all(this.assertOData(this.requestMetadata("io-neonbee-handler-test"), ODataV4EndpointTest::assertTS1Handler, testContext), this.assertOData(this.requestMetadata("io-neonbee-handler2-test2"), ODataV4EndpointTest::assertTS2Handler, testContext), this.assertOData(this.requestMetadata(""), ODataV4EndpointTest::assertTS3Handler, testContext)).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if CDS URI mapping works")
    void testCDSUriConversion(VertxTestContext testContext) {
        CompositeFuture.all(this.assertOData(this.requestMetadata("test"), ODataV4EndpointTest::assertTS1Handler, testContext), this.assertOData(this.requestMetadata("test2"), ODataV4EndpointTest::assertTS2Handler, testContext), this.assertOData(this.requestMetadata(""), ODataV4EndpointTest::assertTS3Handler, testContext)).onComplete(testContext.succeedingThenComplete());
    }

    static Stream<Arguments> customStatusCodes() {
        return Stream.of(Arguments.of((Object[])new Object[]{400}), Arguments.of((Object[])new Object[]{403}), Arguments.of((Object[])new Object[]{404}), Arguments.of((Object[])new Object[]{HttpResponseStatus.INTERNAL_SERVER_ERROR.code()}));
    }

    @ParameterizedTest(name="{index}: with status code {0}")
    @MethodSource(value={"customStatusCodes"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="ODataEndpointHandler must forward custom status codes from DataExceptions to the client")
    void testHTTPExceptions(final int statusCode, VertxTestContext testContext) {
        EntityVerticle dummyVerticle = this.createDummyEntityVerticle(TEST_USERS).withDataAdapter(new DataAdapter<EntityWrapper>(){

            public Future<EntityWrapper> retrieveData(DataQuery query, DataContext context) {
                return Future.failedFuture((Throwable)new DataException(statusCode));
            }
        });
        this.deployVerticle((Verticle)dummyVerticle).compose(v -> new ODataRequest(TEST_USERS).send(this.getNeonBee())).onComplete(testContext.succeeding(resp -> {
            testContext.verify(() -> Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)statusCode));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Query parameters should be decoded before being forwarded to an EntityVerticle")
    void testURLQueryDecoding(VertxTestContext testContext) {
        MultiMap query = MultiMap.caseInsensitiveMultiMap().add("$filter", "description eq ''");
        EntityVerticle dummy = this.createDummyEntityVerticle(TEST_USERS).withDynamicResponse((dataQuery, dataContext) -> {
            testContext.verify(() -> Truth.assertThat((Map)dataQuery.getParameters()).isEqualTo((Object)CollectionHelper.multiMapToMap((MultiMap)query)));
            testContext.completeNow();
            return new EntityWrapper(TEST_USERS, (Entity)null);
        });
        this.deployVerticle((Verticle)dummy).compose(v -> this.requestOData(new ODataRequest(TEST_USERS).setQuery(query))).onComplete(testContext.succeeding(v -> {}));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Uri path on Entity request must start with a leading slash")
    void testURIPathExtraction(VertxTestContext testContext) {
        EntityVerticle dummy = this.createDummyEntityVerticle(TEST_USERS).withDynamicResponse((dataQuery, dataContext) -> {
            testContext.verify(() -> Truth.assertThat((String)dataQuery.getUriPath()).isEqualTo((Object)"/Service/TestUsers"));
            testContext.completeNow();
            return new EntityWrapper(TEST_USERS, (Entity)null);
        });
        this.deployVerticle((Verticle)dummy).compose(v -> this.requestOData(new ODataRequest(TEST_USERS))).onComplete(testContext.succeeding(v -> {}));
    }

    private static void assertTS1Handler(Buffer body) {
        Truth.assertThat((String)body.toString()).contains((CharSequence)"Namespace=\"io.neonbee.handler.TestService\"");
    }

    private static void assertTS2Handler(Buffer body) {
        Truth.assertThat((String)body.toString()).contains((CharSequence)"Namespace=\"io.neonbee.handler2.Test2Service\"");
    }

    private static void assertTS3Handler(Buffer body) {
        Truth.assertThat((String)body.toString()).contains((CharSequence)"Namespace=\"Service\"");
    }
}

