/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.edm;

import com.google.common.truth.Truth;
import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmHelper;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.server.api.ODataApplicationException;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class EdmHelperTest {
    EdmHelperTest() {
    }

    @Test
    @DisplayName(value="Test getEdmPrimitiveTypeKindByPropertyType method")
    void getEdmPrimitiveTypeKindByPropertyTypeTest() throws ODataApplicationException {
        Truth.assertThat((Comparable)EdmHelper.getEdmPrimitiveTypeKindByPropertyType((String)"String")).isEqualTo((Object)EdmPrimitiveTypeKind.String);
        Truth.assertThat((Comparable)EdmHelper.getEdmPrimitiveTypeKindByPropertyType((String)"Boolean")).isEqualTo((Object)EdmPrimitiveTypeKind.Boolean);
        Truth.assertThat((Comparable)EdmHelper.getEdmPrimitiveTypeKindByPropertyType((String)"Int32")).isEqualTo((Object)EdmPrimitiveTypeKind.Int32);
        Truth.assertThat((Comparable)EdmHelper.getEdmPrimitiveTypeKindByPropertyType((String)"Int64")).isEqualTo((Object)EdmPrimitiveTypeKind.Int64);
    }

    @Test
    @DisplayName(value="Test extractValueFromLiteral method")
    void extractValueFromLiteralTest() {
        Truth.assertThat((String)EdmHelper.extractValueFromLiteral((String)"'ID5'")).isEqualTo((Object)"ID5");
        Truth.assertThat((String)EdmHelper.extractValueFromLiteral((String)"'10815'")).isEqualTo((Object)"10815");
        Truth.assertThat((String)EdmHelper.extractValueFromLiteral((String)"323")).isEqualTo((Object)"323");
        Truth.assertThat((String)EdmHelper.extractValueFromLiteral((String)"INVALID_ID_0815$")).isEqualTo((Object)"INVALID_ID_0815$");
    }

    @Test
    @DisplayName(value="Test isLocalDate")
    void isLocalDateTest() {
        Truth.assertThat((Boolean)EdmHelper.isLocalDate((String)"2010-01-01")).isTrue();
        Truth.assertThat((Boolean)EdmHelper.isLocalDate((String)"2010-12-31")).isTrue();
        Truth.assertThat((Boolean)EdmHelper.isLocalDate((String)"2010-2-31")).isFalse();
    }

    @Test
    @DisplayName(value="Test isLocalDateTime")
    void isLocalDateTimeTest() {
        Truth.assertThat((Boolean)EdmHelper.isLocalDateTime((String)"2010-01-01T05:32:09")).isTrue();
        Truth.assertThat((Boolean)EdmHelper.isLocalDateTime((String)"2010-01-01T05:32:09Z")).isFalse();
        Truth.assertThat((Boolean)EdmHelper.isLocalDateTime((String)"2010-2-31")).isFalse();
    }

    @Test
    @DisplayName(value="Test convert string to edm property")
    void convertStringValueToEdmStringProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("account", EdmPrimitiveTypeKind.String);
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"SAP-Account", (EdmProperty)edmProperty);
        Truth.assertThat((Object)property.getValue()).isEqualTo((Object)"SAP-Account");
    }

    @Test
    @DisplayName(value="Test convert string to edm int property")
    void convertStringValueToEdmInt32Property() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("age", EdmPrimitiveTypeKind.Int32);
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"12", (EdmProperty)edmProperty);
        Truth.assertThat((Object)property.getValue()).isEqualTo((Object)12);
    }

    @Test
    @DisplayName(value="Test convert string to edm boolean property")
    void convertStringValueToEdmBooleanProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("male", EdmPrimitiveTypeKind.Boolean);
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"true", (EdmProperty)edmProperty);
        Truth.assertThat((Object)property.getValue()).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    @DisplayName(value="Test convert string to edm double property")
    void convertStringValueToEdmDoubleProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("salary", EdmPrimitiveTypeKind.Double);
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"12.58", (EdmProperty)edmProperty);
        Truth.assertThat((Object)property.getValue()).isEqualTo((Object)12.58);
    }

    @Test
    @DisplayName(value="Test convert string to edm decimal property")
    void convertStringValueToEdmDecimalProperty() throws EdmPrimitiveTypeException {
        CsdlProperty csdlProperty = new CsdlProperty();
        csdlProperty.setName("salary");
        csdlProperty.setType(EdmPrimitiveTypeKind.Decimal.getFullQualifiedName());
        csdlProperty.setScale(Integer.valueOf(2));
        csdlProperty.setPrecision(Integer.valueOf(9));
        EdmPropertyImpl edmProperty = new EdmPropertyImpl(null, csdlProperty);
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"12.58", (EdmProperty)edmProperty);
        Truth.assertThat((Double)((BigDecimal)property.getValue()).doubleValue()).isEqualTo((Object)12.58);
    }

    @Test
    @DisplayName(value="Test convert string to edm date property")
    void convertStringValueToEdmDateProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("birthdate", EdmPrimitiveTypeKind.Date);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        LocalDate localDate = LocalDate.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"1970-01-01", (EdmProperty)edmProperty);
        Calendar value = (Calendar)property.getValue();
        LocalDate localDateValue = LocalDate.ofInstant(value.toInstant(), value.getTimeZone().toZoneId());
        Truth.assertThat((Comparable)localDateValue).isEqualTo((Object)localDate);
    }

    @Test
    @DisplayName(value="Test convert string to edm time property")
    void convertStringValueToEdmTimeOfDayProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("birthtime", EdmPrimitiveTypeKind.TimeOfDay);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalTime localTime = LocalTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"12:00:00", (EdmProperty)edmProperty);
        Calendar value = (Calendar)property.getValue();
        LocalTime localTimeValue = LocalTime.ofInstant(value.toInstant(), value.getTimeZone().toZoneId());
        Truth.assertThat((Comparable)localTimeValue).isEqualTo((Object)localTime);
    }

    @Test
    @DisplayName(value="Test convert string to edm date time property")
    void convertStringValueToEdmDateTimeOffsetProperty() throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.buildProperty("birthtime", EdmPrimitiveTypeKind.DateTimeOffset);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Timestamp localDateTime = new Timestamp(cal.toInstant().toEpochMilli());
        Property property = EdmHelper.convertStringValueToEdmProperty((String)"1970-01-01T12:00:00+01:00[Europe/Berlin]", (EdmProperty)edmProperty);
        Timestamp localDateTimeValue = (Timestamp)property.getValue();
        Truth.assertThat((Comparable)localDateTimeValue).isEqualTo((Object)localDateTime);
    }

    private EdmProperty buildProperty(String name, EdmPrimitiveTypeKind type) {
        CsdlProperty csdlProperty = new CsdlProperty();
        csdlProperty.setName(name);
        csdlProperty.setType(type.getFullQualifiedName());
        return new EdmPropertyImpl(null, csdlProperty);
    }
}

