/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression;

import com.google.common.truth.Truth;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.OrderExpressionExecutor;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.core.uri.queryoption.OrderByItemImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MemberImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class OrderExpressionExecutorTest {
    private final RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);

    OrderExpressionExecutorTest() {
    }

    @Test
    @DisplayName(value="Ordering by single property (strings must be case-insensitive)")
    void executeOrderOptionSinglePropertyTest() {
        Entity entity1 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"Sales Cloud"));
        Entity entity2 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"SAP Marketing Cloud"));
        Entity entity3 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"SAP Commerce"));
        ArrayList<Entity> entityList = new ArrayList<Entity>(List.of(entity1, entity2, entity3));
        ArrayList<Entity> expectedEntityListAsc = new ArrayList<Entity>(List.of(entity1, entity3, entity2));
        EdmTypeImpl edmType = (EdmTypeImpl)Mockito.mock(EdmTypeImpl.class);
        Mockito.when((Object)edmType.getKind()).thenReturn((Object)EdmTypeKind.PRIMITIVE);
        Mockito.when((Object)edmType.toString()).thenReturn((Object)"Edm.String");
        EdmPropertyImpl edmProperty = (EdmPropertyImpl)Mockito.mock(EdmPropertyImpl.class);
        Mockito.when((Object)edmProperty.getType()).thenReturn((Object)edmType);
        Mockito.when((Object)edmProperty.getName()).thenReturn((Object)"testStringProperty");
        UriResourcePrimitiveProperty uriResourcePrimitiveProperty = (UriResourcePrimitiveProperty)Mockito.mock(UriResourcePrimitiveProperty.class);
        Mockito.when((Object)uriResourcePrimitiveProperty.getProperty()).thenReturn((Object)edmProperty);
        UriInfoResource resourcePath = (UriInfoResource)Mockito.mock(UriInfoResource.class);
        Mockito.when((Object)resourcePath.getUriResourceParts()).thenReturn(List.of(uriResourcePrimitiveProperty));
        MemberImpl member = (MemberImpl)Mockito.mock(MemberImpl.class);
        Mockito.when((Object)member.getResourcePath()).thenReturn((Object)resourcePath);
        OrderByItemImpl orderByItem = (OrderByItemImpl)Mockito.mock(OrderByItemImpl.class);
        Mockito.when((Object)orderByItem.getExpression()).thenReturn((Object)member);
        OrderByOptionImpl orderByOption = (OrderByOptionImpl)Mockito.mock(OrderByOptionImpl.class);
        Mockito.when((Object)orderByOption.getOrders()).thenReturn(List.of(orderByItem));
        Truth.assertThat((Iterable)OrderExpressionExecutor.executeOrderOption((RoutingContext)this.routingContext, (OrderByOption)orderByOption, entityList)).containsExactlyElementsIn(expectedEntityListAsc).inOrder();
        ArrayList<Entity> expectedEntityListDesc = new ArrayList<Entity>(List.of(entity2, entity3, entity1));
        Mockito.when((Object)orderByItem.isDescending()).thenReturn((Object)true);
        Truth.assertThat((Iterable)OrderExpressionExecutor.executeOrderOption((RoutingContext)this.routingContext, (OrderByOption)orderByOption, entityList)).containsExactlyElementsIn(expectedEntityListDesc).inOrder();
    }

    @Test
    @DisplayName(value="Ordering by multiple properties (strings must be case-insensitive)")
    void executeOrderOptionMultiplePropertiesTest() {
        Entity entity1 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"a")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)1));
        Entity entity2 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"c")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)2));
        Entity entity3 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"B")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)3));
        Entity entity4 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"c")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)1));
        ArrayList<Entity> entityList = new ArrayList<Entity>(List.of(entity1, entity2, entity3, entity4));
        ArrayList<Entity> expectedEntityListAsc = new ArrayList<Entity>(List.of(entity1, entity3, entity4, entity2));
        EdmTypeImpl edmType1 = (EdmTypeImpl)Mockito.mock(EdmTypeImpl.class);
        Mockito.when((Object)edmType1.getKind()).thenReturn((Object)EdmTypeKind.PRIMITIVE);
        Mockito.when((Object)edmType1.toString()).thenReturn((Object)EdmPrimitiveTypeKind.String.toString());
        EdmTypeImpl edmType2 = (EdmTypeImpl)Mockito.mock(EdmTypeImpl.class);
        Mockito.when((Object)edmType2.getKind()).thenReturn((Object)EdmTypeKind.PRIMITIVE);
        Mockito.when((Object)edmType2.toString()).thenReturn((Object)EdmPrimitiveTypeKind.Int32.toString());
        EdmPropertyImpl edmProperty1 = (EdmPropertyImpl)Mockito.mock(EdmPropertyImpl.class);
        Mockito.when((Object)edmProperty1.getType()).thenReturn((Object)edmType1);
        Mockito.when((Object)edmProperty1.getName()).thenReturn((Object)"testStringProperty");
        EdmPropertyImpl edmProperty2 = (EdmPropertyImpl)Mockito.mock(EdmPropertyImpl.class);
        Mockito.when((Object)edmProperty2.getType()).thenReturn((Object)edmType2);
        Mockito.when((Object)edmProperty2.getName()).thenReturn((Object)"testNumberProperty");
        UriResourcePrimitiveProperty uriResourcePrimitiveProperty1 = (UriResourcePrimitiveProperty)Mockito.mock(UriResourcePrimitiveProperty.class);
        Mockito.when((Object)uriResourcePrimitiveProperty1.getProperty()).thenReturn((Object)edmProperty1);
        UriResourcePrimitiveProperty uriResourcePrimitiveProperty2 = (UriResourcePrimitiveProperty)Mockito.mock(UriResourcePrimitiveProperty.class);
        Mockito.when((Object)uriResourcePrimitiveProperty2.getProperty()).thenReturn((Object)edmProperty2);
        UriInfoResource resourcePath1 = (UriInfoResource)Mockito.mock(UriInfoResource.class);
        Mockito.when((Object)resourcePath1.getUriResourceParts()).thenReturn(List.of(uriResourcePrimitiveProperty1));
        UriInfoResource resourcePath2 = (UriInfoResource)Mockito.mock(UriInfoResource.class);
        Mockito.when((Object)resourcePath2.getUriResourceParts()).thenReturn(List.of(uriResourcePrimitiveProperty2));
        MemberImpl member1 = (MemberImpl)Mockito.mock(MemberImpl.class);
        Mockito.when((Object)member1.getResourcePath()).thenReturn((Object)resourcePath1);
        MemberImpl member2 = (MemberImpl)Mockito.mock(MemberImpl.class);
        Mockito.when((Object)member2.getResourcePath()).thenReturn((Object)resourcePath2);
        OrderByItemImpl orderByItem1 = (OrderByItemImpl)Mockito.mock(OrderByItemImpl.class);
        Mockito.when((Object)orderByItem1.getExpression()).thenReturn((Object)member1);
        OrderByItemImpl orderByItem2 = (OrderByItemImpl)Mockito.mock(OrderByItemImpl.class);
        Mockito.when((Object)orderByItem2.getExpression()).thenReturn((Object)member2);
        OrderByOptionImpl orderByOption = (OrderByOptionImpl)Mockito.mock(OrderByOptionImpl.class);
        Mockito.when((Object)orderByOption.getOrders()).thenReturn(List.of(orderByItem1, orderByItem2));
        Truth.assertThat((Iterable)OrderExpressionExecutor.executeOrderOption((RoutingContext)this.routingContext, (OrderByOption)orderByOption, entityList)).containsExactlyElementsIn(expectedEntityListAsc).inOrder();
        ArrayList<Entity> expectedEntityListDesc = new ArrayList<Entity>(List.of(entity2, entity4, entity3, entity1));
        Mockito.when((Object)orderByItem1.isDescending()).thenReturn((Object)true);
        Mockito.when((Object)orderByItem2.isDescending()).thenReturn((Object)true);
        Truth.assertThat((Iterable)OrderExpressionExecutor.executeOrderOption((RoutingContext)this.routingContext, (OrderByOption)orderByOption, entityList)).containsExactlyElementsIn(expectedEntityListDesc).inOrder();
    }

    @Test
    @DisplayName(value="Ordering has to do nothing with the entity list in case of an invalid OrderByOption")
    void executeOrderOptionInvalidOrderByOptionTest() {
        Entity entity1 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"Sales Cloud"));
        Entity entity2 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"SAP Marketing Cloud"));
        Entity entity3 = new Entity().addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"SAP Commerce"));
        ArrayList<Entity> entityList = new ArrayList<Entity>(List.of(entity1, entity2, entity3));
        ArrayList<Entity> expectedEntityListAsc = new ArrayList<Entity>(List.of(entity1, entity2, entity3));
        EdmTypeImpl edmType = (EdmTypeImpl)Mockito.mock(EdmTypeImpl.class);
        Mockito.when((Object)edmType.getKind()).thenReturn((Object)EdmTypeKind.PRIMITIVE);
        Mockito.when((Object)edmType.toString()).thenReturn((Object)"Edm.String");
        EdmPropertyImpl edmProperty = (EdmPropertyImpl)Mockito.mock(EdmPropertyImpl.class);
        Mockito.when((Object)edmProperty.getType()).thenReturn((Object)edmType);
        Mockito.when((Object)edmProperty.getName()).thenReturn((Object)"testStringProperty");
        UriResourcePrimitiveProperty uriResourcePrimitiveProperty = (UriResourcePrimitiveProperty)Mockito.mock(UriResourcePrimitiveProperty.class);
        Mockito.when((Object)uriResourcePrimitiveProperty.getProperty()).thenReturn((Object)edmProperty);
        UriInfoResource resourcePath = (UriInfoResource)Mockito.mock(UriInfoResource.class);
        Mockito.when((Object)resourcePath.getUriResourceParts()).thenReturn(List.of(uriResourcePrimitiveProperty));
        TestExpression member = (TestExpression)Mockito.mock(TestExpression.class);
        OrderByItemImpl orderByItem = (OrderByItemImpl)Mockito.mock(OrderByItemImpl.class);
        Mockito.when((Object)orderByItem.getExpression()).thenReturn((Object)member);
        OrderByOptionImpl orderByOption = (OrderByOptionImpl)Mockito.mock(OrderByOptionImpl.class);
        Mockito.when((Object)orderByOption.getOrders()).thenReturn(List.of(orderByItem));
        Truth.assertThat((Iterable)OrderExpressionExecutor.executeOrderOption((RoutingContext)this.routingContext, (OrderByOption)orderByOption, entityList)).containsExactlyElementsIn(expectedEntityListAsc).inOrder();
    }

    @Test
    @DisplayName(value="OrderExpressionExecutor must also work with null values")
    void orderByShouldHandleNullValuesTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        Date date1 = dateFormat.parse("1970-10-10");
        long long1 = date1.getTime();
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1.getTime());
        Entity entity1 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity1")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("A7CF6C58-31FF-4B12-9670-F4FD80B2E82D"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"a-string")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)111)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date1)).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long1))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)new BigInteger("-1"))).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long1))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar1)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)Boolean.TRUE)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.MAX_VALUE)).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)Float.valueOf(Float.MAX_VALUE))).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)Double.MIN_VALUE)).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".getBytes(StandardCharsets.UTF_8)));
        Date date2 = dateFormat.parse("2010-12-01");
        long long2 = date2.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2.getTime());
        Entity entity2 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity2")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("96FF1CC8-A538-4362-B050-D5DC7A17169C"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)222)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date2.getTime())).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long2))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)long2)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long2))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar2)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)Boolean.TRUE)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.valueOf("1000"))).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)new BigDecimal(1000))).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)BigDecimal.valueOf(1.5))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)"File Content 2".getBytes(StandardCharsets.UTF_8)));
        Date date3 = dateFormat.parse("2000-02-10");
        long long3 = date3.getTime();
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTimeInMillis(date3.getTime());
        Entity entity3 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity3")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("7A299F35-B667-4C6B-8280-A9AFCEF83BB7"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"c-string")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)calendar3.getTimeInMillis())).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long3))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)long3)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long3))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar3)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)Boolean.TRUE)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.valueOf("250"))).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)0.0)).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)Float.valueOf("10.512233"))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, null));
        Date date4 = dateFormat.parse("2019-06-21");
        long long4 = date4.getTime();
        Calendar calendar4 = Calendar.getInstance();
        calendar4.setTimeInMillis(date4.getTime());
        Entity entity4 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity4")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("5ad5e2d8-6b53-4382-8b8a-11899a0daf5d"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"d-string")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)444)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date4)).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long4))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)long4)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long4))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar4)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)false)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.valueOf("0"))).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)BigDecimal.ZERO)).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, (Object)10)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)Integer.parseInt("5000"))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)"Content 0".getBytes(StandardCharsets.UTF_8)));
        Entity entity5 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity5")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("3495ca30-14c2-44c9-8ab7-2635821411fa"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"e-string")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)BigInteger.valueOf(555L))).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, (Object)102)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)BigInteger.valueOf(Long.MAX_VALUE))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)"Content 0".getBytes(StandardCharsets.UTF_8)));
        Date date6 = dateFormat.parse("2011-06-21");
        long long6 = date6.getTime();
        Calendar calendar6 = Calendar.getInstance();
        calendar6.setTimeInMillis(date6.getTime());
        byte[] byteArray = "Another File Content 3".getBytes(StandardCharsets.UTF_8);
        Byte[] byteArrayToBeTested = new Byte[byteArray.length];
        Arrays.setAll(byteArrayToBeTested, i -> byteArray[i]);
        Entity entity6 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity6")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("310a3468-3ca6-4da2-a85a-5e78dac2e951"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"f-string")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)666)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date6)).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long6))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)long6)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long6))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar6)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)Boolean.FALSE)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.valueOf("-1"))).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)Float.valueOf(-1.0f))).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, (Object)-1)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)BigInteger.valueOf(Integer.MAX_VALUE))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)byteArrayToBeTested));
        ArrayList<Entity> entityList = new ArrayList<Entity>(List.of(entity1, entity2, entity3, entity4, entity5, entity6));
        List<Entity> expectedEntityList1 = List.of(entity1, entity3, entity4, entity5, entity6, entity2);
        EntityComparator entityComperatorString = new EntityComparator(this.routingContext, "testStringProperty", false, EdmPrimitiveTypeKind.String);
        Collections.sort(entityList, entityComperatorString);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList1);
        ArrayList<Entity> expectedEntityList2 = new ArrayList<Entity>(List.of(entity3, entity6, entity5, entity4, entity2, entity1));
        EntityComparator entityComperatorInt = new EntityComparator(this.routingContext, "testNumberProperty", true, EdmPrimitiveTypeKind.Int32);
        Collections.sort(entityList, entityComperatorInt);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList2);
        ArrayList<Entity> expectedEntityList3 = new ArrayList<Entity>(List.of(entity5, entity4, entity6, entity2, entity3, entity1));
        EntityComparator entityComperatorDate = new EntityComparator(this.routingContext, "testDateProperty", true, EdmPrimitiveTypeKind.Date);
        Collections.sort(entityList, entityComperatorDate);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList3);
        ArrayList<Entity> expectedEntityList4 = new ArrayList<Entity>(List.of(entity5, entity4, entity6, entity2, entity3, entity1));
        EntityComparator entityComperatorTime = new EntityComparator(this.routingContext, "testTimeProperty", true, EdmPrimitiveTypeKind.Date);
        Collections.sort(entityList, entityComperatorTime);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList4);
        ArrayList<Entity> expectedEntityList5 = new ArrayList<Entity>(List.of(entity5, entity4, entity6, entity2, entity3, entity1));
        EntityComparator entityComperatorLong = new EntityComparator(this.routingContext, "testLongProperty", true, EdmPrimitiveTypeKind.Int64);
        Collections.sort(entityList, entityComperatorLong);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList5);
        ArrayList<Entity> expectedEntityList6 = new ArrayList<Entity>(List.of(entity5, entity4, entity6, entity2, entity3, entity1));
        EntityComparator entityComperatorTimestamp = new EntityComparator(this.routingContext, "testTimestampProperty", true, EdmPrimitiveTypeKind.Date);
        Collections.sort(entityList, entityComperatorTimestamp);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList6);
        ArrayList<Entity> expectedEntityList7 = new ArrayList<Entity>(List.of(entity5, entity4, entity6, entity2, entity3, entity1));
        EntityComparator entityComperatorCalendar = new EntityComparator(this.routingContext, "testCalendarProperty", true, EdmPrimitiveTypeKind.Date);
        Collections.sort(entityList, entityComperatorCalendar);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList7);
        ArrayList<Entity> expectedEntityList8 = new ArrayList<Entity>(List.of(entity5, entity2, entity3, entity1, entity4, entity6));
        EntityComparator entityComperatorBoolean = new EntityComparator(this.routingContext, "testBooleanProperty", true, EdmPrimitiveTypeKind.Boolean);
        Collections.sort(entityList, entityComperatorBoolean);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList8);
        ArrayList<Entity> expectedEntityList9 = new ArrayList<Entity>(List.of(entity5, entity1, entity2, entity3, entity4, entity6));
        EntityComparator entityComperatorShort = new EntityComparator(this.routingContext, "testShortProperty", true, EdmPrimitiveTypeKind.Int16);
        Collections.sort(entityList, entityComperatorShort);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList9);
        ArrayList<Entity> expectedEntityList10 = new ArrayList<Entity>(List.of(entity5, entity1, entity2, entity3, entity4, entity6));
        EntityComparator entityComperatorDouble = new EntityComparator(this.routingContext, "testDoubleProperty", true, EdmPrimitiveTypeKind.Double);
        Collections.sort(entityList, entityComperatorDouble);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList10);
        ArrayList<Entity> expectedEntityList11 = new ArrayList<Entity>(List.of(entity3, entity4, entity5, entity6, entity1, entity2));
        EntityComparator entityComperatorGuid = new EntityComparator(this.routingContext, "testGuidProperty", true, EdmPrimitiveTypeKind.Guid);
        Collections.sort(entityList, entityComperatorGuid);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList11);
        ArrayList<Entity> expectedEntityList12 = new ArrayList<Entity>(List.of(entity4, entity5, entity2, entity6, entity1, entity3));
        EntityComparator entityComperatorBinary = new EntityComparator(this.routingContext, "testBinaryProperty", false, EdmPrimitiveTypeKind.Binary);
        Collections.sort(entityList, entityComperatorBinary);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList12);
        ArrayList<Entity> expectedEntityList13 = new ArrayList<Entity>(List.of(entity6, entity4, entity5, entity2, entity1, entity3));
        EntityComparator entityComperatorByte = new EntityComparator(this.routingContext, "testByteProperty", false, EdmPrimitiveTypeKind.Byte);
        Collections.sort(entityList, entityComperatorByte);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList13);
        ArrayList<Entity> expectedEntityList14 = new ArrayList<Entity>(List.of(entity1, entity2, entity3, entity4, entity6, entity5));
        EntityComparator entityComperatorDecimal = new EntityComparator(this.routingContext, "testDecimalProperty", false, EdmPrimitiveTypeKind.Decimal);
        Collections.sort(entityList, entityComperatorDecimal);
        Truth.assertThat(entityList).isEqualTo(expectedEntityList14);
    }

    @Test
    @DisplayName(value="OrderExpressionExecutor should throw meaningful errors")
    void orderByShouldThrowMeaningfulErrorTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        Date date1 = dateFormat.parse("1970-10-10");
        long long1 = date1.getTime();
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1.getTime());
        Entity entity1 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity1")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("A7CF6C58-31FF-4B12-9670-F4FD80B2E82D").toString())).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)1337)).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, (Object)111)).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date1)).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long1))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)new BigInteger("-1"))).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long1))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar1)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)1)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.MAX_VALUE)).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)Float.valueOf(Float.MAX_VALUE))).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)0.0)).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".getBytes(StandardCharsets.UTF_8)));
        Date date2 = dateFormat.parse("2010-12-01");
        long long2 = date2.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2.getTime());
        Entity entity2 = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"entity2")).addProperty(new Property(null, "testGuidProperty", ValueType.PRIMITIVE, (Object)UUID.fromString("96FF1CC8-A538-4362-B050-D5DC7A17169C"))).addProperty(new Property(null, "testStringProperty", ValueType.PRIMITIVE, (Object)"Not null")).addProperty(new Property(null, "testNumberProperty", ValueType.PRIMITIVE, new ArrayList())).addProperty(new Property(null, "testDateProperty", ValueType.PRIMITIVE, (Object)date2.toInstant().getNano())).addProperty(new Property(null, "testTimeProperty", ValueType.PRIMITIVE, (Object)new Time(long2))).addProperty(new Property(null, "testLongProperty", ValueType.PRIMITIVE, (Object)long2)).addProperty(new Property(null, "testTimestampProperty", ValueType.PRIMITIVE, (Object)new Timestamp(long2))).addProperty(new Property(null, "testCalendarProperty", ValueType.PRIMITIVE, (Object)calendar2)).addProperty(new Property(null, "testBooleanProperty", ValueType.PRIMITIVE, (Object)Boolean.TRUE)).addProperty(new Property(null, "testShortProperty", ValueType.PRIMITIVE, (Object)Short.valueOf("1000"))).addProperty(new Property(null, "testDoubleProperty", ValueType.PRIMITIVE, (Object)false)).addProperty(new Property(null, "testByteProperty", ValueType.PRIMITIVE, null)).addProperty(new Property(null, "testDecimalProperty", ValueType.PRIMITIVE, (Object)"1.5f".getBytes(StandardCharsets.UTF_8))).addProperty(new Property(null, "testBinaryProperty", ValueType.PRIMITIVE, (Object)-15));
        ArrayList<Entity> entityList = new ArrayList<Entity>(List.of(entity1, entity2));
        EntityComparator entityComperatorBinary = new EntityComparator(this.routingContext, "testBinaryProperty", true, EdmPrimitiveTypeKind.Binary);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorBinary))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testBinaryProperty. The types of the compared values are Integer and byte[] but both must be one of: byte[], Byte[]");
        EntityComparator entityComperatorNumber = new EntityComparator(this.routingContext, "testNumberProperty", true, EdmPrimitiveTypeKind.Int64);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorNumber))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testNumberProperty. The types of the compared values are ArrayList and Integer but both must be one of: Short, Byte, Integer, Long, BigInteger");
        EntityComparator entityComperatorDecimal = new EntityComparator(this.routingContext, "testDecimalProperty", true, EdmPrimitiveTypeKind.Decimal);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorDecimal))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testDecimalProperty. The types of the compared values are byte[] and Double but both must be one of: Short, Byte, Integer, Long, BigInteger, BigDecimal, Double, Float");
        EntityComparator entityComperatorDouble = new EntityComparator(this.routingContext, "testDoubleProperty", true, EdmPrimitiveTypeKind.Double);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorDouble))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testDoubleProperty. The types of the compared values are Boolean and Float but both must be one of: Short, Byte, Integer, Long, BigDecimal, Double, Float");
        EntityComparator entityComperatorDate = new EntityComparator(this.routingContext, "testDateProperty", true, EdmPrimitiveTypeKind.Date);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorDate))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testDateProperty. The types of the compared values are Integer and Date but both must be one of: Calendar, Date, Timestamp, Time, Long, LocalDate, LocalDateTime, Instant");
        EntityComparator entityComperatorBoolean = new EntityComparator(this.routingContext, "testBooleanProperty", true, EdmPrimitiveTypeKind.Boolean);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorBoolean))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testBooleanProperty. The types of the compared values are Boolean and Integer but both must be one of: Boolean");
        EntityComparator entityComperatorString = new EntityComparator(this.routingContext, "testStringProperty", true, EdmPrimitiveTypeKind.String);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorString))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testStringProperty. The types of the compared values are String and Integer but both must be one of: String");
        EntityComparator entityComperatorGuid = new EntityComparator(this.routingContext, "testGuidProperty", true, EdmPrimitiveTypeKind.Guid);
        Truth.assertThat((String)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Collections.sort(entityList, entityComperatorGuid))).getMessage()).isEqualTo((Object)"org.apache.olingo.server.api.ODataApplicationException: An error has occurred while comparing two values of property testGuidProperty. The types of the compared values are UUID and String but both must be one of: UUID");
    }

    @Test
    void classDefinitionTest() throws Exception {
        Constructor<?>[] constructors = OrderExpressionExecutor.class.getDeclaredConstructors();
        Truth.assertThat((Integer)constructors.length).isEqualTo((Object)1);
        Constructor<?> constructor = constructors[0];
        Truth.assertThat((Boolean)constructor.canAccess(null)).isFalse();
        constructor.setAccessible(true);
        Truth.assertThat(constructor.newInstance(new Object[0]).getClass()).isNotNull();
    }

    public static class TestExpression
    implements Expression {
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }
    }
}

