/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.raw;

import com.google.common.truth.Truth;
import io.neonbee.data.DataAdapter;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.endpoint.raw.RawEndpoint;
import io.neonbee.test.base.DataVerticleTestBase;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class RawEndpointTest
extends DataVerticleTestBase {
    RawEndpointTest() {
    }

    private static RoutingContext mockRoutingContext(String routingPath) {
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        Route routeMock = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)routingContextMock.normalizedPath()).thenReturn((Object)("/raw/" + routingPath));
        Mockito.when((Object)routingContextMock.mountPoint()).thenReturn((Object)"/raw/");
        Mockito.when((Object)routingContextMock.currentRoute()).thenReturn((Object)routeMock);
        Mockito.when((Object)routeMock.getPath()).thenReturn(null);
        return routingContextMock;
    }

    @Test
    @DisplayName(value="check qualified name")
    void checkQualifiedName() {
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("Verticle"))).isEqualTo((Object)"Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("_verticle"))).isEqualTo((Object)"_verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("namespace/Verticle"))).isEqualTo((Object)"namespace/Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("namespace/_Verticle"))).isEqualTo((Object)"namespace/_Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nameSPACE/Verticle"))).isEqualTo((Object)"namespace/Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nsA/nsB/Verticle"))).isEqualTo((Object)"nsa/nsb/Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nsA/nsB/_Verticle"))).isEqualTo((Object)"nsa/nsb/_Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("Verticle/Path/MorePath"))).isEqualTo((Object)"Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nsA/nsB/Verticle/Path"))).isEqualTo((Object)"nsa/nsb/Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nsA/nsB/_Verticle/Path"))).isEqualTo((Object)"nsa/nsb/_Verticle");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("neonbee/TestVerticle-23-42/hodor/hodor"))).isEqualTo((Object)"neonbee/TestVerticle-23-42");
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("/raw/x"))).isNull();
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("verticle"))).isNull();
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nameSPACE/verticle"))).isNull();
        Truth.assertThat((String)RawEndpoint.RawHandler.determineQualifiedName((RoutingContext)RawEndpointTest.mockRoutingContext("nsA/nsB/verticle/path"))).isNull();
    }

    static Stream<Arguments> customStatusCodes() {
        return Stream.of(Arguments.of((Object[])new Object[]{HttpResponseStatus.BAD_REQUEST.code()}), Arguments.of((Object[])new Object[]{HttpResponseStatus.FORBIDDEN.code()}), Arguments.of((Object[])new Object[]{HttpResponseStatus.NOT_FOUND.code()}), Arguments.of((Object[])new Object[]{HttpResponseStatus.INTERNAL_SERVER_ERROR.code()}));
    }

    @ParameterizedTest(name="{index}: with status code {0}")
    @MethodSource(value={"customStatusCodes"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="RawDataEndpointHandler must forward custom status codes from DataExceptions to the client")
    void testHTTPExceptions(final int statusCode, VertxTestContext testContext) {
        String verticleName = "TestVerticle" + UUID.randomUUID().toString();
        DataVerticle<String> dummyVerticle = this.createDummyDataVerticle("neonbee/" + verticleName).withDataAdapter(new DataAdapter<String>(){

            public Future<String> retrieveData(DataQuery query, DataContext context) {
                return Future.failedFuture((Throwable)new DataException(statusCode));
            }
        });
        this.deployVerticle((Verticle)dummyVerticle).compose(v -> this.sendRequest(verticleName, "", "")).onComplete(testContext.succeeding(resp -> {
            testContext.verify(() -> Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)statusCode));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="RawDataEndpoint must prohibit requests to DataVerticles starting with underscore by default")
    void testProhibitRequestsToUnderScoreDVsByDefault(VertxTestContext testContext) {
        String verticleName = "_TestVerticle" + UUID.randomUUID().toString();
        DataVerticle<String> dummy = this.createDummyDataVerticle("neonbee/" + verticleName).withStaticResponse("You have failed");
        this.deployVerticle((Verticle)dummy).compose(s -> this.sendRequest(verticleName, "", "")).onComplete(testContext.succeeding(res -> testContext.verify(() -> {
            Truth.assertThat((Integer)res.statusCode()).isEqualTo((Object)404);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="RawDataEndpointHandler must set uriPath and query correct")
    void testPassQueryToDataQuery(VertxTestContext testContext) {
        String verticleName = "TestVerticle" + UUID.randomUUID().toString();
        String expectedQuery = "Hodor=Hodor&Foo=123";
        String expectedUriPath = "/hodor/hodor";
        DataVerticle<String> dummy = this.createDummyDataVerticle("neonbee/" + verticleName).withDynamicResponse((query, context) -> {
            testContext.verify(() -> {
                Truth.assertThat((String)query.getQuery()).contains((CharSequence)"Hodor=Hodor");
                Truth.assertThat((String)query.getQuery()).contains((CharSequence)"Foo=123");
                Truth.assertThat((String)query.getUriPath()).isEqualTo((Object)expectedUriPath);
            });
            testContext.completeNow();
            return "";
        });
        this.deployVerticle((Verticle)dummy).compose(s -> this.sendRequest(verticleName, expectedUriPath, expectedQuery)).onComplete(testContext.succeedingThenComplete());
    }

    private Future<HttpResponse<Buffer>> sendRequest(String verticleName, String path, String query) {
        String uriPath = String.format("/raw/%s/%s/%s?%s", "neonbee", verticleName, path, query);
        return this.createRequest(HttpMethod.GET, uriPath).send();
    }
}

