/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsServiceBuilder;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.test.helper.ResourceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class EntityModelDefinitionTest {
    EntityModelDefinitionTest() {
    }

    @Test
    void testInstantiation() {
        Assert.assertThrows(NullPointerException.class, () -> new EntityModelDefinition(null, null));
        Assert.assertThrows(NullPointerException.class, () -> new EntityModelDefinition(Map.of(), null));
        Assert.assertThrows(NullPointerException.class, () -> new EntityModelDefinition(null, Map.of()));
        EntityModelDefinition definition = new EntityModelDefinition(Map.of("foo", new byte[]{1, 2, 3}), Map.of("bar", new byte[]{4, 5, 6}));
        Truth.assertThat(definition.getCSNModelDefinitions().keySet()).containsExactly(new Object[]{"foo"});
        Truth.assertThat((byte[])((byte[])definition.getCSNModelDefinitions().get("foo"))).asList().containsExactly(new Object[]{(byte)1, (byte)2, (byte)3});
        Truth.assertThat(definition.getAssociatedModelDefinitions().keySet()).containsExactly(new Object[]{"bar"});
        Truth.assertThat((byte[])((byte[])definition.getAssociatedModelDefinitions().get("bar"))).asList().containsExactly(new Object[]{(byte)4, (byte)5, (byte)6});
        Truth.assertThat((String)definition.toString()).isEqualTo((Object)"foo$bar");
    }

    @Test
    @DisplayName(value="Checks if namespace can be extracted")
    void getNamespace() {
        CdsServiceBuilder serviceBuilder = new CdsServiceBuilder(List.of(), "namespace.Service");
        CdsModelBuilder modelBuilder = CdsModelBuilder.create();
        modelBuilder.addService(serviceBuilder);
        CdsModel cdsModel = modelBuilder.build();
        Truth.assertThat((String)EntityModelDefinition.getNamespace((CdsModel)cdsModel)).isEqualTo((Object)"namespace");
        serviceBuilder = new CdsServiceBuilder(List.of(), "Service");
        modelBuilder = CdsModelBuilder.create();
        modelBuilder.addService(serviceBuilder);
        cdsModel = modelBuilder.build();
        Truth.assertThat((String)EntityModelDefinition.getNamespace((CdsModel)cdsModel)).isEqualTo((Object)"");
    }

    @Test
    @DisplayName(value="Checks if exception will be thrown if no service was found in CDS model")
    void getNamespaceFails() {
        CdsModelBuilder modelBuilder = CdsModelBuilder.create();
        CdsModel cdsModel = modelBuilder.build();
        Assertions.assertThrows(RuntimeException.class, () -> EntityModelDefinition.getNamespace((CdsModel)cdsModel));
    }

    @Test
    @DisplayName(value="Checks namespace is properly extracted from full qualified service name")
    void retrieveNamespace() {
        Truth.assertThat((String)EntityModelDefinition.retrieveNamespace((String)"io.neonbee.test.TestService")).isEqualTo((Object)"io.neonbee.test");
        Truth.assertThat((String)EntityModelDefinition.retrieveNamespace((String)"TestService")).isEqualTo((Object)"");
    }

    @Test
    @DisplayName(value="Checks edmx paths are properly resolved")
    void resolveEdmxPaths() throws IOException {
        List<Path> expectedEdmxFileNames = List.of(Path.of("io.neonbee.test2.TestService2Cars.edmx", new String[0]), Path.of("io.neonbee.test2.TestService2Users.edmx", new String[0]));
        Path csnPath = ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn");
        CdsModel cdsModel = CdsModel.read((InputStream)Files.newInputStream(csnPath, new OpenOption[0]));
        List edmxPaths = EntityModelDefinition.resolveEdmxPaths((Path)csnPath, (CdsModel)cdsModel);
        Stream<Path> edmxFileNames = edmxPaths.stream().map(Path::getFileName);
        Truth8.assertThat(edmxFileNames).containsExactlyElementsIn(expectedEdmxFileNames);
    }
}

