/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import com.sap.cds.reflect.CdsModel;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.entity.EntityModel;
import io.neonbee.entity.EntityModelLoader;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class EntityModelLoaderTest
extends NeonBeeTestBase {
    private static final Path TEST_SERVICE_1_MODEL_PATH = ResourceHelper.TEST_RESOURCES.resolveRelated("TestService1.csn");
    private static final Path TEST_SERVICE_2_MODEL_PATH = ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn");
    private static final Path REFERENCE_SERVICE_MODEL_PATH = ResourceHelper.TEST_RESOURCES.resolveRelated("ReferenceService.csn");

    EntityModelLoaderTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if loading a non-existent model fails")
    void loadNonExistingModelTest(Vertx vertx, VertxTestContext testContext) {
        new EntityModelLoader(vertx).loadModel(Path.of("not.existing.Service.csn", new String[0])).onComplete(testContext.failing(result -> testContext.completeNow()));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if multiple models can be loaded from files")
    void loadEDMXModelsTest(Vertx vertx, VertxTestContext testContext) {
        EntityModelLoader loader = new EntityModelLoader(vertx);
        CompositeFuture.all((Future)loader.loadModel(TEST_SERVICE_1_MODEL_PATH), (Future)loader.loadModel(TEST_SERVICE_2_MODEL_PATH), (Future)loader.loadModel(REFERENCE_SERVICE_MODEL_PATH)).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.test1")).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test1.TestService1");
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.test2")).getEdmxMetadata("io.neonbee.test2.TestService2Cars").getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test2.TestService2Cars");
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.reference")).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.reference.ReferenceService");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if models from file system can be loaded")
    void loadModelsFileSystemTest(Vertx vertx, VertxTestContext testContext) {
        EntityModelLoader loader = new EntityModelLoader(vertx);
        CompositeFuture.all((Future)loader.loadModel(TEST_SERVICE_1_MODEL_PATH), (Future)loader.loadModel(TEST_SERVICE_2_MODEL_PATH), (Future)loader.loadModel(REFERENCE_SERVICE_MODEL_PATH)).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            EntityModel model = (EntityModel)loader.models.get("io.neonbee.test1");
            Truth.assertThat((Map)model.getAllEdmxMetadata()).hasSize(1);
            model = (EntityModel)loader.models.get("io.neonbee.test2");
            Truth.assertThat((Map)model.getAllEdmxMetadata()).hasSize(2);
            model = (EntityModel)loader.models.get("io.neonbee.reference");
            Truth.assertThat((Map)model.getAllEdmxMetadata()).hasSize(1);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=20, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if the models from class path can be loaded ")
    void loadFromClassPathTest(Vertx vertx, VertxTestContext testContext) {
        EntityModelLoader loader = new EntityModelLoader(vertx);
        loader.scanClassPath().onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.test1")).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test1.TestService1");
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.test2")).getEdmxMetadata("io.neonbee.test2.TestService2Cars").getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test2.TestService2Cars");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if the models from module can be loaded ")
    void loadFromModuleTest(Vertx vertx, VertxTestContext testContext) throws IOException {
        Map.Entry<String, byte[]> referenceModel = this.buildModelEntry("ReferenceService.csn");
        Map.Entry<String, byte[]> referenceExtModel = this.buildModelEntry("io.neonbee.reference.ReferenceService.edmx");
        Map extendedModels = Map.ofEntries(referenceExtModel);
        EntityModelLoader loader = new EntityModelLoader(vertx);
        loader.parseModel("models/ReferenceService.csn", referenceModel.getValue(), extendedModels).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((String)((EntityModel)loader.models.get("io.neonbee.reference")).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.reference.ReferenceService");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if getting CSN Model works")
    void getCSNModelTest(Vertx vertx, VertxTestContext testContext) {
        EntityModelLoader loader = new EntityModelLoader(vertx);
        Future csnModelFuture = loader.readCsnModel(TEST_SERVICE_1_MODEL_PATH);
        csnModelFuture.compose(v -> loader.loadModel(TEST_SERVICE_1_MODEL_PATH)).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            CdsModel expectedCsnModel = (CdsModel)csnModelFuture.result();
            EntityModel model = (EntityModel)loader.models.get("io.neonbee.test1");
            Truth.assertThat((Object)model.getCsnModel()).isEqualTo((Object)expectedCsnModel);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="loading models doesn't fail for non-existing working directories")
    void dontFailModelLoadingOnNonExistingWorkingDir(Vertx vertx, VertxTestContext testContext) {
        new EntityModelLoader(vertx).scanDir(Path.of("non-existing", new String[0])).onComplete(testContext.succeeding(models -> {
            Truth.assertThat((Object)models).isNull();
            testContext.completeNow();
        }));
    }

    private Map.Entry<String, byte[]> buildModelEntry(String modelName) throws IOException {
        return Map.entry("models/" + modelName, ResourceHelper.TEST_RESOURCES.getRelated(modelName).getBytes());
    }
}

