/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import com.sap.cds.reflect.CdsModel;
import io.neonbee.entity.EntityModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.server.api.ServiceMetadata;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EntityModelTest {
    EntityModelTest() {
    }

    @Test
    void testStaticInstantiation() {
        CdsModel csnModelMock = (CdsModel)Mockito.mock(CdsModel.class);
        ServiceMetadata edmxMetadataMock = (ServiceMetadata)Mockito.mock(ServiceMetadata.class);
        HashMap<String, ServiceMetadata> edmxMap = new HashMap<String, ServiceMetadata>(Map.of("foo", edmxMetadataMock));
        Assert.assertThrows(NullPointerException.class, () -> EntityModel.of(null, null));
        Assert.assertThrows(NullPointerException.class, () -> EntityModel.of((CdsModel)csnModelMock, null));
        Assert.assertThrows(NullPointerException.class, () -> EntityModel.of(null, (Map)edmxMap));
        EntityModel model = EntityModel.of((CdsModel)csnModelMock, edmxMap);
        Truth.assertThat((Object)model.getCsnModel()).isEqualTo((Object)csnModelMock);
        Truth.assertThat((Object)model.getEdmxMetadata("foo")).isEqualTo((Object)edmxMetadataMock);
        Truth.assertThat((Object)model.getEdmxMetadata("bar")).isNull();
        Truth.assertThat((Map)model.getAllEdmxMetadata()).isEqualTo(edmxMap);
        Truth.assertThat((Map)model.getAllEdmxMetadata()).isNotSameInstanceAs(edmxMap);
        Assert.assertThrows(UnsupportedOperationException.class, () -> model.getAllEdmxMetadata().put("test", null));
    }
}

