/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityVerticleImpl1;
import io.neonbee.entity.EntityVerticleImpl2;
import io.neonbee.entity.EntityVerticleImpl3;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.internal.verticle.ConsolidationVerticle;
import io.neonbee.test.base.EntityVerticleTestBase;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class EntityVerticleTest
extends EntityVerticleTestBase {
    private EntityVerticle entityVerticleImpl1;
    private EntityVerticle entityVerticleImpl2;

    EntityVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService1.csn"));
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void deployEntityVerticles(VertxTestContext testContext) {
        this.entityVerticleImpl1 = new EntityVerticleImpl1();
        this.entityVerticleImpl2 = new EntityVerticleImpl2();
        CompositeFuture.all(this.deployVerticle((Verticle)this.entityVerticleImpl1), this.deployVerticle((Verticle)this.entityVerticleImpl2), this.deployVerticle((Verticle)new EntityVerticleImpl3())).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check if entity types are registered in shared entity map")
    void registerEntityTypes(VertxTestContext testContext) {
        AsyncMap asyncSharedMap = this.getNeonBee().getAsyncMap();
        Checkpoint checkpoint = testContext.checkpoint(2);
        asyncSharedMap.get((Object)EntityVerticle.sharedEntityMapName((FullQualifiedName)new FullQualifiedName("ERP.Customers"))).onComplete(testContext.succeeding(result -> {
            testContext.verify(() -> Truth.assertThat((Iterable)((JsonArray)result)).containsExactly(new Object[]{this.entityVerticleImpl1.getQualifiedName(), this.entityVerticleImpl2.getQualifiedName()}));
            checkpoint.flag();
        }));
        asyncSharedMap.get((Object)EntityVerticle.sharedEntityMapName((FullQualifiedName)new FullQualifiedName("Sales.Orders"))).onComplete(testContext.succeeding(result -> {
            testContext.verify(() -> Truth.assertThat((Iterable)((JsonArray)result)).containsExactly(new Object[]{this.entityVerticleImpl1.getQualifiedName()}));
            checkpoint.flag();
        }));
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check if registered entity types are returned via verticlesForEntityType")
    void queryVerticlesForEntityType(Vertx vertx, VertxTestContext testContext) {
        CompositeFuture.join((Future)EntityVerticle.getVerticlesForEntityType((Vertx)vertx, (FullQualifiedName)new FullQualifiedName("ERP", "Customers")), (Future)EntityVerticle.getVerticlesForEntityType((Vertx)vertx, (FullQualifiedName)new FullQualifiedName("Sales.Orders"))).onComplete(asyncComposite -> {
            CompositeFuture future = (CompositeFuture)asyncComposite.result();
            testContext.verify(() -> {
                Truth.assertThat((Iterable)((Iterable)future.resultAt(0))).containsExactly(new Object[]{this.entityVerticleImpl1.getQualifiedName(), this.entityVerticleImpl2.getQualifiedName()});
                Truth.assertThat((Iterable)((Iterable)future.resultAt(1))).containsExactly(new Object[]{this.entityVerticleImpl1.getQualifiedName()});
                testContext.completeNow();
            });
        });
    }

    @Test
    @DisplayName(value="test EntityVerticle URI_PATH regexp")
    void testEntityURIPathRegex() {
        Matcher matcher = EntityVerticle.URI_PATH_PATTERN.matcher("my.very/own.Service/Entity");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group()).isEqualTo((Object)"my.very/own.Service/Entity");
        Truth.assertThat((String)matcher.group(1)).isEqualTo((Object)"my.very/own.Service");
        Truth.assertThat((String)matcher.group(2)).isEqualTo((Object)"my.very/own");
        Truth.assertThat((String)matcher.group(3)).isEqualTo((Object)"Service");
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
        matcher = EntityVerticle.URI_PATH_PATTERN.matcher("my.Service/Entity");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group()).isEqualTo((Object)"my.Service/Entity");
        Truth.assertThat((String)matcher.group(1)).isEqualTo((Object)"my.Service");
        Truth.assertThat((String)matcher.group(2)).isEqualTo((Object)"my");
        Truth.assertThat((String)matcher.group(3)).isEqualTo((Object)"Service");
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
        matcher = EntityVerticle.URI_PATH_PATTERN.matcher("Service/Entity");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group()).isEqualTo((Object)"Service/Entity");
        Truth.assertThat((String)matcher.group(1)).isEqualTo((Object)"Service");
        Truth.assertThat((String)matcher.group(2)).isNull();
        Truth.assertThat((String)matcher.group(3)).isEqualTo((Object)"Service");
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
        matcher = EntityVerticle.URI_PATH_PATTERN.matcher("Service/Entity(1)");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
        matcher = EntityVerticle.URI_PATH_PATTERN.matcher("Service/Entity(1)/property");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group(1)).isEqualTo((Object)"Service");
        Truth.assertThat((String)matcher.group(4)).isEqualTo((Object)"Entity(1)");
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
        Truth.assertThat((String)matcher.group(6)).isEqualTo((Object)"property");
        matcher = EntityVerticle.URI_PATH_PATTERN.matcher("Service/Entity/$count");
        Truth.assertThat((Boolean)matcher.find()).isTrue();
        Truth.assertThat((String)matcher.group(5)).isEqualTo((Object)"Entity");
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Get URI info from query")
    void parseUriInfoTest(Vertx vertx, VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        EntityVerticle.parseUriInfo((Vertx)vertx, (DataQuery)new DataQuery().setUriPath("/io.neonbee.test1.TestService1/AllPropertiesNullable").addParameter("$format", new String[]{"json"})).onComplete(testContext.succeeding(uriInfo -> testContext.verify(() -> {
            Truth.assertThat((Object)uriInfo).isNotNull();
            Truth.assertThat((String)uriInfo.getSystemQueryOptions().stream().collect(Collectors.toMap(QueryOption::getName, QueryOption::getText)).get("$format")).isEqualTo((Object)"json");
            Truth.assertThat((Iterable)uriInfo.getUriResourceParts().stream().map(UriResource::getSegmentValue).collect(Collectors.toList())).contains((Object)"AllPropertiesNullable");
            checkpoint.flag();
        })));
        EntityVerticle.parseUriInfo((Vertx)vertx, (DataQuery)new DataQuery().setUriPath("/io.neonbee.test1.TestService1/AllPropertiesNullable('123')")).onComplete(testContext.succeeding(uriInfo -> testContext.verify(() -> {
            Truth.assertThat((String)((UriParameter)((UriResourceEntitySet)uriInfo.getUriResourceParts().get(0)).getKeyPredicates().get(0)).getText()).isEqualTo((Object)"'123'");
            checkpoint.flag();
        })));
        EntityVerticle.parseUriInfo((Vertx)vertx, (DataQuery)new DataQuery(DataAction.READ, "/io.neonbee.test1.TestService1/AllPropertiesNullable", "$orderby=KeyPropertyString&$filter=KeyPropertyString eq 'Test123'")).onComplete(testContext.succeeding(uriInfo -> testContext.verify(() -> {
            Truth.assertThat((Iterable)uriInfo.getUriResourceParts().stream().map(UriResource::getSegmentValue).collect(Collectors.toList())).contains((Object)"AllPropertiesNullable");
            checkpoint.flag();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="requestEntity must call ConsolidationVerticle if more then one EntityVerticle is registered for Entity")
    void requestEntityWithConsolidationVerticleTest(VertxTestContext testContext) {
        DataVerticle<EntityWrapper> dummy = this.createDummyDataVerticle(ConsolidationVerticle.QUALIFIED_NAME).withDynamicResponse((dq, dc) -> {
            FullQualifiedName entityTypeName = new FullQualifiedName(dq.getHeader("entityTypeName"));
            Truth.assertThat((Object)entityTypeName).isEqualTo((Object)EntityVerticleImpl1.FQN_ERP_CUSTOMERS);
            testContext.completeNow();
            return new EntityWrapper(EntityVerticleImpl1.FQN_ERP_CUSTOMERS, (Entity)null);
        });
        this.undeployVerticles(ConsolidationVerticle.class).compose(v -> this.deployVerticle((Verticle)dummy)).compose(v -> this.requestEntity(EntityVerticleImpl1.FQN_ERP_CUSTOMERS)).onComplete(testContext.succeeding(v -> {}));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="requestEntity must call ConsolidationVerticle if more then one EntityVerticle is registered for Entity")
    void requestEntityTest(VertxTestContext testContext) {
        this.requestEntity(EntityVerticleImpl3.FQN_TEST_PRODUCTS).onComplete(testContext.succeeding(ew -> testContext.verify(() -> {
            Truth.assertThat((Iterable)ew.getEntities()).containsExactlyElementsIn(EntityVerticleImpl3.TEST_PRODUCTS);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="EntityVerticles should announce their entities, as soon as they are deployed and if the models reload")
    void announceEntityVerticle(Vertx testVertx, VertxTestContext testContext) {
        final Checkpoint checkpoint = testContext.checkpoint(2);
        EntityVerticle dummyEntityVerticle = new EntityVerticle(){

            public Future<Set<FullQualifiedName>> entityTypeNames() {
                checkpoint.flag();
                return Future.succeededFuture(null);
            }
        };
        this.deployVerticle((Verticle)dummyEntityVerticle).onComplete(testContext.succeeding(nextHandler -> testVertx.eventBus().publish(EntityModelManager.EVENT_BUS_MODELS_LOADED_ADDRESS, null)));
    }
}

