/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.truth.Truth;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.partition.PartitionService;
import io.neonbee.NeonBee;
import io.neonbee.health.HazelcastClusterHealthCheck;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class HazelcastClusterHealthCheckTest {
    private NeonBee neonBee;
    private HealthChecks checks;
    private HazelcastClusterManager mockedManager;
    private HazelcastClusterHealthCheck clusterHealthCheck;
    PartitionService mockedPartitionService;
    HazelcastInstance mockedHazelcast;
    LifecycleService mockedLifecycleService;
    Cluster mockedCluster;

    HazelcastClusterHealthCheckTest() {
    }

    @BeforeEach
    void setUp(Vertx vertx) {
        this.checks = HealthChecks.create((Vertx)vertx);
        this.mockedManager = (HazelcastClusterManager)Mockito.mock(HazelcastClusterManager.class);
        this.clusterHealthCheck = new HazelcastClusterHealthCheck(NeonBee.get((Vertx)vertx), this.mockedManager);
        this.neonBee = (NeonBee)Mockito.mock(NeonBee.class);
        this.mockedPartitionService = (PartitionService)Mockito.mock(PartitionService.class);
        this.mockedHazelcast = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        this.mockedLifecycleService = (LifecycleService)Mockito.mock(LifecycleService.class);
        this.mockedCluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)this.neonBee.getVertx()).thenReturn((Object)vertx);
        Mockito.when((Object)this.mockedPartitionService.isClusterSafe()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedHazelcast.getPartitionService()).thenReturn((Object)this.mockedPartitionService);
        Mockito.when((Object)this.mockedLifecycleService.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedHazelcast.getLifecycleService()).thenReturn((Object)this.mockedLifecycleService);
        Mockito.when((Object)this.mockedManager.getHazelcastInstance()).thenReturn((Object)this.mockedHazelcast);
        Mockito.when((Object)this.mockedCluster.getClusterState()).thenReturn((Object)ClusterState.ACTIVE);
        Mockito.when((Object)this.mockedCluster.getMembers()).thenReturn(Set.of(new MemberImpl()));
        Mockito.when((Object)this.mockedHazelcast.getCluster()).thenReturn((Object)this.mockedCluster);
        Truth.assertThat((Boolean)this.clusterHealthCheck.isGlobal()).isTrue();
        Truth.assertThat((String)this.clusterHealthCheck.getId()).startsWith("cluster.");
    }

    private static Stream<Arguments> provideStatus() {
        return Stream.of(Arguments.of((Object[])new Object[]{true, true}), Arguments.of((Object[])new Object[]{true, false}), Arguments.of((Object[])new Object[]{false, true}), Arguments.of((Object[])new Object[]{false, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideStatus"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should set health status only to UP, when cluster state is healthy")
    void testCreateProcedure(boolean clusterUp, boolean serviceUp, VertxTestContext testContext) {
        Mockito.when((Object)this.mockedPartitionService.isClusterSafe()).thenReturn((Object)clusterUp);
        Mockito.when((Object)this.mockedHazelcast.getPartitionService()).thenReturn((Object)this.mockedPartitionService);
        Mockito.when((Object)this.mockedLifecycleService.isRunning()).thenReturn((Object)serviceUp);
        Mockito.when((Object)this.mockedHazelcast.getLifecycleService()).thenReturn((Object)this.mockedLifecycleService);
        Mockito.when((Object)this.mockedManager.getHazelcastInstance()).thenReturn((Object)this.mockedHazelcast);
        Mockito.when((Object)this.mockedCluster.getClusterState()).thenReturn((Object)(clusterUp ? ClusterState.ACTIVE : ClusterState.IN_TRANSITION));
        Mockito.when((Object)this.mockedHazelcast.getCluster()).thenReturn((Object)this.mockedCluster);
        this.clusterHealthCheck.config = new JsonObject().put("expectedClusterSize", (Object)1);
        this.checks.register("cluster.hazelcast", (Handler)this.clusterHealthCheck.createProcedure().apply(this.neonBee));
        this.checks.checkStatus("cluster.hazelcast").onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((Boolean)result.getUp()).isEqualTo((Object)(clusterUp && serviceUp ? 1 : 0));
            Truth.assertThat((Integer)result.getData().size()).isEqualTo((Object)3);
            Truth.assertThat((Integer)result.getData().getInteger("clusterSize")).isEqualTo((Object)1);
            Truth.assertThat((String)result.getData().getString("clusterState")).isEqualTo((Object)(clusterUp ? "ACTIVE" : "IN_TRANSITION"));
            Truth.assertThat((String)result.getData().getString("lifecycleServiceState")).isEqualTo((Object)(serviceUp ? "ACTIVE" : "INACTIVE"));
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should set health status to DOWN if cluster size does not match the expected from config")
    void testClusterSizeBelowExpected(VertxTestContext testContext) {
        this.clusterHealthCheck.config = new JsonObject().put("expectedClusterSize", (Object)3);
        this.checks.register("cluster.hazelcast", (Handler)this.clusterHealthCheck.createProcedure().apply(this.neonBee));
        this.checks.checkStatus("cluster.hazelcast").onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((Boolean)result.getUp()).isFalse();
            Truth.assertThat((Integer)result.getData().getInteger("clusterSize")).isEqualTo((Object)1);
            testContext.completeNow();
        })));
    }
}

