/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.HealthConfig;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.health.DummyHealthCheck;
import io.neonbee.health.HealthCheckException;
import io.neonbee.health.HealthCheckRegistry;
import io.neonbee.health.MemoryHealthCheck;
import io.neonbee.health.internal.HealthCheck;
import io.neonbee.internal.SharedDataAccessor;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.verticle.HealthCheckVerticle;
import io.neonbee.test.helper.DeploymentHelper;
import io.neonbee.test.helper.OptionsHelper;
import io.neonbee.test.helper.ReflectionHelper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={VertxExtension.class})
class HealthCheckRegistryTest {
    private static final long RETENTION_TIME = 12L;
    private NeonBee neonBee;

    HealthCheckRegistryTest() {
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(Vertx vertx) {
        this.neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().setClustered(false), new NeonBeeConfig().setHealthConfig(new HealthConfig().setEnabled(true).setTimeout(2)));
    }

    @Test
    @DisplayName(value="it can list all health checks")
    void getHealthChecks(Vertx vertx) {
        HealthCheckRegistry registry = new HealthCheckRegistry(vertx);
        Truth.assertThat((Map)registry.getHealthChecks()).isEmpty();
        registry.checks.put("check-1", (HealthCheck)Mockito.mock(HealthCheck.class));
        Truth.assertThat((Integer)registry.getHealthChecks().size()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="it can register global checks")
    void registerGlobalCheck() throws HealthCheckException {
        HealthCheck healthCheck = this.neonBee.getHealthCheckRegistry().registerGlobalCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject());
        Truth.assertThat((String)healthCheck.getId()).contains((CharSequence)"dummy");
        Truth.assertThat((Long)healthCheck.getRetentionTime()).isEqualTo((Object)12L);
        Truth.assertThat((Integer)this.neonBee.getHealthCheckRegistry().getHealthChecks().size()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="it can register node checks")
    void registerNodeCheck() throws HealthCheckException {
        HealthCheck healthCheck = this.neonBee.getHealthCheckRegistry().registerNodeCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject());
        Truth.assertThat((String)healthCheck.getId()).matches(Pattern.compile("node." + this.neonBee.getNodeId() + ".dummy"));
        Truth.assertThat((Long)healthCheck.getRetentionTime()).isEqualTo((Object)12L);
        Truth.assertThat((Integer)this.neonBee.getHealthCheckRegistry().getHealthChecks().size()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="it can register HealthChecks via object")
    void register() {
        AbstractHealthCheck check = (AbstractHealthCheck)Mockito.spy((Object)new MemoryHealthCheck(this.neonBee));
        this.neonBee.getHealthCheckRegistry().register(check);
        ((AbstractHealthCheck)Mockito.verify((Object)check)).register((HealthCheckRegistry)ArgumentMatchers.eq((Object)this.neonBee.getHealthCheckRegistry()));
    }

    @Test
    @DisplayName(value="it can only register health checks with unique names")
    void registerHealthCheckOnlyOnce() throws HealthCheckException {
        this.neonBee.getHealthCheckRegistry().registerGlobalCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject());
        HealthCheckException exception = (HealthCheckException)Assertions.assertThrows(HealthCheckException.class, () -> this.neonBee.getHealthCheckRegistry().registerGlobalCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject()));
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"HealthCheck 'dummy' already registered.");
        Truth.assertThat((Integer)this.neonBee.getHealthCheckRegistry().checks.size()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="should prefer disabling of health checks from health check config of config folder")
    void testCustomConfigEnabled(Vertx vertx) throws HealthCheckException {
        this.neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions(), new NeonBeeConfig().setHealthConfig(new HealthConfig().setEnabled(true)));
        HealthCheck check = this.neonBee.getHealthCheckRegistry().registerGlobalCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject().put("enabled", (Object)false));
        Truth.assertThat((Object)check).isNull();
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should prefer enablement of health checks and timeout from health check config of config folder")
    void testCustomConfigDisabled(Vertx vertx) throws HealthCheckException {
        this.neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions(), new NeonBeeConfig().setHealthConfig(new HealthConfig().setEnabled(false).setTimeout(2)));
        this.neonBee.getHealthCheckRegistry().healthChecks = (HealthChecks)Mockito.spy((Object)this.neonBee.getHealthCheckRegistry().healthChecks);
        this.neonBee.getHealthCheckRegistry().registerGlobalCheck("dummy", 12L, nb -> p -> p.complete((Object)new Status()), new JsonObject().put("enabled", (Object)true).put("timeout", (Object)3));
        ((HealthChecks)Mockito.verify((Object)this.neonBee.getHealthCheckRegistry().healthChecks)).register((String)ArgumentMatchers.eq((Object)"dummy"), ArgumentMatchers.eq((long)3000L), (Handler)ArgumentMatchers.any());
        Truth.assertThat((Integer)this.neonBee.getHealthCheckRegistry().checks.size()).isEqualTo((Object)1);
    }

    @Test
    @DisplayName(value="it can unregister health checks by health object and id")
    void testUnregister(VertxTestContext testContext) {
        HealthCheckRegistry registry = this.neonBee.getHealthCheckRegistry();
        registry.healthChecks = (HealthChecks)Mockito.spy((Object)registry.healthChecks);
        DummyHealthCheck check = new DummyHealthCheck(this.neonBee);
        registry.register((AbstractHealthCheck)check).compose(v -> {
            testContext.verify(() -> {
                Truth.assertThat((Integer)registry.checks.size()).isEqualTo((Object)1);
                registry.unregister((HealthCheck)check);
                Truth.assertThat((Integer)registry.checks.size()).isEqualTo((Object)0);
            });
            return registry.register(check);
        }).onComplete(testContext.succeeding(v -> {
            testContext.verify(() -> {
                Truth.assertThat((Integer)registry.checks.size()).isEqualTo((Object)1);
                registry.unregister(check.getId());
                Truth.assertThat((Integer)registry.checks.size()).isEqualTo((Object)0);
                ((HealthChecks)Mockito.verify((Object)registry.healthChecks, (VerificationMode)Mockito.times((int)2))).register((String)ArgumentMatchers.eq((Object)check.getId()), ArgumentMatchers.eq((long)2000L), (Handler)ArgumentMatchers.any());
                ((HealthChecks)Mockito.verify((Object)registry.healthChecks, (VerificationMode)Mockito.times((int)2))).unregister((String)ArgumentMatchers.eq((Object)check.getId()));
            });
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=4, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="it can request data from all health check verticles registered in shared map and consolidates the result")
    void testConsolidateHealthCheckResultsClustered(Vertx vertx, VertxTestContext testContext) throws Exception {
        this.neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().setClustered(true));
        final Checkpoint requestReceivedVerticle1 = testContext.checkpoint();
        final Checkpoint requestReceivedVerticle2 = testContext.checkpoint();
        Checkpoint receivedResultsValidated = testContext.checkpoint();
        HealthCheckVerticle healthCheckVerticle1 = new HealthCheckVerticle(){

            public String getName() {
                return super.getName() + "-test1";
            }

            public Future<JsonArray> retrieveData(DataQuery query, DataContext context) {
                requestReceivedVerticle1.flag();
                return super.retrieveData(query, context);
            }
        };
        HealthCheckVerticle healthCheckVerticle2 = new HealthCheckVerticle(){

            public String getName() {
                return super.getName() + "-test2";
            }

            public Future<JsonArray> retrieveData(DataQuery query, DataContext context) {
                requestReceivedVerticle2.flag();
                return super.retrieveData(query, context);
            }
        };
        String sharedMapName = "#sharedMap";
        AsyncMap sharedMap = (AsyncMap)new SharedDataAccessor(vertx, HealthCheckVerticle.class).getAsyncMap(sharedMapName).result();
        ReflectionHelper.setValueOfPrivateField(this.neonBee, "sharedAsyncMap", sharedMap);
        DeploymentHelper.undeployAllVerticlesOfClass(this.neonBee.getVertx(), HealthCheckVerticle.class).compose(v -> AsyncHelper.allComposite(List.of(vertx.deployVerticle((Verticle)healthCheckVerticle1), vertx.deployVerticle((Verticle)healthCheckVerticle2), this.neonBee.getHealthCheckRegistry().register((AbstractHealthCheck)new DummyHealthCheck(this.neonBee))))).onSuccess(v -> this.neonBee.getHealthCheckRegistry().collectHealthCheckResults().onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Function<String, Long> matchingNameCount = id -> result.getJsonArray("checks").stream().filter(c -> ((JsonObject)c).getString("id").endsWith((String)id)).count();
            Truth.assertThat((Long)matchingNameCount.apply("dummy")).isEqualTo((Object)1);
            Truth.assertThat((String)result.getString("outcome")).isNotNull();
            Truth.assertThat((String)result.getString("status")).isEqualTo((Object)result.getString("outcome"));
            receivedResultsValidated.flag();
        })))).onFailure(arg_0 -> ((VertxTestContext)testContext).failNow(arg_0));
    }

    @Test
    @Timeout(value=4, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="it requests data from local registry only if in non-clustered mode")
    void testConsolidateHealthCheckResultsNonClustered(Vertx vertx, VertxTestContext testContext) {
        final Checkpoint cp = testContext.checkpoint(2);
        HealthCheckRegistry mock = new HealthCheckRegistry(vertx){

            Future<List<JsonObject>> getLocalHealthCheckResults() {
                cp.flag();
                return super.getLocalHealthCheckResults();
            }
        };
        mock.register((AbstractHealthCheck)new DummyHealthCheck(this.neonBee)).compose(hc -> mock.collectHealthCheckResults()).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Function<String, Long> matchingNameCount = id -> result.getJsonArray("checks").stream().filter(c -> ((JsonObject)c).getString("id").equals(id)).count();
            Truth.assertThat((Long)matchingNameCount.apply("dummy")).isEqualTo((Object)1);
            Truth.assertThat((String)result.getString("outcome")).isEqualTo((Object)"UP");
            Truth.assertThat((String)result.getString("status")).isEqualTo((Object)"UP");
            cp.flag();
        })));
    }
}

