/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.helper;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.truth.Truth;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.internal.helper.ConfigHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.JsonObject;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ConfigHelperTest {
    ConfigHelperTest() {
    }

    @Test
    void testReadConfigNotFound() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Truth.assertThat((Throwable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test").cause()).isInstanceOf(FileSystemException.class);
        InOrder orderVerifier = Mockito.inOrder((Object[])new Object[]{fileSystemMock});
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yaml").toAbsolutePath().toString());
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yml").toAbsolutePath().toString());
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.json").toAbsolutePath().toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fileSystemMock});
    }

    @Test
    void testReadConfigException() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file")))).thenReturn((Object)Future.failedFuture((String)"any other exception"));
        Truth.assertThat((Throwable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test").cause()).hasMessageThat().isEqualTo((Object)"any other exception");
        InOrder orderVerifier = Mockito.inOrder((Object[])new Object[]{fileSystemMock});
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yaml").toAbsolutePath().toString());
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yml").toAbsolutePath().toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fileSystemMock});
        Truth.assertThat((Throwable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test", (JsonObject)new JsonObject()).cause()).hasMessageThat().isEqualTo((Object)"any other exception");
    }

    @Test
    void testReadConfigDefault() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        JsonObject defaultObject = new JsonObject();
        Truth.assertThat((Iterable)((Iterable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test", (JsonObject)defaultObject).result())).isSameInstanceAs((Object)defaultObject);
    }

    @Test
    void testReadYamlConfig() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".yaml"))).thenReturn((Object)Future.succeededFuture((Object)Buffer.buffer((String)"---\ntest: Foo")));
        Truth.assertThat((Iterable)((Iterable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test").result())).isEqualTo((Object)new JsonObject().put("test", (Object)"Foo"));
    }

    @Test
    void testReadYmlConfig() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".yml"))).thenReturn((Object)Future.succeededFuture((Object)Buffer.buffer((String)"---\ntest: Foo")));
        Truth.assertThat((Iterable)((Iterable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test").result())).isEqualTo((Object)new JsonObject().put("test", (Object)"Foo"));
    }

    @Test
    void testReadJsonConfig() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".json"))).thenReturn((Object)Future.succeededFuture((Object)Buffer.buffer((String)"{\"test\":\"Foo\"}")));
        Truth.assertThat((Iterable)((Iterable)ConfigHelper.readConfig((Vertx)vertxMock, (String)"test").result())).isEqualTo((Object)new JsonObject().put("test", (Object)"Foo"));
    }

    @Test
    void testRephraseConfigNames() {
        HashBiMap rephraseMap = HashBiMap.create();
        rephraseMap.put((Object)"foo", (Object)"bar");
        rephraseMap.put((Object)"baz", (Object)"qux");
        Truth.assertThat((Iterable)ConfigHelper.rephraseConfigNames((JsonObject)new JsonObject().put("foo", (Object)"test").put("baz", (Object)"test2"), (BiMap)HashBiMap.create(), (boolean)false)).isEqualTo((Object)new JsonObject().put("foo", (Object)"test").put("baz", (Object)"test2"));
        Truth.assertThat((Iterable)ConfigHelper.rephraseConfigNames((JsonObject)new JsonObject().put("foo", (Object)"test").put("baz", (Object)"test2"), (BiMap)rephraseMap, (boolean)false)).isEqualTo((Object)new JsonObject().put("bar", (Object)"test").put("qux", (Object)"test2"));
        Truth.assertThat((Iterable)ConfigHelper.rephraseConfigNames((JsonObject)new JsonObject().put("hello", (Object)"test").put("world", (Object)"test2"), (BiMap)rephraseMap, (boolean)false)).isEqualTo((Object)new JsonObject().put("hello", (Object)"test").put("world", (Object)"test2").put("bar", null).put("qux", null));
        Truth.assertThat((Iterable)ConfigHelper.rephraseConfigNames((JsonObject)new JsonObject().put("bar", (Object)"test").put("qux", (Object)"test2"), (BiMap)rephraseMap, (boolean)true)).isEqualTo((Object)new JsonObject().put("foo", (Object)"test").put("baz", (Object)"test2"));
    }

    @Test
    void testCollectAdditionalConfig() {
        JsonObject object = new JsonObject().put("foo", (Object)"test1").put("bar", (Object)new JsonObject().put("baz", (Object)"test2")).put("baz", (Object)3).put("additionalConfig", (Object)new JsonObject().put("qux", (Object)"test4"));
        Truth.assertThat((Iterable)ConfigHelper.collectAdditionalConfig((JsonObject)object, (String[])new String[0])).isEqualTo((Object)new JsonObject().put("foo", (Object)"test1").put("bar", (Object)new JsonObject().put("baz", (Object)"test2")).put("baz", (Object)3));
        Truth.assertThat((Iterable)ConfigHelper.collectAdditionalConfig((JsonObject)object, (String[])new String[]{"bar"})).isEqualTo((Object)new JsonObject().put("foo", (Object)"test1").put("baz", (Object)3));
        Truth.assertThat((Iterable)ConfigHelper.collectAdditionalConfig((JsonObject)object, (String[])new String[]{"qux"})).isEqualTo((Object)new JsonObject().put("foo", (Object)"test1").put("bar", (Object)new JsonObject().put("baz", (Object)"test2")).put("baz", (Object)3));
        Truth.assertThat((Iterable)ConfigHelper.collectAdditionalConfig((JsonObject)object, (String[])new String[]{"foo", "bar"})).isEqualTo((Object)new JsonObject().put("baz", (Object)3));
        Truth.assertThat((Iterable)ConfigHelper.collectAdditionalConfig((JsonObject)object, (String[])new String[]{"foo", "bar", "baz"})).isEqualTo((Object)new JsonObject());
    }
}

