/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.helper;

import com.google.common.truth.Truth;
import io.neonbee.internal.helper.ThreadHelper;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
class ThreadHelperTest {
    ThreadHelperTest() {
    }

    @Test
    void testGetClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Truth.assertThat((Object)ThreadHelper.getClassLoader()).isEqualTo((Object)contextClassLoader);
            Thread.currentThread().setContextClassLoader(null);
            Truth.assertThat((Object)ThreadHelper.getClassLoader()).isEqualTo((Object)this.getClass().getClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Test
    void testGetOwnClass() {
        Truth.assertThat((Class)ThreadHelper.getOwnClass()).isEqualTo(ThreadHelperTest.class);
        Truth.assertThat(ThreadHelperTest.getOwnClassStatic()).isEqualTo(ThreadHelperTest.class);
        Truth.assertThat(InnerClass.getOwnClassStatic()).isEqualTo(InnerClass.class);
        Truth.assertThat(new InnerClass().getOwnClass()).isEqualTo(InnerClass.class);
        Truth.assertThat(new InnerClass().getOwnClassFromInnerClass()).isEqualTo(InnerClass.InnerInnerClass.class);
        Truth.assertThat(new InnerClass().new InnerClass.InnerInnerClass().getOwnClass()).isEqualTo(InnerClass.InnerInnerClass.class);
        Truth.assertThat(new InnerClass().new InnerClass.InnerInnerClass().alsoGetOwnClass()).isEqualTo(InnerClass.InnerInnerClass.class);
    }

    @Test
    void testGetCallingClass() {
        Truth.assertThat((String)ThreadHelper.getCallingClass().getPackageName()).startsWith("org.junit");
        Truth.assertThat((String)ThreadHelperTest.getCallingClassStatic().getPackageName()).startsWith("org.junit");
        Truth.assertThat(InnerClass.getCallingClassStatic()).isEqualTo(ThreadHelperTest.class);
        Truth.assertThat(new InnerClass().getCallingClass()).isEqualTo(ThreadHelperTest.class);
        Truth.assertThat(new InnerClass().getCallingClassFromInnerClass()).isEqualTo(InnerClass.class);
        Truth.assertThat(new InnerClass().new InnerClass.InnerInnerClass().getCallingClass()).isEqualTo(ThreadHelperTest.class);
        Truth.assertThat(new InnerClass().new InnerClass.InnerInnerClass().alsoGetCallingClass()).isEqualTo(ThreadHelperTest.class);
    }

    static Class<?> getOwnClassStatic() {
        return ThreadHelper.getOwnClass();
    }

    static Class<?> getCallingClassStatic() {
        return ThreadHelper.getCallingClass();
    }

    static class InnerClass {
        InnerClass() {
        }

        Class<?> getOwnClass() {
            return ThreadHelper.getOwnClass();
        }

        Class<?> getOwnClassFromInnerClass() {
            return new InnerInnerClass().getOwnClass();
        }

        Class<?> getCallingClass() {
            return ThreadHelper.getCallingClass();
        }

        Class<?> getCallingClassFromInnerClass() {
            return new InnerInnerClass().getCallingClass();
        }

        static Class<?> getOwnClassStatic() {
            return ThreadHelper.getOwnClass();
        }

        static Class<?> getCallingClassStatic() {
            return ThreadHelper.getCallingClass();
        }

        class InnerInnerClass {
            InnerInnerClass() {
            }

            Class<?> getOwnClass() {
                return ThreadHelper.getOwnClass();
            }

            Class<?> alsoGetOwnClass() {
                return this.getOwnClass();
            }

            Class<?> getCallingClass() {
                return ThreadHelper.getCallingClass();
            }

            Class<?> alsoGetCallingClass() {
                return this.getCallingClass();
            }
        }
    }
}

