/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook.internal;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.hook.HookContext;
import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookType;
import io.neonbee.hook.internal.DefaultHookRegistration;
import io.neonbee.hook.internal.DefaultHookRegistry;
import io.neonbee.hook.internal.HookClassTemplate;
import io.neonbee.internal.BasicJar;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class DefaultHookRegistrationTest {
    private DefaultHookRegistry hookRegistry;
    private Object instanceWithHook;
    private Method hookMethod;
    private DefaultHookRegistration defaultHookRegistration;

    DefaultHookRegistrationTest() {
    }

    @BeforeEach
    void setup(Vertx vertx) throws Exception {
        this.hookRegistry = new DefaultHookRegistry(vertx);
        BasicJar jarWithHookAnnotation = new HookClassTemplate(HookClassTemplate.VALID_HOOK_TEMPLATE, "HodorHook", "hook").setMethodAnnotation("@Hook(HookType.ONCE_PER_REQUEST)").asJar();
        URLClassLoader loader = new URLClassLoader(jarWithHookAnnotation.writeToTempURL(), ClassLoader.getSystemClassLoader());
        Class<?> classWithValidHook = loader.loadClass("hook.HodorHook");
        this.instanceWithHook = classWithValidHook.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.hookMethod = classWithValidHook.getMethod("doNothing", NeonBee.class, HookContext.class, Promise.class);
        this.defaultHookRegistration = new DefaultHookRegistration(this.hookRegistry, this.instanceWithHook, this.hookMethod, HookType.ONCE_PER_REQUEST);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that unregister works correct")
    void testUnregister(VertxTestContext testContext) {
        this.hookRegistry.registerInstanceHooks(this.instanceWithHook, "correlId").compose(registrations -> {
            testContext.verify(() -> Truth.assertThat((Iterable)registrations).hasSize(1));
            HookRegistration currentHookRegistration = (HookRegistration)registrations.stream().findFirst().get();
            return this.hookRegistry.getHookRegistrations().compose(allRegistrations -> {
                testContext.verify(() -> Truth.assertThat((Iterable)allRegistrations).containsExactly(new Object[]{currentHookRegistration}));
                return currentHookRegistration.unregister();
            });
        }).compose(v -> this.hookRegistry.getHookRegistrations()).onComplete(testContext.succeeding(allRegistrations -> testContext.verify(() -> {
            Truth.assertThat((Iterable)allRegistrations).isEmpty();
            testContext.completeNow();
        })));
    }

    @Test
    @DisplayName(value="Check that getters of DefaultHookRegistration are working correct")
    void testGetters() {
        Truth.assertThat((String)this.defaultHookRegistration.getId()).isNotNull();
        Truth.assertThat((Object)this.defaultHookRegistration.getRelatedObject()).isEqualTo(this.instanceWithHook);
        Truth.assertThat((Object)this.defaultHookRegistration.getHookMethod()).isEqualTo((Object)this.hookMethod);
        Truth.assertThat((Comparable)this.defaultHookRegistration.getType()).isEqualTo((Object)HookType.ONCE_PER_REQUEST);
        Truth.assertThat((String)this.defaultHookRegistration.getName()).isEqualTo((Object)"hook.HodorHook::doNothing");
    }

    @Test
    @DisplayName(value="Check that equals works correct")
    void testEquals() {
        DefaultHookRegistration defaultHookRegistrationClone = new DefaultHookRegistration(this.hookRegistry, this.instanceWithHook, this.hookMethod, HookType.ONCE_PER_REQUEST);
        DefaultHookRegistration differentHookRegistration = new DefaultHookRegistration(this.hookRegistry, this.instanceWithHook, this.hookMethod, HookType.BEFORE_BOOTSTRAP);
        Truth.assertThat((Object)defaultHookRegistrationClone).isEqualTo((Object)defaultHookRegistrationClone);
        Truth.assertThat((Object)defaultHookRegistrationClone).isEqualTo((Object)this.defaultHookRegistration);
        Truth.assertThat((Object)differentHookRegistration).isNotEqualTo((Object)this.defaultHookRegistration);
        Truth.assertThat((Object)differentHookRegistration).isNotEqualTo(null);
    }

    @Test
    @DisplayName(value="Check that equals works correct")
    void testHashcode() {
        DefaultHookRegistration defaultHookRegistrationClone = new DefaultHookRegistration(this.hookRegistry, this.instanceWithHook, this.hookMethod, HookType.ONCE_PER_REQUEST);
        DefaultHookRegistration differentHookRegistration = new DefaultHookRegistration(this.hookRegistry, this.instanceWithHook, this.hookMethod, HookType.BEFORE_SHUTDOWN);
        Truth.assertThat((Integer)this.defaultHookRegistration.hashCode()).isEqualTo((Object)defaultHookRegistrationClone.hashCode());
        Truth.assertThat((Integer)differentHookRegistration.hashCode()).isNotEqualTo((Object)this.defaultHookRegistration.hashCode());
        Truth.assertThat((Integer)differentHookRegistration.hashCode()).isNotEqualTo((Object)"".hashCode());
    }
}

