/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook.internal;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.hook.Hook;
import io.neonbee.hook.HookContext;
import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookType;
import io.neonbee.hook.internal.DefaultHookRegistration;
import io.neonbee.hook.internal.DefaultHookRegistry;
import io.neonbee.hook.internal.HookClassTemplate;
import io.neonbee.internal.BasicJar;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class DefaultHookRegistryTest {
    private static final String CORRELATION_ID = "bliblablub";
    private DefaultHookRegistry hookRegistry;
    private Class<?> classWithValidHook;

    DefaultHookRegistryTest() {
    }

    @BeforeEach
    void setup(Vertx vertx) throws Exception {
        this.hookRegistry = new DefaultHookRegistry(vertx);
        BasicJar jarWithHookAnnotation = new HookClassTemplate(HookClassTemplate.VALID_HOOK_TEMPLATE, "HodorHook", "hook").setMethodAnnotation("@Hook(HookType.ONCE_PER_REQUEST)").asJar();
        URLClassLoader loader = new URLClassLoader(jarWithHookAnnotation.writeToTempURL(), ClassLoader.getSystemClassLoader());
        this.classWithValidHook = loader.loadClass("hook.HodorHook");
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that hook from passed object were loaded correct")
    void registerInstanceHooksSuccessTest(VertxTestContext testContext) throws Exception {
        Object instanceWithHook = this.classWithValidHook.getConstructor(new Class[0]).newInstance(new Object[0]);
        Method hookMethod = this.classWithValidHook.getMethod("doNothing", NeonBee.class, HookContext.class, Promise.class);
        DefaultHookRegistration expectedRegistration = new DefaultHookRegistration(this.hookRegistry, instanceWithHook, hookMethod, HookType.ONCE_PER_REQUEST);
        this.hookRegistry.registerInstanceHooks(instanceWithHook, CORRELATION_ID).onComplete(testContext.succeeding(arg_0 -> DefaultHookRegistryTest.lambda$registerInstanceHooksSuccessTest$3(testContext, (HookRegistration)expectedRegistration, arg_0)));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that hook from passed object were loaded correct")
    void registerInstanceHooksFailTest(VertxTestContext testContext) throws Exception {
        BasicJar jarWithHookAnnotation = new HookClassTemplate(HookClassTemplate.INVALID_HOOK_TEMPLATE, "InvalidHodorHook", "hook").setMethodAnnotation("@Hook(HookType.ONCE_PER_REQUEST)").asJar();
        URLClassLoader loader = new URLClassLoader(jarWithHookAnnotation.writeToTempURL(), ClassLoader.getSystemClassLoader());
        Class<?> classWithInvalidHook = loader.loadClass("hook.InvalidHodorHook");
        this.hookRegistry.registerHooks(classWithInvalidHook, CORRELATION_ID).onComplete(testContext.succeeding(hookRegistrations -> testContext.verify(() -> {
            Truth.assertThat((Iterable)hookRegistrations).hasSize(0);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that executeHooks works correct")
    void executeHooksTest(VertxTestContext testContext) {
        TestHook hook = new TestHook();
        this.hookRegistry.registerInstanceHooks((Object)hook, CORRELATION_ID).compose(v -> this.hookRegistry.executeHooks(HookType.ONCE_PER_REQUEST, Map.of())).onComplete(testContext.succeeding(compFuture -> {
            Truth.assertThat((Iterable)compFuture.list()).hasSize(1);
            Truth.assertThat((Boolean)TestHook.wasExecuted).isTrue();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that getHookRegistrations works correct")
    void getHookRegistruationsTest(VertxTestContext testContext) {
        this.hookRegistry.registerHooks(this.classWithValidHook, CORRELATION_ID).compose(hookRegistrations -> this.hookRegistry.getHookRegistrations().onComplete(testContext.succeeding(allRegistrations -> testContext.verify(() -> {
            Truth.assertThat((Iterable)hookRegistrations).hasSize(1);
            Truth.assertThat((Iterable)allRegistrations).containsExactlyElementsIn((Iterable)hookRegistrations);
            testContext.completeNow();
        }))));
    }

    private static /* synthetic */ void lambda$registerInstanceHooksSuccessTest$3(VertxTestContext testContext, HookRegistration expectedRegistration, Collection hookRegistrations) {
        testContext.verify(() -> {
            Truth.assertThat((Iterable)hookRegistrations).hasSize(1);
            hookRegistrations.stream().findFirst().ifPresentOrElse(current -> {
                Truth.assertThat((String)current.getName()).isEqualTo((Object)expectedRegistration.getName());
                Truth.assertThat((Comparable)current.getType()).isEqualTo((Object)expectedRegistration.getType());
            }, () -> testContext.failNow((Throwable)new RuntimeException("Hook registration was not found")));
            testContext.completeNow();
        });
    }

    public static class TestHook {
        static boolean wasExecuted;

        @Hook(value=HookType.ONCE_PER_REQUEST)
        public void test(NeonBee neonBee, HookContext hookContext, Promise<Void> promise) {
            wasExecuted = true;
            promise.complete();
        }
    }
}

