/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import com.google.common.base.Predicates;
import com.google.common.truth.Truth;
import io.neonbee.internal.BasicJar;
import io.neonbee.internal.ClassTemplate;
import io.neonbee.internal.NeonBeeModuleJar;
import io.neonbee.internal.SelfFirstClassLoader;
import io.neonbee.test.helper.FileSystemHelper;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;

@ExtendWith(value={VertxExtension.class})
@Isolated(value="all tests are modifying the current threads class-loader")
class SelfFirstClassLoaderTest {
    private static final String CLASS_NAME = "CoolTestClassWithUniqueName";
    private static final String RESOURCE_NAME = "CoolResourceWithUniqueName";
    private static final String ADDRESS_PLATFORM = "addressPlatform";
    private static final byte[] RESOURCE_CONTENT_PLATFORM = "PlatformContent".getBytes(StandardCharsets.UTF_8);
    private ClassLoader originalContextClassLoader;

    SelfFirstClassLoaderTest() {
    }

    @BeforeEach
    void setUp() {
        this.originalContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @AfterEach
    void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
    }

    @Test
    @DisplayName(value="Test if the decision logic which class should be loaded from parent works correct")
    void testLoadFromParent() throws IOException {
        SelfFirstClassLoader sfcl = new SelfFirstClassLoader(new URL[0], null, List.of("io.neonbee.*", "io.Hod*", "io.vertx.*.TestClass", "com.example.LordCitrange"));
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.neonbee.DataVerticle")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.Hodor")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("com.example.LordCitrange")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.vertx.any.TestClass")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.vertx.other.TestClass")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.hodor.Hodor")).isFalse();
        Truth.assertThat((Boolean)sfcl.loadFromParent("com.example.Hodor")).isFalse();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.NeonBee")).isFalse();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.neonbeefoo.Lol")).isFalse();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.vertx.any.testClass")).isFalse();
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.verty.any.TestClass")).isFalse();
        sfcl.close();
    }

    @Test
    @DisplayName(value="Test if the decision logic which class should be loaded from parent works correct if only a wildcard is passed")
    void testLoadFromParentWithOnlyWildcard() throws IOException {
        SelfFirstClassLoader sfcl = new SelfFirstClassLoader(new URL[0], null, List.of("*"));
        Truth.assertThat((Boolean)sfcl.loadFromParent("io.neonbee.DataVerticle")).isTrue();
        Truth.assertThat((Boolean)sfcl.loadFromParent("com.example.LordCitrange")).isTrue();
        sfcl.close();
    }

    @Test
    @DisplayName(value="Test if empty or null strings are filtered out from passed parentPreferred strings")
    void testLoadFromParentWithEmptyOrNullStrings() throws IOException {
        List<String> expected = List.of("io.hodor.Hodor", "lord.Citrange");
        ArrayList<String> parentPreferred = new ArrayList<String>(expected);
        parentPreferred.add("");
        parentPreferred.add(null);
        SelfFirstClassLoader sfcl = new SelfFirstClassLoader(new URL[0], null, parentPreferred);
        Truth.assertThat((Boolean)sfcl.parentPreferredPredicate.test("io.hodor.Hodor")).isTrue();
        Truth.assertThat((Boolean)sfcl.parentPreferredPredicate.test("lord.Citrange")).isTrue();
        Truth.assertThat((Boolean)sfcl.parentPreferredPredicate.test("")).isFalse();
        sfcl.close();
    }

    @Test
    @DisplayName(value="Test if an empty list will result in everything being loaded from the own classloader")
    void testLoadFromOwnClassLoaderIfEmpty() throws IOException {
        SelfFirstClassLoader sfcl = new SelfFirstClassLoader(new URL[0], null);
        Truth.assertThat((Object)sfcl.parentPreferredPredicate).isSameInstanceAs((Object)Predicates.alwaysFalse());
        sfcl.close();
        ArrayList<String> parentPreferred = new ArrayList<String>();
        parentPreferred.add("");
        parentPreferred.add(null);
        sfcl = new SelfFirstClassLoader(new URL[0], null, parentPreferred);
        Truth.assertThat((Object)sfcl.parentPreferredPredicate).isSameInstanceAs((Object)Predicates.alwaysFalse());
        sfcl.close();
    }

    @Test
    @DisplayName(value="Test if parent preferred classes are loaded from parent class loader")
    void testParentPreferred() throws IOException, ClassNotFoundException {
        String otherClass = "OtherUniqueClassName";
        URLClassLoader parentClassLoader = SelfFirstClassLoaderTest.createClassLoaderWithJars(List.of(new NeonBeeModuleJar("testmodule1", new IsoVerticleTemplate(CLASS_NAME, "parentAddress")), new NeonBeeModuleJar("testmodule2", new IsoVerticleTemplate(otherClass, "onlyParent"))), ClassLoader.getSystemClassLoader());
        Class<?> verticleClassFromParent = parentClassLoader.loadClass(CLASS_NAME);
        Class<?> otherClassFromParent = parentClassLoader.loadClass(otherClass);
        URLClassLoader childClassLoader = SelfFirstClassLoaderTest.createClassLoaderWithJars(List.of(new NeonBeeModuleJar("testmodule3", new IsoVerticleTemplate(CLASS_NAME, "childAddress")), new NeonBeeModuleJar("testmodule4", new IsoVerticleTemplate(otherClass, "onlyChild"))), parentClassLoader, List.of(CLASS_NAME));
        Class<?> verticleClassFromChild = childClassLoader.loadClass(CLASS_NAME);
        Class<?> otherClassFromChild = childClassLoader.loadClass(otherClass);
        Truth.assertThat(verticleClassFromParent).isSameInstanceAs(verticleClassFromChild);
        Truth.assertThat(otherClassFromParent).isNotSameInstanceAs(otherClassFromChild);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Deployments must be able to load a different versions of a class, even if platform already uses this class")
    void loadClassesIsolatedTest(Vertx vertx, VertxTestContext testContext) throws ClassNotFoundException, IOException {
        Checkpoint cp = testContext.checkpoint(2);
        IsoVerticleTemplate platformVerticleTemplate = new IsoVerticleTemplate(CLASS_NAME, ADDRESS_PLATFORM);
        NeonBeeModuleJar platformVerticleJar = new NeonBeeModuleJar("testmodule", platformVerticleTemplate);
        BasicJar platformResourceJar = new BasicJar(Map.of(RESOURCE_NAME, RESOURCE_CONTENT_PLATFORM));
        URLClassLoader applicationClassLoader = SelfFirstClassLoaderTest.createClassLoaderWithJars(List.of(platformVerticleJar, platformResourceJar), ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(applicationClassLoader);
        Class<Verticle> platformVerticleClass = applicationClassLoader.loadClass(CLASS_NAME);
        this.deployVerticle(platformVerticleClass, vertx, testContext).compose(s -> platformVerticleTemplate.sendAndVerifyPing(vertx, testContext)).compose(v -> platformVerticleTemplate.getResourceAsString(RESOURCE_NAME, vertx, testContext)).onComplete(testContext.succeeding(resourceContent -> {
            testContext.verify(() -> Truth.assertThat((String)resourceContent).isEqualTo((Object)new String(RESOURCE_CONTENT_PLATFORM, StandardCharsets.UTF_8)));
            cp.flag();
        }));
        String otherAddress = "otherAddress";
        IsoVerticleTemplate otherVerticleTemplate = new IsoVerticleTemplate(CLASS_NAME, otherAddress);
        NeonBeeModuleJar otherVerticleJar = new NeonBeeModuleJar("testmodule", otherVerticleTemplate);
        byte[] resourceContentOther = "OtherContent".getBytes(StandardCharsets.UTF_8);
        BasicJar otherResourceJar = new BasicJar(Map.of(RESOURCE_NAME, resourceContentOther));
        URLClassLoader otherClassLoader = SelfFirstClassLoaderTest.createClassLoaderWithJars(List.of(otherVerticleJar, otherResourceJar), applicationClassLoader);
        Class<Verticle> otherVerticleClass = otherClassLoader.loadClass(CLASS_NAME);
        this.deployVerticle(otherVerticleClass, vertx, testContext).compose(s -> otherVerticleTemplate.sendAndVerifyPing(vertx, testContext)).compose(v -> otherVerticleTemplate.getResourceAsString(RESOURCE_NAME, vertx, testContext)).onComplete(testContext.succeeding(resourceContent -> {
            testContext.verify(() -> Truth.assertThat((String)resourceContent).isEqualTo((Object)new String(resourceContentOther, StandardCharsets.UTF_8)));
            cp.flag();
        }));
    }

    private Future<String> deployVerticle(Class<Verticle> verticleClass, Vertx vertx, VertxTestContext testContext) {
        return vertx.deployVerticle(verticleClass, new DeploymentOptions()).onFailure(arg_0 -> ((VertxTestContext)testContext).failNow(arg_0));
    }

    private static URLClassLoader createClassLoaderWithJars(List<BasicJar> jars, ClassLoader parent) throws IOException {
        return SelfFirstClassLoaderTest.createClassLoaderWithJars(jars, parent, Collections.emptyList());
    }

    private static URLClassLoader createClassLoaderWithJars(List<BasicJar> jars, ClassLoader parent, List<String> parentPreferred) throws IOException {
        Path tempDir = FileSystemHelper.createTempDirectory();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (BasicJar jar : jars) {
            Path path = tempDir.resolve(UUID.randomUUID().toString() + ".jar");
            jar.writeToFile(path);
            urls.add(path.toUri().toURL());
        }
        URL[] urlsArray = new URL[urls.size()];
        urlsArray = urls.toArray(urlsArray);
        return new SelfFirstClassLoader(urlsArray, parent, parentPreferred);
    }

    private static class IsoVerticleTemplate
    implements ClassTemplate {
        private final String className;
        private final String ebAddress;
        private final String template;

        IsoVerticleTemplate(String className, String ebAddress) throws IOException {
            this.className = className;
            this.ebAddress = ebAddress;
            this.template = ResourceHelper.TEST_RESOURCES.getRelated("IsoVerticle.java.template").toString();
        }

        public Future<Void> sendAndVerifyPing(Vertx vertx, VertxTestContext testContext) {
            return vertx.eventBus().request(this.ebAddress.concat("/ping"), (Object)"").onComplete(testContext.succeeding(resp -> testContext.verify(() -> Truth.assertThat((Object)resp.body()).isEqualTo((Object)("Pong from: " + this.ebAddress))))).mapEmpty();
        }

        public Future<String> getResourceAsString(String resourceName, Vertx vertx, VertxTestContext testContext) {
            return vertx.eventBus().request(this.ebAddress + "/resources", (Object)resourceName).onFailure(arg_0 -> ((VertxTestContext)testContext).failNow(arg_0)).map(Message::body);
        }

        @Override
        public String reifyTemplate() {
            return this.template.replace("<VerticleClassName>", this.className).replace("<address>", this.ebAddress);
        }

        @Override
        public String getSimpleName() {
            return this.className;
        }

        @Override
        public String getPackageName() {
            return null;
        }
    }
}

