/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.buffer;

import com.google.common.truth.Truth;
import io.neonbee.internal.buffer.CompositeBuffer;
import io.neonbee.internal.buffer.ImmutableBuffer;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CompositeBufferTest {
    CompositeBufferTest() {
    }

    @Test
    void testStaticConstructor() {
        Buffer buffer1 = Buffer.buffer((String)"foo");
        Buffer buffer2 = Buffer.buffer((String)"bar");
        Buffer buffer3 = Buffer.buffer((String)"baz");
        Truth.assertThat((Object)CompositeBuffer.buffer((Buffer[])new Buffer[0])).isSameInstanceAs((Object)ImmutableBuffer.EMPTY);
        Buffer compositeBuffer1 = CompositeBuffer.buffer((Buffer[])new Buffer[]{buffer1});
        Truth.assertThat((Object)compositeBuffer1).isEqualTo((Object)buffer1);
        Truth.assertThat((Object)compositeBuffer1).isNotSameInstanceAs((Object)buffer1);
        Truth.assertThat((Object)compositeBuffer1).isInstanceOf(ImmutableBuffer.class);
        ImmutableBuffer immutableBuffer1 = (ImmutableBuffer)compositeBuffer1;
        compositeBuffer1 = CompositeBuffer.buffer((Buffer[])new Buffer[]{immutableBuffer1});
        Truth.assertThat((Object)compositeBuffer1).isSameInstanceAs((Object)immutableBuffer1);
        Buffer buffer12 = CompositeBuffer.buffer((Buffer[])new Buffer[]{buffer1, buffer2});
        Truth.assertThat((Integer)buffer12.length()).isEqualTo((Object)(buffer1.length() + buffer2.length()));
        Truth.assertThat((String)buffer12.toString()).isEqualTo((Object)(buffer1.toString() + buffer2.toString()));
        Buffer buffer123 = CompositeBuffer.buffer((Buffer[])new Buffer[]{buffer1, buffer2, buffer3});
        Truth.assertThat(buffer123.getClass()).isEqualTo(ImmutableBuffer.class);
        Truth.assertThat((String)buffer123.toString()).isEqualTo((Object)"foobarbaz");
        Buffer buffer12plus3 = CompositeBuffer.buffer((Buffer[])new Buffer[]{buffer12, buffer3});
        Truth.assertThat((Object)buffer12plus3).isEqualTo((Object)buffer123);
    }

    @Test
    void testImmutable() {
        Buffer buffer = CompositeBuffer.buffer((Buffer[])new Buffer[]{Buffer.buffer((String)"foo"), Buffer.buffer((String)"bar")});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.writeToBuffer(Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBuffer(Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBuffer(Buffer.buffer(), 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBytes(new byte[]{1}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBytes(new byte[]{1}, 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendByte((byte)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedByte((short)2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendInt(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendIntLE(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedInt(4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedIntLE(4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendMedium(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendMediumLE(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendLong(5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendLongLE(5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendShort((short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendShortLE((short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedShort(7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedShortLE(7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendFloat(8.0f));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendDouble(9.1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendString("foo", "UTF-8"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendString("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setByte(0, (byte)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedByte(0, (short)2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setInt(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setIntLE(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedInt(0, 4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedIntLE(0, 4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setMedium(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setMediumLE(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setLong(0, 5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setLongLE(0, 5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setDouble(0, 9.1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setFloat(0, 8.0f));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setShort(0, (short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setShortLE(0, (short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedShort(0, 7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedShortLE(0, 7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBuffer(0, Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBuffer(0, Buffer.buffer(), 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, ByteBuffer.allocate(1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, new byte[]{11}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, new byte[]{11}, 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setString(0, "foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setString(0, "foo", "UTF-8"));
    }
}

