/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.buffer;

import com.google.common.truth.Truth;
import io.neonbee.internal.buffer.ImmutableBuffer;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ImmutableBufferTest {
    ImmutableBufferTest() {
    }

    @Test
    void testStaticConstructors() {
        Truth.assertThat((Object)ImmutableBuffer.buffer()).isInstanceOf(ImmutableBuffer.class);
        Truth.assertThat((Object)ImmutableBuffer.buffer()).isEqualTo((Object)ImmutableBuffer.EMPTY);
        Truth.assertThat((Object)ImmutableBuffer.buffer()).isSameInstanceAs((Object)ImmutableBuffer.EMPTY);
        Truth.assertThat((Object)ImmutableBuffer.buffer()).isSameInstanceAs((Object)ImmutableBuffer.buffer());
        Buffer anyBuffer = Buffer.buffer((String)"any");
        ImmutableBuffer anyImmutableBuffer = ImmutableBuffer.buffer((Buffer)Buffer.buffer((String)"anyOther"));
        Truth.assertThat((Object)ImmutableBuffer.buffer((Buffer)anyBuffer)).isInstanceOf(ImmutableBuffer.class);
        Truth.assertThat((Object)ImmutableBuffer.buffer((Buffer)anyImmutableBuffer)).isSameInstanceAs((Object)anyImmutableBuffer);
        Truth.assertThat((Object)ImmutableBuffer.buffer((Buffer)anyBuffer)).isNotSameInstanceAs((Object)anyBuffer);
        Truth.assertThat((Object)ImmutableBuffer.buffer((Buffer)anyBuffer)).isEqualTo((Object)anyBuffer);
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableBuffer.buffer(null));
    }

    @Test
    void testGetBuffer() {
        Buffer anyBuffer = Buffer.buffer((String)"any");
        Buffer anyImmutableBuffer = ImmutableBuffer.buffer((Buffer)anyBuffer).getBuffer();
        Truth.assertThat((Object)anyBuffer).isEqualTo((Object)anyImmutableBuffer);
        Truth.assertThat((Boolean)anyBuffer.getByteBuf().isReadOnly()).isFalse();
        Truth.assertThat((Boolean)anyImmutableBuffer.getByteBuf().isReadOnly()).isTrue();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> anyImmutableBuffer.getByteBuf().writeInt(1));
    }

    @Test
    void testEmptyBuffer() {
        Truth.assertThat((Integer)ImmutableBuffer.EMPTY.length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableBuffer.EMPTY.getBytes().length).isEqualTo((Object)0);
    }

    @Test
    void testImmutable() {
        ImmutableBuffer buffer = new ImmutableBuffer();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.writeToBuffer(Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBuffer(Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBuffer(Buffer.buffer(), 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBytes(new byte[]{1}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendBytes(new byte[]{1}, 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendByte((byte)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedByte((short)2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendInt(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendIntLE(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedInt(4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedIntLE(4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendMedium(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendMediumLE(3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendLong(5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendLongLE(5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendShort((short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendShortLE((short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedShort(7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendUnsignedShortLE(7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendFloat(8.0f));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendDouble(9.1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendString("foo", "UTF-8"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.appendString("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setByte(0, (byte)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedByte(0, (short)2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setInt(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setIntLE(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedInt(0, 4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedIntLE(0, 4L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setMedium(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setMediumLE(0, 3));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setLong(0, 5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setLongLE(0, 5L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setDouble(0, 9.1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setFloat(0, 8.0f));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setShort(0, (short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setShortLE(0, (short)6));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedShort(0, 7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setUnsignedShortLE(0, 7));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBuffer(0, Buffer.buffer()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBuffer(0, Buffer.buffer(), 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, ByteBuffer.allocate(1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, new byte[]{11}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setBytes(0, new byte[]{11}, 1, 1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setString(0, "foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> buffer.setString(0, "foo", "UTF-8"));
    }

    @Test
    void testImmutableConstruction() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableBuffer().setString(0, "keyX"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableBuffer(Buffer.buffer((String)"test")).setString(0, "keyX"));
    }

    @Test
    void testGetPrimitives() {
        ImmutableBuffer buffer = new ImmutableBuffer(Buffer.buffer((byte[])new byte[]{1, 2, 3, 4, 5}));
        Truth.assertThat((Comparable)Byte.valueOf(buffer.getByte(0))).isEqualTo((Object)1);
        Truth.assertThat((byte[])buffer.getBytes()).isEqualTo((Object)new byte[]{1, 2, 3, 4, 5});
        Truth.assertThat((byte[])buffer.getBytes(1, 4)).isEqualTo((Object)new byte[]{2, 3, 4});
    }

    @Test
    void testMutableCopyIsMutable() {
        Assertions.assertDoesNotThrow(() -> new ImmutableBuffer().mutableCopy().appendMedium(1));
        Assertions.assertDoesNotThrow(() -> new ImmutableBuffer(Buffer.buffer((String)"foo")).mutableCopy().appendString("bar"));
    }

    @Test
    void testCopyIsAlsoNotMutable() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableBuffer().copy().setInt(0, 1));
    }

    @Test
    void testStandardMethods() {
        Buffer buffer = Buffer.buffer((byte[])new byte[]{1, 2, 3, 4, 5});
        ImmutableBuffer immutableBuffer = new ImmutableBuffer(buffer);
        Truth.assertThat((String)immutableBuffer.toString()).isEqualTo((Object)buffer.toString());
        Truth.assertThat((Integer)immutableBuffer.hashCode()).isEqualTo((Object)buffer.hashCode());
        Truth.assertThat((Object)immutableBuffer).isEqualTo((Object)buffer);
        Truth.assertThat((Object)immutableBuffer).isEqualTo((Object)new ImmutableBuffer(buffer));
        Truth.assertThat((Object)immutableBuffer).isEqualTo((Object)Buffer.buffer((byte[])new byte[]{1, 2, 3, 4, 5}));
        Truth.assertThat((Object)immutableBuffer).isEqualTo((Object)new ImmutableBuffer(Buffer.buffer((byte[])new byte[]{1, 2, 3, 4, 5})));
        Truth.assertThat((Object)immutableBuffer).isNotEqualTo((Object)ImmutableBuffer.EMPTY);
    }
}

